<?php

/**
 * 附件管理Action
 * @author     bant
 * @copyright  (C) 2011-2014 EXCMS
 * @license    http://www.zyxfeng.com/license/
 * @version    1.0
 * @createTime 2013-4-11
 * @updateTime 2013-4-11
 */
class AttachmentManageAction extends AdminBaseAction {

    // 附件目录
    protected $filePath;
    // 附件Serivce
    protected $attachmentService;

    public function _initialize() {
        parent::_initialize();

        $this->filePath = C('UPLOAD_FILE_PATH');
        $this->attachmentService = BService('Attachment');
    }

    /**
     * 附件列表
     */
    public function index() {
        $map = array();
        $searchInfo = $this->_get();

        if ($searchInfo['search'] == 1) {
            // 附件名
            if ($searchInfo['search_keyword']) {
                $map['file_name'] = array('like', '%' . $searchInfo['search_keyword'] . '%');
                $this->assign('fileName', $searchInfo['search_keyword']);
            }

            // 上传时间搜索
            $startUploadTime = strtotime($searchInfo['search_strat_upload_time']);
            $endUploadTime = strtotime($searchInfo['search_end_upload_time']);
            if ($startUploadTime < $endUploadTime) {
                $map['upload_time'] = array('between', array($startUploadTime, $endUploadTime));
                $this->assign('startTime', date('Y-m-d', $startUploadTime));
                $this->assign('endTime', date('Y-m-d', $endUploadTime));
            } else if ($startUploadTime > 0) {
                $map['upload_time'] = array('egt', $startUploadTime);
                $this->assign('startTime', date('Y-m-d', $startUploadTime));
            }

            // 后缀搜索
            if ($searchInfo['search_file_ext']) {
                $map['file_ext'] = $searchInfo['search_file_ext'];
                $this->assign('fileExt', $searchInfo['search_file_ext']);
            }

            // 附件状态
            if ($searchInfo['search_status'] !== '') {
                $map['status'] = $searchInfo['search_status'];
                $this->assign('status', intval($searchInfo['search_status']));
            }
        }

        // 开始查询
        $attachment = M('Attachment');

        // 分页
        $count = $attachment->where($map)->count();
        $page = page($count);
        $attachmentList = $attachment->where($map)->limit($page->firstRow, $page->listRows)->order('attachment_id DESC')->select();
        $this->assign('attachmentList', $attachmentList);
        $this->assign('page', $page->show());
        $this->display();
    }

    /**
     * 附件删除
     */
    public function delete() {
        $attachmentIds = $this->_param('attachment_id');
        if ($this->attachmentService->delete($attachmentIds)) {
            $this->bpiAjaxReturn(true, '删除附件成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $errorInfo = $this->attachmentService->getError();
            $error = empty($errorInfo) ? '删除附件失败' : $errorInfo;
            $this->bpiAjaxReturn(false, $error, array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 显示或上传文件
     */
    public function upload() {
        if (IS_POST) {
            $json = array();
            $data = $this->_post();
            $data['water'] = intval($data['water']);
            $data['qrcode'] = intval($data['qrcode']);
            $uploadList = $this->attachmentService->upload($data);
            if ($uploadList) {
                $json['error_code'] = 0;
                $json['error'] = '附件上传成功';
                $json['content'] = 1 === count($uploadList) ? array_pop($uploadList) : $uploadList;
            } else {
                $json['error_code'] = 1;
                $json['error'] = $this->attachmentService->getError();
            }
            $this->bpiAjaxReturn(!$json['error_code'], $json['error'], $json);
        } else {
            $config = BaseAction::getVar('config');
            $water = intval($config['watermark_is_open']);
            $qrcode = intval($config['qrcode_is_open']);
            // 查询配置，包括限制格式与限制大小
            $limit = intval($config['upload_admin_max_size']);
            $uploadAllowExt = $config['upload_admin_allow_ext'];

            $types = '';
            foreach (explode('|', $uploadAllowExt) as $ext) {
                $types .= '*.' . $ext . ';';
            }

            $this->assign('water', $water);
            $this->assign('qrcode', $qrcode);
            $this->assign('limit', $limit);
            $this->assign('types', $types);
            $this->display();
        }
    }

    /**
     * 获取图片资源的json列表
     */
    public function gallery() {
        $params = $this->_get();
        $page = max(intval($params['page']), 1);
        $listRow = intval($params['list_row']) ? intval($params['list_row']) : C('PAGE_LISTROWS');

        $pager = '';
        $imageList = $this->attachmentService->gallery($page, $listRow, $params['file_name'], $params['upload_time'], $pager);

        $this->ajaxReturn(array('pager' => $pager, 'gallery' => $imageList));
    }

    /**
     * 获取未处理图片文件列表
     */
    public function dispose() {
        $params = $this->_get();
        $page = max(intval($params['page']), 1);
        $listRow = intval($params['list_row']) ? intval($params['list_row']) : C('PAGE_LISTROWS');
        $pager = '';
        $imageList = $this->attachmentService->dispose($page, $listRow, $pager);

        $this->ajaxReturn(array('pager' => $pager, 'gallery' => $imageList));
    }

    /**
     * 显示上传页面
     */
    public function swfupload() {
        // 远程调用公共上传
        R('Attachment/swfupload');
    }

    /**
     * 为ueditor量身订造的swfupload
     */
    public function ueditorSwfupload() {
        // 远程调用Ueditor公共上传
        R('Attachment/ueditorSwfupload');
    }

    /**
     * 远程文件下载
     */
    public function download() {
        // 远程调用公共下载
        R('Attachment/download');
    }

    /**
     * ueditor专用下载
     */
    public function ueditorDownload() {
        R('Attachment/ueditorDownload');
    }

}

?>
