<?php

/**
 * 首页Action
 *
 * @author bant
 */
class ApiAction extends FrontBaseAction {

    public function _initialize() {
        parent::_initialize();
        $block_id = intval($this->_get('block_id'));
        $data = D('Block/Block')->field('open_type')->where(array('block_id' => $block_id))->find();
        if($data['open_type'] != "1"){
            exit('限制外部调用');
        }
    }

    /**
     * 输出JOSN
     */
    public function josn(){
        $block_id = intval($this->_get('block_id'));
        if($this->_post()){
            $post = $this->_post();
        }else{
            $post = $this->_get();
        }
        $data = BService('Block')->getBlock($block_id,$post['page'],$post['count'],$post['otherkey'],$post['othervalue']);
        $data = array ('status'=>'true','data' => $data);
        if(!$data){
            exit('不支持JOSN调用');
        }
        header('Content-type: application/json; charset=utf-8');
        echo json_encode($data);
        exit;
    }
    /**
     * 输出xml
     */
    public function xml(){
        $block_id = intval($this->_get('block_id'));
        if($this->_post()){
            $post = $this->_post();
        }else{
            $post = $this->_get();
        }
        $data = BService('Block')->getBlock($block_id,$post['page'],$post['count'],$post['otherkey'],$post['othervalue']);
        if(!$data){
            exit('不支持XML调用');
        }
        header('Content-Type: text/xml; charset=utf-8');
        echo xml_encode($data, $encoding='utf-8', $root='bpicms');
        exit;
    }

    /**
     * 输出js
     */
    public function js(){
        $block_id = intval($this->_get('block_id'));
        $blockinfo = D('Block/Block')->where(array('block_id' => $block_id))->find();

        $filename = HTML_PATH.'block'.DS.$blockinfo['model_flag'].DS.$block_id.'.shtml';
        if(file_exists($filename)){
            $data=file_get_contents($filename);
        }else{
            BService('Block')->buildHtml($block_id);
            $data=file_get_contents($filename);
        }
        $data=str_replace("\n","",$data);
	    $data=str_replace("\r","",$data);
	    $data=str_replace("'","\'",$data);
        if(!$data){
            exit('不支持JS调用');
        }
        header("Content-type: text/javascript; charset=utf-8");
	    echo "document.write('$data');";
	    exit;
    }


}

?>
