<?php

/**
 * 区块模块
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-12
 * @updateTime 2013-5-12
 */
class BlockAction extends AdminBaseAction {

    protected $blockModel, $modelList;

    public function _initialize() {
        parent::_initialize();
        $this->blockModel = D('Block/Block');
    }

    /**
     * 区块列表
     */
    public function index() {
        $count = $this->blockModel->where('1')->count();
        $page = page($count);
        $blockList = $this->blockModel->field('block_id,model_flag,block_name')->where('1')->limit($page->firstRow . ',' . $page->listRows)->order('block_id DESC')->select();
        $this->assign('blockList', $blockList);
        $this->assign('page', $page->show());
        $this->display();
    }

    /**
     * 添加
     */
    public function add() {
        $moduleList = BService('Block')->getBlockModule();
        $this->assign('moduleList', $moduleList);
        $this->display();
    }

    /**
     * 添加区块入库
     */
    public function add2() {
        $post = $this->_post();
        if (!$post['add'] AND IS_POST) {
            self::_postBlockForm(C('ACTION_TYPE.ADD'));
        } else {
            self::_showBlockForm();
        }
    }

    /**
     * 编辑区块
     */
    public function edit() {
        if (IS_POST) {
            self::_postBlockForm(C('ACTION_TYPE.EDIT'));
        } else {
            self::_showBlockForm();
        }
    }

    /**
     * 删除
     */
    public function delete() {
        $param = $this->_param('block_id');
        $blockIds = is_array($param) ? $param : array($param);
        if (empty($blockIds)) {
            $this->bpiAjaxReturn(false, '请选择删除条目', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
        foreach ($blockIds as $blockId) {
            $blockId = intval($blockId);
            if ($blockId > 0) {
                //删除静态
                 BService('Block')->deleteHtml($blockId);
                $this->blockModel->delete($blockId);

            }
        }
        $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
    }

    /**
     * 批量更新
     */
    public function batchupdate() {
        $param = $this->_param('block_id');
        $blockIds = is_array($param) ? $param : (array) $param;
        if (empty($blockIds)) {
            $this->bpiAjaxReturn(false, '请选择要更新的区块', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }
        foreach ($blockIds as $blockId) {
            $blockId = intval($blockId);
            //生成静态
            BService('Block')->buildHtml($blockId);
        }
        $this->bpiAjaxReturn(true, '更新完成', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
    }

    /**
     * 调用代码
     */
    public function script() {
        $block_id = intval($this->_get('block_id'));
        $model_flag = $this->blockModel->where(array('block_id' => $block_id))->getField('model_flag');
        $interior = '<BPIblock block_id=\'' . $block_id . '\' />';
        $interiorssi = '<!--#include virtual="/Html/block/' . $model_flag . '/' . $block_id . '.shtml" -->';
        $javaScript = SITE_URL . 'index.php?g=Block&m=Api&a=js&block_id=' . $block_id;
        $xml = SITE_URL . 'index.php?g=Block&m=Api&a=xml&block_id=' . $block_id;
        $josn = SITE_URL . 'index.php?g=Block&m=Api&a=josn&block_id=' . $block_id;
        $this->assign('interior', $interior);
        $this->assign('interiorssi', $interiorssi);
        $this->assign('javaScript', $javaScript);
        $this->assign('xml', $xml);
        $this->assign('josn', $josn);
        $this->display();
    }

    /**
     * 获取模版代码
     */
    public function getTpl() {
        $block_compid = $this->_get('block_compid');
        $block_tpl = BService('Block')->getTpl($block_compid);
        $tpl = '<pre class="brush:html;toolbar:false;">';
        $tpl .= htmlspecialchars($block_tpl['comp_tpl'], ENT_QUOTES);
        $tpl .= '</pre>';
        $this->ajaxReturn(array('block_tpl' => $tpl));
    }

    /**
     * 显示表单
     */
    private function _showBlockForm() {
        $block_id = intval($this->_get('block_id'));
        $post = $this->_post();
        $module = $post['moduleList'];
        if ($block_id) {
            $blockInfo = $this->blockModel->where(array('block_id' => $block_id))->find();
            if (!is_array($blockInfo)) {
                $this->error('该信息不存在');
            }
            $module = $blockInfo['model_flag'];
            $block_tpl = '<pre class="brush:html;toolbar:false;">';
            $block_tpl .= htmlspecialchars(htmlspecialchars($blockInfo['block_tpl'], ENT_QUOTES), ENT_QUOTES);
            $block_tpl .= '</pre>';
            $blockInfo['block_property'] = unserialize($blockInfo['block_property']);
            $this->assign('block', $blockInfo);
            $this->assign('block_tpl', $block_tpl);
        }
        $moduleList = BService('Block')->getBlockModule();
        $templateFile = $moduleList[$module]['tpl'];
        $tplList = BService('Block')->getTplList($module);
        $this->assign('tplList', $tplList);
        $this->assign('module', $module);
        $this->display($templateFile);
    }

    /**
     * 提交表单
     */
    private function _postBlockForm($actionType) {
        $post = $this->_post();
        //外部数据源连接检查
        if($post['block_property']['external'] === '1'){
            $conn = @mysql_connect($post['block_property']['dbhost'], $post['block_property']['dbuser'], $post['block_property']['dbpwd']);
            if(!$conn){
                $this->bpiAjaxReturn(false, '外部数据源连接失败');
            }
        }
        $data = $this->blockModel->create($post);
        if ($data) {
            $moduleList = BService('Block')->getBlockModule();
            $files = $moduleList[$data['model_flag']]['process'];
            if (is_file($files))
                include $files;
            if ($actionType == C('ACTION_TYPE.ADD')) {
                $blockId = $this->blockModel->add($data);
                if ($blockId) {
                    //生成静态
                    BService('Block')->buildHtml($blockId);
                    $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Block/Block/index') . '"'));
                } else {
                    $this->bpiAjaxReturn(false, '添加失败');
                }
            } else {
                $status = $this->blockModel->where(array('block_id' => $data['block_id']))->save($data);
                if ($status !== FALSE) {
                    //生成静态
                    BService('Block')->buildHtml($data['block_id']);
                    $this->bpiAjaxReturn(true, '修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '修改失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            }
        } else {
            $this->bpiAjaxReturn(false, $this->blockModel->getError(), array(), $actionType == C('ACTION_TYPE.ADD') ? C('OPERATE_TYPE.OPERATE_ADD') : C('OPERATE_TYPE.OPERATE_UPDATE'));
        }
    }

}

?>
