<?php

/**
 * 评论Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
class CommentAction extends AdminBaseAction {

    protected $commentModel, $commentService;

    //搜索类型

    const SEARCH_TYPE_AUTHOR = 1;       //评论作者
    const SEARCH_TYPE_CONTENT_ID = 2;   //文章ID

    function _initialize() {
        parent::_initialize();
        $this->commentModel = D('Comment');
        $this->commentService = BService('Comment');

        $searchType = array(
            self::SEARCH_TYPE_AUTHOR => '评论作者',
            self::SEARCH_TYPE_CONTENT_ID => '文章ID'
        );
        $this->assign('searchType', $searchType);
    }

    /**
     * 显示评论列表
     */
    public function index() {
        $this->_getCommentList(array('status' => 1));
        $this->display();
    }

    /**
     * 编辑评论
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();
            if ($this->commentService->edit($post['comment_id'], $post['content'], $post)) {
                $this->bpiAjaxReturn(true, '评论编辑成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $error = $this->commentService->getError();
                $info = empty($error) ? '评论编辑失败' : $error;
                $this->bpiAjaxReturn(false, $info, array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $commentId = intval($this->_get('comment_id'));
            $commentInfo = $this->commentService->getCommentById($commentId);
            if ($commentInfo) {
                $fieldList = M('CommentField')->order('field_id DESC')->select();
                $this->assign('commentInfo', $commentInfo);
                $this->assign('fieldList', $fieldList);
                $this->display();
            } else {
                $this->error('该评论不存在');
            }
        }
    }

    /**
     * 删除评论
     */
    public function delete() {
        $request = $this->_param();
        if (isset($request['comment_id'])) {
            $commentIdlist = (array) ($request['comment_id']);
        } else {
            $this->bpiAjaxReturn(false, '请选择删除条目', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }

        foreach ($commentIdlist as $id) {
            if (intval($id) > 0) {
                $this->commentService->delete($id);
            }
        }
        $this->bpiAjaxReturn(true, '删除评论成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
    }

    /**
     * 回复评论 
     */
    public function replyComment() {
        if (IS_POST) {
            $post = $this->_post();
            $post['user_id'] = BaseAction::getVar('user/user_id');
            if ($this->commentService->add($post['content_id'], $post['content'], $post, 0, $post['pid'])) {
                $this->bpiAjaxReturn(true, '回复评论成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')));
            } else {
                $error = $this->commentService->getError();
                $info = empty($error) ? '回复评论失败' : $error;
                $this->bpiAjaxReturn(false, $info);
            }
        } else {
            $commentId = $this->_get('comment_id');
            $commentInfo = $this->commentService->getCommentById($commentId);
            if ($commentInfo) {
                $this->assign('pid', $commentInfo['comment_id']);
                $this->assign('commentInfo', $commentInfo);
                $this->display();
            } else {
                $this->error('该评论不存在');
            }
        }
    }

    /**
     * 审核评论 
     */
    public function spamComment() {
        $commentId = $this->_get('comment_id');
        $this->_checkComment(array(intval($commentId)), $this->_get('final_status'));
    }

    /**
     * 评论审核 
     */
    public function check() {
        if (IS_POST) {
            $this->_checkComment($this->_post('comment_id'), true);
        } else {
            $where = array('status' => 0);
            $this->_getCommentList($where);
            $this->display('index');
        }
    }

    /**
     * 评论配置
     */
    public function config() {
        if (IS_POST) {
            $post = $this->_post();

            $configList = array(
                'comment_status' => '文章评论是否开启验证码',
                'comment_is_allow_guest' => '文章评论是否允许游客评论',
                'comment_is_check' => '文章评论是否需要验证',
                'comment_is_need_verify' => '文章评论是否开启验证码',
                'comment_interval' => '文章评论间隔时间',
                'comment_max_length' => '文章评论最大字节数',
                'comment_default_side_table_id' => '文章评论默认储存分表',
            );

            $ststus = FALSE;
            $configModel = D('Config');
            foreach ($configList as $key => $info) {
                $value = isset($post[$key]) ? $post[$key] : '';
                $ststus |= $configModel->setConfig($key, $value, $info);
            }

            if ($ststus) {
                $this->bpiAjaxReturn(true, '更新成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(false, '更新失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $commentTableList = $this->commentModel->getCommentSideTableList();
            $this->assign('comment_side_table_list', $commentTableList);
            $this->assign('data', BaseAction::getVar('config'));
            $this->display();
        }
    }

    /**
     * 创建新分表
     */
    public function addSideTable() {
        //创建新分表
        if ($this->commentModel->createNewSideTable()) {
            $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH'), C('OPERATE_TYPE.OPERATE_ADD')));
        } else {
            $this->bpiAjaxReturn(false, '添加失败');
        }
    }

    /**
     * 获取评论列表
     * @param type $map 条件
     */
    private function _getCommentList($map = array()) {
        //TODO: 暂时无法按照用户名搜索
        $arg = array();
        $get = $this->_get();
        if ($get['search'] == 1) {
            $type = intval($get['search_type']);
            $keyword = $get['keyword'];
            if (!empty($keyword)) {
                switch ($type) {
                    case self::SEARCH_TYPE_AUTHOR:
                        $arg['author'] = array('like', '%' . $keyword . '%');
                        break;
                    case self::SEARCH_TYPE_CONTENT_ID:
                        $arg['content_id'] = $keyword;
                        break;
                    default :
                        break;
                }
            }
            $this->assign('type', $type);
            $this->assign('keyword', $keyword);
        }
        $where = array_merge($arg, $map);
        $count = $this->commentModel->where($where)->count();
        $page = page($count);
        //获取评论列表
        $commentList = $this->commentModel->where($where)->order('date DESC')->limit($page->firstRow . ',' . $page->listRows)->select();
        foreach ($commentList as $k => $v) {
            $userName = M('Member')->where(array('user_id' => $v['user_id']))->getField('user_name');
            $commentList[$k]['author'] = empty($userName) ? '' : $userName;
            //获取评论内容
            $commentList[$k]['content'] = M('CommentData_' . $v['side_table_id'])->where(array('comment_id' => $v['comment_id']))->getField('content');
            //添加文章标题
            $contentInfo = M('Content')->where(array('id' => $v['content_id']))->find();
            $commentList[$k]['title'] = isset($contentInfo['title']) ? $contentInfo['title'] : '';
        }
        $this->assign('commentList', $commentList);
        $this->assign('page', $page->show());
    }

    /**
     * 审核评论
     * @param array $commentIdList 操作的评论id列表
     * @param boolean $finalStatus 期望的最终状态
     */
    private function _checkComment($commentIdList, $finalStatus) {
        if (empty($commentIdList) || !is_array($commentIdList)) {
            $this->bpiAjaxReturn(false, '没有信息被选择', array(), C('OPERATE_TYPE.OPERATE_UPDATE'), $commentIdList);
        }
        $finalStatus = $finalStatus == 1 ? 1 : 0;
        $where['comment_id'] = array('IN', $commentIdList);
        $status = $this->commentModel->where($where)->save(array('status' => $finalStatus));
        $returnString = $finalStatus ? '审核' : '取消审核';
        if ($status !== false) {
            $this->bpiAjaxReturn(true, $returnString . '成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'), $commentIdList);
        } else {
            $this->bpiAjaxReturn(false, $returnString . '失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'), $commentIdList);
        }
    }

}

?>
