<?php

/**
 * 生成htmlAction
 * @author     bant
 * @copyright  (C) 2011-2014 EXCMS
 * @license    http://www.zyxfeng.com/license/
 * @version    1.0
 * @createTime 2013-4-7
 * @updateTime 2013-4-7
 */
class CreateHtmlAction extends AdminBaseAction {

    public $categoryCache;
    public $modelCache;
    public $urlService;
    public $htmlService;
    protected $relationModel;

    //TODO:重命名
    //TODO:优化此文件方法 to bant
    const CACHE_UPDATE_CATEGORY_CATEGORY_ID_LIST_PREFIX = 'UpdateCategoryCategoryIdListUid'; //更新栏目操作中，需要更新的栏目id列表缓存名前缀
    const CACHE_UPDATE_URL_CATEGORY_ID_LIST_PREFIX = 'UpdateUrlCategoryIdListUid'; //更新url操作中，需要更新的栏目id列表缓存名前缀
    const CACHE_UPDATE_CONTENT_CATEGORY_ID_LIST_PREFIX = 'UpdateContentHtmlCategoryIdListUid'; //更新内容页操作中，需要更新的内容页的栏目id列表缓存名前缀
    //更新内容页方式列表
    const UPDATE_TYPE_LAST_POST_COUNT = 'last_post_count'; //更新最新发布的指定条数
    const UPDATE_TYPE_POST_TIME = 'post_time'; //按照时间进行更新
    const ACTION_NAME_UPDATE_CATEGORY = 'updateCategory'; //更新栏目页对应actionName
    const ACTION_NAME_UPDATE_URL = 'updateUrl'; //更新url对应actionName
    const ACTION_NAME_UPDATE_CONTENT = 'updateContent'; //更新内容对应actionName

    public function _initialize() {
        parent::_initialize();
        $this->categoryCache = FData('Category');
        $this->modelCache = D('Model')->getModelByType(C('MODEL_TYPE.CONTENT'), 1);
        $this->urlService = BService('Url');
        $this->htmlService = BService('Html');
        $this->relationModel = new AutoRelationModel('Content');
    }

    /**
     * 批量更新栏目页
     * PS:更改此方法名，请对应修改ACTION_NAME_UPDATE_CATEGORY
     */
    public function updateCategory() {
        if (IS_POST || $this->_param('is_submit') == 1) {//判断是否post或者请求中存在is_submit状态为1
            $request = $this->_param();
            $referer = isset($request['referer']) ? urlencode($request['referer']) : '';
            $modelId = $request['model_id'];
            $categoryIdList = $request['category_id_list'];
            $pageSize = $request['page_size']; //每轮更新数据条数
            $updateCategoryIdList = array(); //需要更新的栏目id列表
            $this->assign('waitSecond', 0); //信息停留时间
            if (!isset($request['set_category_id'])) {//开始更新请求时，请求中没有set_category_id，则进行构建
                //等待更新的未过滤栏目id列表
                if ($categoryIdList[0] != 0) {
                    $updateOriginCategoryIdList = $categoryIdList;
                } else {
                    $updateOriginCategoryIdList = array_keys($this->categoryCache);
                }
                //过滤获取需要更新的栏目id列表   
                foreach ($updateOriginCategoryIdList as $updateOriginCategoryId) {
                    $category = $this->categoryCache[$updateOriginCategoryId];
                    if ($category['type'] == C('CATEGORY_TYPE.CHAIN') || !$category['setting']['is_set_html']) {//外链栏目或者不需要生成静态的跳过
                        continue;
                    }
                    if ($modelId && !array_key_exists($modelId, $category['model'])) {//当栏目不是指定的模型类型，则跳过
                        continue;
                    }

                    //检查生成URL规则是否指定模型，如果指定，但没有传入，则跳过
                    $urlRuleData = BService('Url')->getCategoryUrlRule($category['setting']['category_url_rule_id']);
                    if ($urlRuleData['is_set_model'] && (empty($modelId))) {
                        continue;
                    }
                    $updateCategoryIdList[] = $updateOriginCategoryId;
                }

                //缓存需要生成的栏目id
                S(self::CACHE_UPDATE_CATEGORY_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'), $updateCategoryIdList, 3600);
                $message = '开始更新栏目页';
                $forward = U(GROUP_NAME . '/' . MODULE_NAME . '/updateCategory', array(
                    'set_category_id' => 1,
                    'referer' => $referer,
                    'is_submit' => 1,
                    'page_size' => $pageSize,
                    'model_id' => $modelId,
                ));
                $this->success($message, $forward);
                exit;
            }
            //缓存中读取栏目id集合
            $updateCategoryIdListCache = S(self::CACHE_UPDATE_CATEGORY_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'));
            //当前更新的栏目标记(对应栏目id列表缓存index，可以理解指针)
            $markId = $request['mark_id'] ? intval($request['mark_id']) : 0;
            //判断是否更新结束
            if (!isset($updateCategoryIdListCache[$markId])) {
                $forward = NULL;
                if (!empty($referer) && $this->categoryCache[$updateCategoryIdListCache[0]]['type'] != C('CATEGORY_TYPE.SINGLE_SITE')) {//如不是单网页且有referer，更新后直接跳转
                    $forward = urldecode($referer);
                }
                //删除缓存
                S(self::CACHE_UPDATE_CATEGORY_CATEGORY_ID_LIST_PREFIX, NULL);
                $this->success('更新完成', is_null($forward) ? U(GROUP_NAME . '/' . MODULE_NAME . '/updateCategory') : $forward);
                exit;
            }

            //获得栏目id
            $categoryId = $updateCategoryIdListCache[$markId];
            //每个栏目更新页码
            $pageNumber = $request['page_number'] ? $request['page_number'] : 1;
            //总生成页数，没有传入则读取默认系统分页数
            $totalPageNumber = isset($request['total_page_number']) ? $request['total_page_number'] : C('PAGE_ROLLPAGE');
//            //删除已经生成的缓存
//            BService('Html')->deleteCategoryHtml($categoryId);
            //生成一轮栏目静态
            for ($i = 1; $pageNumber <= $totalPageNumber && $i <= $pageSize; $i++, $pageNumber++) {
                //生成第一轮同时设置总页数
                $returnCategoryData = BService('Html')->buildCategory($categoryId, $pageNumber, $modelId);
                $totalPageNumber = $returnCategoryData['totalPage'];
            }
            if ($pageNumber <= $totalPageNumber) {//当前栏目更新未完成，放下一轮更新
                $completePageNumber = $pageNumber - 1; //已经完成的页数
                $message = '正在更新 ' . $this->categoryCache[$categoryId]['category_name'] . ' 第' . $pageNumber . '页-当前进度:' .
                        (round($completePageNumber / $totalPageNumber, 2) * 100) . '%-总共' . ceil($totalPageNumber / $pageSize) . '轮';
                $forward = U(GROUP_NAME . '/' . MODULE_NAME . '/updateCategory', array(
                    'set_category_id' => 1,
                    'referer' => $referer,
                    'is_submit' => 1,
                    'page_size' => $pageSize,
                    'mark_id' => $markId,
                    'page_number' => $pageNumber,
                    'total_page_number' => $totalPageNumber,
                ));
                $this->success($message, $forward);
                exit;
            } else {//当前栏目更新完成
                $markId++; //指针指向新的栏目
                $message = $this->categoryCache[$categoryId]['category_name'] . '更新完成';
                $forward = U(GROUP_NAME . '/' . MODULE_NAME . '/updateCategory', array(
                    'set_category_id' => 1,
                    'referer' => $referer,
                    'is_submit' => 1,
                    'page_size' => $pageSize,
                    'mark_id' => $markId,
                ));
                $this->success($message, $forward);
                exit;
            }
        } else {
            $this->_showUpdateForm(ACTION_NAME);
        }
    }

    /**
     * 更新首页
     */
    public function public_updateIndex() {
        if (IS_POST) {
            if (BService('Html')->buildIndex()) {
                $this->bpiAjaxReturn(true, '首页更新成功', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(false, BService('Html')->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $this->display();
        }
    }

    /**
     * 批量更新url
     */
    public function updateUrl() {
        if (IS_POST || $this->_param('is_submit') == 1) {//判断是否post或者请求中存在is_submit状态为1
            $request = $this->_param();
            $currentModelId = $request['model_id'];
            $categoryIdList = $request['category_id_list']; //提交的需要更新的栏目id列表
            $pageSize = $request['page_size']; //每轮处理数据条数
            $totalDataNumber = intval($request['totle_data_number']); //总处理数据条数
            $totalPageNumber = intval($request['totla_page_number']); //总页数
            $pageNumber = max($request['page_number'], 1); //当前页码
            $this->assign('waitSecond', 0); //信息停留时间
            if ($currentModelId) {//指定处理model
                if (!$request['set_category_id']) {//第一次更新，缓存需要更新的栏目id
                    //等待更新的未过滤栏目id列表
                    if ($categoryIdList[0] != 0) {
                        $updateOriginCategoryIdList = $categoryIdList;
                    } else {//不限制栏目
                        $updateOriginCategoryIdList = array_keys($this->categoryCache);
                    }
                    //过滤获取需要更新的栏目id列表
                    foreach ($updateOriginCategoryIdList as $categoryId) {
                        $category = $this->categoryCache[$categoryId];
                        if ($category['type'] != C('CATEGORY_TYPE.NORMAL')) {//非一般栏目跳过
                            continue;
                        }
                        if (!array_key_exists($currentModelId, $category['model'])) {//当栏目不是指定的模型类型，则跳过
                            continue;
                        }
                        $updateCategoryIdList[] = $categoryId;
                    }

                    //当没有符合条件的栏目时，则直接提示完成
                    if (count($updateCategoryIdList) == 1 && $updateCategoryIdList[0] == 0) {
                        $this->success('更新完成', U(GROUP_NAME . '/' . MODULE_NAME . '/' . ACTION_NAME));
                        exit;
                    }

                    //缓存需要生成的栏目id
                    //TODO:可能缓存要久一点。
                    S(self::CACHE_UPDATE_URL_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'), $updateCategoryIdList, 3600);
                    $where['category_id'] = array('IN', implode(',', $updateCategoryIdList));
                } else {//不是第一次更新，读取缓存中的栏目id
                    //缓存中读取栏目id集合
                    $updateCategoryIdListCache = S(self::CACHE_UPDATE_URL_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'));
                    $where['category_id'] = array('IN', implode(',', $updateCategoryIdListCache));
                }
                //更新方式
                $type = $request['type'];
                //通过关系模型实例化
                $contentRelationModel = $this->relationModel;

                //准备更新条件数据
                $offset = $pageSize * ($pageNumber - 1);
                $where['status'] = C('CONTENT_CHECK_STATUS.PASS'); //审核通过
                $order = 'ASC';
                //转向保持状态的参数
                $returnGetParam = array();
                switch ($type) {
                    case self::UPDATE_TYPE_LAST_POST_COUNT ://最新发布条数上传
                        $lastPostCount = intval($request[self::UPDATE_TYPE_LAST_POST_COUNT]);
                        if ($lastPostCount) {
                            $offset = 0;
                            $pageSize = $lastPostCount;
                            //TODO:此处是用id排序，需要用发布时间排序否？
                            $order = 'DESC';
                            $returnGetParam[self::UPDATE_TYPE_LAST_POST_COUNT] = $lastPostCount;
                        }
                        break;
                    case self::UPDATE_TYPE_POST_TIME://时间段上传
                        $startTime = intval($request['start_time']);
                        if ($startTime) {
                            //TODO:隐患，数据库字段更改，则无效
                            $where[self::UPDATE_TYPE_POST_TIME] = array('EGT', $startTime);
                            $returnGetParam['start_time'] = $startTime;
                        }
                        $endTime = intval($request['end_time']);
                        if ($endTime) {
                            $where[self::UPDATE_TYPE_POST_TIME] = array('ELT', $endTime);
                            $returnGetParam['end_time'] = $endTime;
                        }
                        break;
                    default:
                        break;
                }
                if (!$totalDataNumber && $type != self::UPDATE_TYPE_LAST_POST_COUNT) {//没有总数据数，为此栏目第一轮执行更新,PS:更新最新指定条数特殊处理,为一轮更新完成
                    //统计总数
                    $totalDataNumber = $contentRelationModel->where($where)->count(); //总数据条数
                    $totalPageNumber = ceil($totalDataNumber / $pageSize); //总页数或总轮数
                    //标记第一轮更新
                    $startFlag = 1;
                }

                //主副表关系获得数据列表
                $dataList = $contentRelationModel->relation(false)->where($where)->order(array('id' => $order))->limit($offset . ',' . $pageSize)->select();

                //生成一轮内容页面更新
                foreach ($dataList as $data) {
                    if ($data['is_link']) {//单纯链接内容则跳过
                        continue;
                    }
                    $newUrl = $this->urlService->getContentUrl($data['category_id'], $data['id'], $data['post_time'], 0, $data['alias'], FALSE);
                    
                    //更新url 
                    $buildResult = $contentRelationModel->where(array('id' => $data['id']))->save(array('url' => $newUrl));
                    if ($buildResult === false) {
                        $this->error($contentRelationModel->getError());
                    }
                }

                //所有栏目数据同级更新，不再逐个栏目更新
                if ($pageNumber <= $totalPageNumber) {//更新未完成，放下一轮更新
                    $pageNumber++;
                    //已完成数据条数
                    $completeCount = $offset + count($dataList);
                    //完成百分比
                    $percent = round($completeCount / $totalDataNumber, 2) * 100;
                    $message = ' 共需更新' . $totalDataNumber . '条消息-已完成' . $completeCount . '条消息-当前进度:' . $percent . '%';
                    $forward = $startFlag ? U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent', array_merge(array(
                                'type' => $type,
                                'is_submit' => 1,
                                'page_size' => $pageSize,
                                'page_number' => $pageNumber,
                                'total_page_number' => $totalPageNumber,
                                'total_data_number' => $totalDataNumber,
                                'set_category_id' => 1,
                                'model_id' => $currentModelId,
                                            ), $returnGetParam)
                            ) : preg_replace("/&page_number=([0-9]+)&total_page_number=([0-9]+)&total_date_number=([0-9]+)/", "&page_number=$pageNumber&page_total_number=$totalPageNumber&total_date_number=$totalDataNumber", __SELF__);
                    $this->success($message, $forward);
                    exit;
                } else {//所有栏目完成
                    //删除缓存
                    S(self::CACHE_UPDATE_CONTENT_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'), null);
                    $this->success('更新完成', U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent'));
                    exit;
                }
            } else {
                if (!isset($request['set_category_id'])) {//开始更新请求时，请求中没有set_category_id，则进行构建
                    //等待更新的未过滤栏目id列表
                    if ($categoryIdList[0] != 0) {
                        $updateOriginCategoryIdList = $categoryIdList;
                    } else {//不限制栏目
                        $updateOriginCategoryIdList = array_keys($this->categoryCache);
                    }
                    //过滤获取需要更新的栏目id列表
                    foreach ($updateOriginCategoryIdList as $categoryId) {
                        $category = $this->categoryCache[$categoryId];
                        if ($currentModelId && !array_key_exists($currentModelId, $category['model'])) {//当栏目不是指定的模型类型，则跳过
                            continue;
                        }
                        $updateCategoryIdList[] = $categoryId;
                    }
                    //缓存需要生成的栏目id
                    S(self::CACHE_UPDATE_URL_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'), $updateCategoryIdList, 3600);
                    $message = '开始更新...';
                    $forward = U(GROUP_NAME . '/' . MODULE_NAME . '/' . ACTION_NAME, array(
                        'set_category_id' => 1,
//                    'model_id' => $modelId,
//                    'referer' => $referer,
                        'is_submit' => 1,
                        'page_size' => $pageSize,
                    ));
                    $this->success($message, $forward);
                    exit;
                }

                //缓存中读取栏目id集合
                $updateCategoryIdListCache = S(self::CACHE_UPDATE_URL_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'));
                //当前更新的栏目标记(对应栏目id列表缓存index，可以理解指针)
                $markId = $request['mark_id'] ? intval($request['mark_id']) : 0;

                //判断是否更新结束
                if (!isset($updateCategoryIdListCache[$markId])) {
                    //删除缓存
                    S(self::CACHE_UPDATE_URL_CATEGORY_ID_LIST_PREFIX, NULL);
                    $this->success('更新完成', U(GROUP_NAME . '/' . MODULE_NAME . '/' . ACTION_NAME));
                    exit;
                }

                //主体工作执行
                //获得栏目id
                $currentCategoryId = $updateCategoryIdListCache[$markId];
                $currentModelId = $this->categoryCache[$currentCategoryId]['model_id'];
                //通过关系模型实例化
                $contentRelationModel = $this->relationModel;

                //每个栏目更新页码
                $pageNumber = $request['page_number'] ? $request['page_number'] : 1;
                $offset = $pageSize * ($pageNumber - 1); //数据拉取开始索引
                $where = array(
                    'status' => C('CONTENT_CHECK_STATUS.PASS'), //审核通过
                    'category_id' => $currentCategoryId,
                );

                if (!$totalDataNumber) {//没有总数据数，为此栏目第一轮执行更新
                    //统计总数
                    $totalDataNumber = $contentRelationModel->where($where)->count(); //总数据条数
                    $totalPageNumber = ceil($totalDataNumber / $pageSize); //总页数
                    //标记第一轮更新
                    $startFlag = 1;
                }
                //主副表关系获得数据列表(已合并)
                $dataList = $contentRelationModel->relation(false)->where($where)->order(array('id' => 'ASC'))->limit($offset . ',' . $pageSize)->select();

                //生成一轮内容页面更新
                foreach ($dataList as $data) {
                    if ($data['is_link']) {//单纯链接内容则跳过
                        continue;
                    }
                    $newUrl = $this->urlService->getContentUrl($data['category_id'], $data['id'], $data['post_time'], 0, $data['alias']);
                    
                    //更新url 
                    $buildResult = $contentRelationModel->where(array('id' => $data['id']))->save(array('url' => $newUrl));
                    if ($buildResult === false) {
                        $this->error($contentRelationModel->getError());
                    }
                }

                if ($pageNumber <= $totalPageNumber) {//当前栏目更新未完成，放下一轮更新
                    $pageNumber++;
                    //已完成数据条数
                    $completeCount = $offset + count($dataList);
                    //完成百分比
                    $percent = round($completeCount / $totalDataNumber, 2) * 100;
                    $message = '正在更新 ' . $this->categoryCache[$categoryId]['category_name'] . ' 共' . $totalDataNumber . '条消息-已完成' . $completeCount . '条消息-当前进度:' . $percent . '%';
                    $forward = $startFlag ? U(GROUP_NAME . '/' . MODULE_NAME . '/' . ACTION_NAME, array(
                                'is_submit' => 1,
                                'page_size' => $pageSize,
                                'page_number' => $pageNumber,
                                'total_page_number' => $totalPageNumber,
                                'total_data_number' => $totalDataNumber,
                                'mark_id' => $markId,
                                'set_category_id' => 1,
                                    )
                            ) : preg_replace("/&page_number=([0-9]+)&total_page_number=([0-9]+)&total_date_number=([0-9]+)/", "&page_number=$pageNumber&page_total_number=$totalPageNumber&total_date_number=$totalDataNumber", __SELF__);
                    $this->success($message, $forward);
                    exit;
                } else {//当前栏目更新完成
                    $markId++; //指针指向新的栏目
                    $forward = U(GROUP_NAME . '/' . MODULE_NAME . '/' . ACTION_NAME, array(
                        'set_category_id' => 1,
                        'page_size' => $pageSize,
                        'is_submit' => 1,
                        'mark_id' => $markId,
                    ));
                    $this->success($this->categoryCache[$currentCategoryId]['category_name'] . '更新完成', $forward);
                    exit;
                }
            }
        } else {
            $this->_showUpdateForm(ACTION_NAME);
        }
    }

    /**
     * 批量更新内容页
     */
    public function updateContent() {
        if (IS_POST || $this->_param('is_submit') == 1) {//判断是否post或者请求中存在is_submit状态为1
            $request = $this->_param();
            $currentModelId = $request['model_id'];
            $categoryIdList = $request['category_id_list']; //提交的需要更新的栏目id列表
            $pageSize = $request['page_size']; //每轮处理数据条数
            $totalDataNumber = intval($request['totle_data_number']); //总处理数据条数
            $totalPageNumber = intval($request['totla_page_number']); //总页数
            $pageNumber = max($request['page_number'], 1); //当前页码
            $this->assign('waitSecond', 0); //信息停留时间
            if ($currentModelId) {//指定处理model
                if (!$request['set_category_id']) {//第一次更新，缓存需要更新的栏目id
                    //等待更新的未过滤栏目id列表
                    if ($categoryIdList[0] != 0) {
                        $updateOriginCategoryIdList = $categoryIdList;
                    } else {//不限制栏目
                        $updateOriginCategoryIdList = array_keys($this->categoryCache);
                    }
                    //过滤获取需要更新的栏目id列表
                    foreach ($updateOriginCategoryIdList as $categoryId) {
                        $category = $this->categoryCache[$categoryId];
                        if (($category['type'] != C('CATEGORY_TYPE.NORMAL') && $category['type'] != C('CATEGORY_TYPE.TOPIC')) || !$category['setting']['content_is_set_html']) {//非一般栏目或者不需要生成静态的跳过
                            continue;
                        }
                        if (!array_key_exists($currentModelId, $category['model'])) {//当栏目不是指定的模型类型，则跳过
                            continue;
                        }
                        $updateCategoryIdList[] = $categoryId;
                    }

                    //当没有符合条件的栏目时，则直接提示完成
                    if (count($updateCategoryIdList) == 1 && $updateCategoryIdList[0] == 0) {
                        $this->success('更新完成', U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent'));
                        exit;
                    }

                    //缓存需要生成的栏目id
                    //TODO:可能缓存要久一点。
                    S(self::CACHE_UPDATE_CONTENT_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'), $updateCategoryIdList, 3600);
                    $where['category_id'] = array('IN', implode(',', $updateCategoryIdList));
                } else {//不是第一次更新，读取缓存中的栏目id
                    //缓存中读取栏目id集合
                    $updateCategoryIdListCache = S(self::CACHE_UPDATE_CONTENT_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'));
                    $where['category_id'] = array('IN', implode(',', $updateCategoryIdListCache));
                }

                //更新方式
                $type = $request['type'];
                //通过关系模型实例化
                $contentRelationModel = $this->relationModel;

                //准备更新条件数据
                $offset = $pageSize * ($pageNumber - 1);
                $where['status'] = C('CONTENT_CHECK_STATUS.PASS'); //审核通过
                $order = 'ASC';
                //转向保持状态的参数
                $returnGetParam = array();
                switch ($type) {
                    case self::UPDATE_TYPE_LAST_POST_COUNT ://最新发布条数上传
                        $lastPostCount = intval($request[self::UPDATE_TYPE_LAST_POST_COUNT]);
                        if ($lastPostCount) {
                            $offset = 0;
                            $pageSize = $lastPostCount;
                            //TODO:此处是用id排序，需要用发布时间排序否？
                            $order = 'DESC';
                            $returnGetParam[self::UPDATE_TYPE_LAST_POST_COUNT] = $lastPostCount;
                        }
                        break;
                    case self::UPDATE_TYPE_POST_TIME://时间段上传
                        $startTime = intval($request['start_time']);
                        if ($startTime) {
                            //TODO:隐患，数据库字段更改，则无效
                            $where[self::UPDATE_TYPE_POST_TIME] = array('EGT', $startTime);
                            $returnGetParam['start_time'] = $startTime;
                        }
                        $endTime = intval($request['end_time']);
                        if ($endTime) {
                            $where[self::UPDATE_TYPE_POST_TIME] = array('ELT', $endTime);
                            $returnGetParam['end_time'] = $endTime;
                        }

                        break;
                    default:
                        break;
                }
                if (!$totalDataNumber && $type != self::UPDATE_TYPE_LAST_POST_COUNT) {//没有总数据数，为此栏目第一轮执行更新,PS:更新最新指定条数特殊处理,为一轮更新完成
                    //统计总数
                    $totalDataNumber = $contentRelationModel->where($where)->count(); //总数据条数
                    $totalPageNumber = ceil($totalDataNumber / $pageSize); //总页数或总轮数
                    //标记第一轮更新
                    $startFlag = 1;
                }

                //主副表关系获得数据列表
                $dataList = $contentRelationModel->relation(true)->where($where)->order(array('id' => $order))->limit($offset . ',' . $pageSize)->select();
                //生成一轮内容页面更新
                foreach ($dataList as $data) {
                    if ($data['is_link']) {//单纯链接内容则跳过
                        continue;
                    }
                    $buildContentResult = $this->htmlService->buildContent($data);
                    if (!$buildContentResult) {
                        $this->error($this->htmlService->getError());
                    }
                }

                //所有栏目数据同级更新，不再逐个栏目更新
                if ($pageNumber <= $totalPageNumber) {//更新未完成，放下一轮更新
                    $pageNumber++;
                    //已完成数据条数
                    $completeCount = $offset + count($dataList);
                    //完成百分比
                    $percent = round($completeCount / $totalDataNumber, 2) * 100;
                    $message = ' 共需更新' . $totalDataNumber . '条消息-已完成' . $completeCount . '条消息-当前进度:' . $percent . '%';
                    $forward = $startFlag ? U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent', array_merge(array(
                                'type' => $type,
                                'is_submit' => 1,
                                'page_size' => $pageSize,
                                'page_number' => $pageNumber,
                                'total_page_number' => $totalPageNumber,
                                'total_data_number' => $totalDataNumber,
                                'set_category_id' => 1,
                                'model_id' => $currentModelId,
                                            ), $returnGetParam)
                            ) : preg_replace("/&page_number=([0-9]+)&total_page_number=([0-9]+)&total_date_number=([0-9]+)/", "&page_number=$pageNumber&page_total_number=$totalPageNumber&total_date_number=$totalDataNumber", __SELF__);
                    $this->success($message, $forward);
                    exit;
                } else {//所有栏目完成
                    //删除缓存
                    S(self::CACHE_UPDATE_CONTENT_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'), null);
                    $this->success('更新完成', U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent'));
                    exit;
                }
            } else {
                if (!isset($request['set_category_id'])) {//开始更新请求时，请求中没有set_category_id，则进行构建
                    //等待更新的未过滤栏目id列表
                    if ($categoryIdList[0] != 0) {
                        $updateOriginCategoryIdList = $categoryIdList;
                    } else {//不限制栏目
                        $updateOriginCategoryIdList = array_keys($this->categoryCache);
                    }
                    //过滤获取需要更新的栏目id列表
                    foreach ($updateOriginCategoryIdList as $categoryId) {
                        $category = $this->categoryCache[$categoryId];
                        if (($category['type'] != C('CATEGORY_TYPE.NORMAL') && $category['type'] != C('CATEGORY_TYPE.TOPIC')) || !$category['setting']['content_is_set_html']) {//非一般栏目或者不需要生成静态的跳过
                            continue;
                        }
                        if ($currentModelId && !array_key_exists($currentModelId, $category['model'])) {//当栏目不是指定的模型类型，则跳过
                            continue;
                        }
                        $updateCategoryIdList[] = $categoryId;
                    }
                    //缓存需要生成的栏目id
                    S(self::CACHE_UPDATE_CONTENT_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'), $updateCategoryIdList, 3600);
                    $message = '开始更新...';
                    $forward = U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent', array(
                        'set_category_id' => 1,
//                    'model_id' => $modelId,
//                    'referer' => $referer,
                        'is_submit' => 1,
                        'page_size' => $pageSize,
                    ));
                    $this->success($message, $forward);
                    exit;
                }

//                //判断是否已经更新完成 
//                if (count($categoryIdList) == 1 && $categoryIdList[0] == 0) {
//                    //TODO:删除缓存
//                    $this->success('更新完成', U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent'));
//                    exit;
//                }
                //缓存中读取栏目id集合
                $updateCategoryIdListCache = S(self::CACHE_UPDATE_CONTENT_CATEGORY_ID_LIST_PREFIX . BaseAction::getVar('user_id'));
                //当前更新的栏目标记(对应栏目id列表缓存index，可以理解指针)
                $markId = $request['mark_id'] ? intval($request['mark_id']) : 0;

                //判断是否更新结束
                if (!isset($updateCategoryIdListCache[$markId])) {
                    //删除缓存
                    S(self::CACHE_UPDATE_CONTENT_CATEGORY_ID_LIST_PREFIX, NULL);
                    $this->success('更新完成', U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent'));
                    exit;
                }

                //主体工作执行
                //获得栏目id
                $currentCategoryId = $updateCategoryIdListCache[$markId];
                $currentModelId = $this->categoryCache[$currentCategoryId]['model_id'];
                //通过关系模型实例化
                $contentRelationModel = $this->relationModel;

                //每个栏目更新页码
                $pageNumber = $request['page_number'] ? $request['page_number'] : 1;
                $offset = $pageSize * ($pageNumber - 1); //数据拉取开始索引
                $where = array(
                    'status' => C('CONTENT_CHECK_STATUS.PASS'), //审核通过
                    'category_id' => $currentCategoryId,
                );

                if (!$totalDataNumber) {//没有总数据数，为此栏目第一轮执行更新
                    //统计总数
                    $totalDataNumber = $contentRelationModel->where($where)->count(); //总数据条数
                    $totalPageNumber = ceil($totalDataNumber / $pageSize); //总页数
                    //标记第一轮更新
                    $startFlag = 1;
                }
                //主副表关系获得数据列表(已合并)
                $dataList = $contentRelationModel->relation(true)->where($where)->order(array('id' => 'ASC'))->limit($offset . ',' . $pageSize)->select();
                //生成一轮内容页面更新
                foreach ($dataList as $data) {
                    if ($data['is_link']) {//单纯链接内容则跳过
                        continue;
                    }
                    $buildContentResult = $this->htmlService->buildContent($data);
                    if (!$buildContentResult) {
                        $this->error($this->htmlService->getError());
                    }
                }

                if ($pageNumber <= $totalPageNumber) {//当前栏目更新未完成，放下一轮更新
                    $pageNumber++;
                    //已完成数据条数
                    $completeCount = $offset + count($dataList);
                    //完成百分比
                    $percent = round($completeCount / $totalDataNumber, 2) * 100;
                    $message = '正在更新 ' . $this->categoryCache[$categoryId]['category_name'] . ' 共' . $totalDataNumber . '条消息-已完成' . $completeCount . '条消息-当前进度:' . $percent . '%';
                    $forward = $startFlag ? U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent', array(
                                'is_submit' => 1,
                                'page_size' => $pageSize,
                                'page_number' => $pageNumber,
                                'total_page_number' => $totalPageNumber,
                                'total_data_number' => $totalDataNumber,
                                'mark_id' => $markId,
                                'set_category_id' => 1,
                                    )
                            ) : preg_replace("/&page_number=([0-9]+)&total_page_number=([0-9]+)&total_date_number=([0-9]+)/", "&page_number=$pageNumber&page_total_number=$totalPageNumber&total_date_number=$totalDataNumber", __SELF__);
                    $this->success($message, $forward);
                    exit;
                } else {//当前栏目更新完成
                    $markId++; //指针指向新的栏目
                    $forward = U(GROUP_NAME . '/' . MODULE_NAME . '/updateContent', array(
                        'set_category_id' => 1,
                        'page_size' => $pageSize,
                        'is_submit' => 1,
                        'mark_id' => $markId,
                    ));
                    $this->success($this->categoryCache[$currentCategoryId]['category_name'] . '更新完成', $forward);
                    exit;
                }
            }
        } else {
            $this->_showUpdateForm(ACTION_NAME);
        }
    }

    /**
     * 显示更新静态页面表单
     */
    private function _showUpdateForm($action) {
        $modelId = intval($this->_get('model_id'));
        switch ($action) {
            case self::ACTION_NAME_UPDATE_CONTENT:
                $categoryList = BService('Category')->getCategoryTreeList($modelId, true, 'content_is_set_html');
                break;
            case self::ACTION_NAME_UPDATE_CATEGORY:
                $categoryList = BService('Category')->getCategoryTreeList($modelId);
                break;
            case self::ACTION_NAME_UPDATE_URL:
                //更新url时，获取全栏目可用
                $categoryList = BService('Category')->getCategoryTreeList($modelId, false);
                break;
            default:
                break;
        }
        $str = "<option value='\$category_id' \$selected \$disabled>\$spacer \$category_name</option>";
        $string = getTree($categoryList, $str, $modelId);
        $this->assign('string', $string);
        $this->assign('modelList', $this->modelCache);
        $this->assign('modelId', $modelId);
        $this->display($action);
    }

}

?>
