<?php

/**
 * 推荐位Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-15
 * @updateTime 2013-4-15
 */
class PositionAction extends AdminBaseAction {

    protected $positionModel;
    protected $modelCache;
    protected $categoryCache;

    //推荐位操作列表

    const OPERATE_DELETE = 'delete'; //delete操作
    const OPERATE_SORT = 'sort'; //sort操作
    const OPERATE_URL = 'url'; //url操作

    function _initialize() {
        parent::_initialize();
        $this->positionModel = D('Position');

        $this->modelCache = array();
        $modelList = D('Model')->getModelByType(NULL, 1);
        foreach ($modelList as $model) {
            if ($model['type'] != C('MODEL_TYPE.MEMBER')) {
                $this->modelCache[$model['model_id']] = $model;
            }
        }

        $categoryList = FData('Category');
        // 添加说明
//        foreach ($categoryList as &$category) {
//            $modelNameList = array();
//            foreach (array_keys($category['model']) as $modelId) {
//                if (array_key_exists($modelId, $this->modelCache)) {
//                    $modelNameList[] = $this->modelCache[$modelId]['name'];
//                }
//            }
//            
//            if ($modelNameList) {
//                $category['category_name'] = '[' . implode(',', $modelNameList) . ']' . $category['category_name'];
//            }
//        }

        $this->categoryCache = $categoryList;
    }

    /**
     * 显示推荐位列表
     */
    public function index() {
        $data = $this->positionModel->order(array('sort' => 'ASC', 'position_id' => 'ASC'))->select();
        foreach ($data as $k => $v) {
            $data[$k]['category_name'] = (0 === intval($v['category_id']) ? '所有栏目' : $this->categoryCache[$v['category_id']]['category_name']);
            $data[$k]['model_name'] = (0 === intval($v['model_id']) ? '所有模型' : $this->modelCache[$v['model_id']]['name']);
        }
        $this->assign('data', $data);
        $this->display();
    }

    /**
     * 添加推荐位 
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();
            // 处理附件
            if (($attachmentId = intval($post['attachment_id']))) {
                //检测附件是否存在
                if (($attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId))) {
                    $post['image'] = $attachmentInfo['file_path'];
                } else {
                    $this->setError('附近信息读取失败');
                    return FALSE;
                }
            }

            if ($this->positionModel->create($post)) {
                $insertId = $this->positionModel->add();
                if ($insertId) {
                    BService('Attachment')->apiUpdate(C('ACCESS_TYPE.POSITION'), $insertId, $attachmentId, C('ATTACHMENT_FLAG.ATTACHMENT'));
                    $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Content/Position/index') . '"'));
                } else {
                    $this->bpiAjaxReturn(false, '添加失败');
                }
            } else {
                $this->bpiAjaxReturn(false, $this->positionModel->getError());
            }
        } else {
            $this->assign('modelList', $this->modelCache);
            $this->display('edit');
        }
    }

    /**
     * 编辑推荐位 
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();
            // 处理附件
            if (($attachmentId = intval($post['attachment_id']))) {
                //检测附件是否存在
                if (($attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId))) {
                    $post['image'] = $attachmentInfo['file_path'];
                } else {
                    $this->setError('附近信息读取失败');
                    return FALSE;
                }
            }

            if ($this->positionModel->create($post)) {
                if (FALSE !== $this->positionModel->save()) {
                    BService('Attachment')->apiUpdate(C('ACCESS_TYPE.POSITION'), $post['position_id'], $attachmentId, C('ATTACHMENT_FLAG.ATTACHMENT'));
                    $this->bpiAjaxReturn(true, '更新成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '更新失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $this->positionModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $positionId = intval($this->_get('position_id'));
            $data = $this->positionModel->where(array('position_id' => $positionId))->find();
            if (empty($data)) {
                $this->error('该推荐位不存在');
            }

            $this->assign('data', $data);
            $this->assign('modelList', $this->modelCache);
            $this->display();
        }
    }

    /**
     * 删除推荐位
     */
    public function delete() {
        $positionId = intval($this->_get('position_id'));
        $status = $this->positionModel->where(array('position_id' => $positionId))->delete();
        if ($status) {
            // 删除 data
            M('PositionData')->where(array('position_id' => $positionId))->delete();
            // 删除附件
            BService('Attachment')->apiDelete(C('ACCESS_TYPE.POSITION'), $positionId, NULL, C('ATTACHMENT_FLAG.THUMB'));
            $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->bpiAjaxReturn(false, '删除失败', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 推荐位排序
     */
    public function sort() {
        parent::saveSort($this->positionModel, $this->_post('sort'), 'sort', true);
    }

    /**
     * 推荐位添加栏目加载
     */
    public function public_categoryLoad() {
        $modelId = intval($this->_get('model_id'));
        $categoryId = intval($this->_get('category_id'));

        $html = '<option value="0">所有栏目</option>';
        $str = "<option value='\$category_id' \$selected \$disabled>\$spacer \$category_name</option>";

        $categoryList = BService('Category')->getCategoryList($modelId, false);
        if (is_array($categoryList)) {
            $html .= getTree($categoryList, $str, $categoryId);
        }

        echo $html;
    }

    /**
     * 推荐位数据显示管理
     */
    public function public_positionData() {
        $result = BService('Position')->getPositionDataList(intval($this->_get('position_id')));
        $this->assign('data', $result['positionList']);
        $this->assign('page', $result['page']->show());
        $this->display();
    }

    /**
     * 推荐位数据操作（删除、排序、显示原文）
     */
    public function public_positionDataOperate() {
        $status = FALSE;
        $operate = $this->_get('operate');

        if (IS_POST) {

            // 局部函数，转换key
            function _parseKey($key) {
                $explode = explode('-', $key);
                if (2 !== count($explode)) {
                    return FALSE;
                }

                foreach ($explode as &$value) {
                    if (!is_numeric($value)) {
                        return FALSE;
                    }
                    $value = intval($value);
                }
                return $explode;
            }

            // 开始进行操作判断
            if ($operate === self::OPERATE_DELETE) {
                $keys = $this->_post('delete');
                $positionId = $this->_post('position_id');

                foreach ($keys as $key) {
                    if (($key = _parseKey($key))) {
                        //其中一个处理成功则成功
                        $status |= BService('Position')->deleteData($key[0], $key[1], $positionId);
                    }
                }
                if ($status) {
                    $this->bpiAjaxReturn(TRUE, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
                } else {
                    $this->bpiAjaxReturn(FALSE, '删除失败', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
                }
            } else if ($operate === self::OPERATE_SORT) {
                foreach ($this->_post('sort') as $key => $sort) {
                    if (($key = _parseKey($key))) {
                        $status |= (FALSE !== M('PositionData')->where(array('model_id' => $key[0], 'content_id' => $key[1]))->save(array('sort' => $sort)));
                    }
                }

                if ($status) {
                    $this->bpiAjaxReturn(TRUE, '排序成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(FALSE, '排序失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            }
        } else {
            $get = $this->_get();
            // 读取源URL
            if ($operate === self::OPERATE_URL) {
                $url = BService('Url')->getContentUrl($get['category_id'], $get['content_id']);
                $url && redirect($url);
            }
            $this->error('找不到原文连接');
        }
    }

    /**
     * 推荐位数据编辑
     */
    public function public_positionDataEdit() {
        if (IS_POST) {
            if (BService('Position')->saveData($this->_post())) {
                $this->bpiAjaxReturn(true, '更新成功', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $error = BService('Position')->getError();
                $this->bpiAjaxReturn(false, empty($error) ? '保存失败' : $error, array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $map = array(
                'position_data_id' => intval($this->_get('position_data_id')),
            );

            // 查询数据
            $positionInfo = M('PositionData')->where($map)->find();
            if (empty($positionInfo)) {
                $this->error('找不到推荐位信息', 'javascript:;');
            }
            $this->assign('data', unserialize($positionInfo['data']));
            $this->display();
        }
    }

}

?>
