<?php

/**
 * 计划任务管理Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-22
 * @updateTime 2013-5-22
 */
class CronAction extends AdminBaseAction {

    protected $cronModel, $cronService, $loopType, $capitalWeek, $categoryCache;

    public function _initialize() {
        parent::_initialize();
        //获取栏目缓存
        $this->categoryCache = FData('Category');
        $this->cronModel = D('Cron/Cron');
        $this->cronService = BService('Cron');
        $this->loopType = array('month' => '每月', 'week' => '每周', 'day' => '每日', 'hour' => '每小时', 'now' => '每隔');
        $this->capitalWeek = array('日', '一', '二', '三', '四', '五', '六');
        //计划任务类型
        $planType = array(
            C('CRON_TYPE.CUSTOM') => '普通计划任务',
            C('CRON_TYPE.REFRESH_CATEGORY') => '系统栏目刷新任务',
            C('CRON_TYPE.REFRESH_CUSTOM_PAGE') => '系统自定义页面刷新任务',
            C('CRON_TYPE.REFRESH_INDEX') => '系统网站首页',
        );
        //可执行文件列表
        foreach ($this->cronService->getCronFileList() as $file) {
            $fileList[basename($file, '.php')] = $file;
        }
        $this->assign('planType', $planType);
        $this->assign('fileList', $fileList);
    }

    /**
     * 显示计划任务列表
     */
    public function index() {
        $data = $this->cronModel->order(array('cron_id' => 'DESC'))->select();
        foreach ($data as &$cron) {
            $cron['type'] = $this->loopType[$cron['loop_type']];
            list($day, $hour, $minute) = explode('-', $cron['loop_time']);
            switch ($cron['loop_type']) {
                case 'month':
                    $cron['type'] .= $day == C('CRON_TIME_LAST_DAY') ? '最后一天' : $day . '日';
                    $cron['type'] .= $hour . '时';
                    break;
                case 'week':
                    $cron['type'] .= '星期' . $this->capitalWeek[$day];
                    $cron['type'] .= $hour . '时';
                    break;
                case 'day':
                    $cron['type'] .= $hour . '时';
                    break;
                case 'now':
                    $cron['type'] .= $day ? $day . '日' : '';
                    $cron['type'] .= $hour ? $hour . '时' : '';
            }
            $cron['type'] .= $minute ? $minute . '分' : '00分';
            $cron['last_run_time'] = $cron['last_run_time'] ? date('Y-m-d H:i', $cron['last_run_time']) : '-';
            $cron['next_run_time'] = $cron['next_run_time'] ? date('Y-m-d H:i', $cron['next_run_time']) : '-';
        }
        $this->assign('data', $data);
        $this->display();
    }

    /**
     * 添加计划任务
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();
            //处理循环类型和时间
            $result = $this->cronService->cronAdd($post);
            if ($result) {
                $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Cron/Cron/index') . '"'));
            } else {
                $this->bpiAjaxReturn(false, $this->cronService->getError());
            }
        } else {
            $this->_setPlanType();
            $this->_setDateArray();
            $this->display('edit');
        }
    }

    /**
     * 编辑计划任务
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();
            //处理循环类型和时间
            $result = $this->cronService->cronEdit($post);
            if ($result !== false) {
                $this->bpiAjaxReturn(true, '修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(false, $this->cronService->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $cronId = intval($this->_get('cron_id'));
            $cronList = $this->cronModel->where(array('cron_id' => $cronId))->find();
            if (!$cronList) {
                $this->error('该计划任务不存在');
            }
            list($cronList['day'], $cronList['hour'], $cronList['minute']) = explode('-', $cronList['loop_time']);
            $categorySelected = intval($cronList['type']) == C('CRON_TYPE.REFRESH_CATEGORY') ? $cronList['data'] : '';
            $this->_setPlanType($categorySelected);
            $this->_setDateArray();
            $this->assign('cronList', $cronList);
            $this->display();
        }
    }

    /**
     * 删除计划任务
     */
    public function delete() {
        $param = $this->_param('cron_id');
        $cronIdList = is_array($param) ? $param : array($param);
        if (empty($cronIdList)) {
            $this->bpiAjaxReturn(false, '请选择删除条目', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
        foreach ($cronIdList as $cronId) {
            if (intval($cronId) > 0) {
                $this->cronModel->delete($cronId);
            }
        }
        $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
    }

    /**
     * 构建日期数组
     */
    private function _setDateArray() {
        //生成日期
        $monthDay = array();
        $monthHour = array();
        for ($i = 1; $i <= 31; $i++) {
            $monthDay[$i] = $i . '日';
        }
        $monthDay[C('CRON_TIME_LAST_DAY')] = '最后一天';
        for ($i = 0; $i <= 23; $i++) {
            $monthHour[$i] = $i . '点';
        }
        $dateType = array(
            'loop_type' => $this->loopType,
            'month_day' => $monthDay,
            'month_hour' => $monthHour,
            'week_day' => array('1' => '周一', '2' => '周二', '3' => '周三', '4' => '周四', '5' => '周五', '6' => '周六', '0' => '周日'),
            'hour_minute' => array('0' => '00分', '10' => '10分', '20' => '20分', '30' => '30分', '40' => '40分', '50' => '50分'),
        );
        $this->assign('dateType', $dateType);
    }

    /**
     * 获取计划数据类型
     * @param type $category 栏目选择项
     */
    private function _setPlanType($categorySelected = '') {
        //TODO:未完成，缺少Customtemp数据表
        //$customtemp = M('Customtemp');
        //$customtempList = $customtemp->order(array('temp_id DESC'))->getField('temp_id,name');
        //测试数据
        $customtempList = array('1' => '测试页面', '2' => '又系测试页面');
        $categoryCache = BService('Category')->getCategoryList(0);
        $str = "<option value='\$category_id' \$selected>\$spacer \$category_name</option>";
        $string = getTree($categoryCache, $str, $categorySelected);
        $this->assign('categoryIdList', $string);
        $this->assign('customtempList', $customtempList);
    }

}

?>
