<?php

/**
 * 计划任务Service
 * @author     lyz
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-23
 * @updateTime 2013-5-23
 */
class CronService extends BaseService {

    protected $cronModel;

    function __construct() {
        parent::__construct();
        $this->cronModel = D('Cron/Cron');
    }

    /**
     * 计划任务循环类型
     */
    public function loopType($data) {
        //计划任务循环类型
        $loopType = $data['loop_type'];
        switch ($loopType) {
            case 'month':
                //月份
                $day = $data['month_day'];
                //小时
                $hour = $data['month_hour'];
                //获取 计划任务 下一次执行时间
                $nextTime = $this->getNextTime('month', $day, $hour);
                $data['next_run_time'] = $nextTime;
                //循环类型时间（日-时-分）
                $data['loop_time'] = $day . '-' . $hour . '-0';
                break;
            case 'week':
                $day = $data['week_day'];
                $hour = $data['week_hour'];
                //获取 计划任务 下一次执行时间
                $nextTime = $this->getNextTime('week', $day, $hour);
                $data['next_run_time'] = $nextTime;
                //循环类型时间（日-时-分）
                $data['loop_time'] = $day . '-' . $hour . '-0';
                break;
            case 'day':
                $hour = $data['day_hour'];
                $nextTime = $this->getNextTime('day', 0, $hour);
                $data['next_run_time'] = $nextTime;
                //循环类型时间（日-时-分）
                $data['loop_time'] = '0-' . $hour . '-0';
                break;
            case 'hour':
                $minute = $data['hour_minute'];
                //获取 计划任务 下一次执行时间
                $nextTime = $this->getNextTime('hour', 0, 0, $minute);
                $data['next_run_time'] = $nextTime;
                $data['loop_time'] = '0-0-' . $minute;
                break;
            case 'now':
                $time = intval($data['now_time']);
                $type = $data['now_type'];
                if (!$time) {
                    $this->setError('间隔时间有误');
                    return false;
                }
                $minute = $type == 'minute' ? $time : 0;
                $hour = $type == 'hour' ? $time : 0;
                $day = $type == 'day' ? $time : 0;
                $nextTime = $this->getNextTime('now', $day, $hour, $minute);
                $data['next_run_time'] = $nextTime;
                $data['loop_time'] = $day . '-' . $hour . '-' . $minute;
                break;
            default:
                $this->setError('计划任务循环类型有误');
                return false;
                break;
        }
        return $data;
    }

    /**
     * 处理数据
     * @param type $data
     * @return $data
     */
    public function processing($data) {
        if (!$data || !is_array($data)) {
            $this->setError('数据有误');
            return false;
        }
        $cronFileList = $this->getCronFileList();
        $file = $data['file'] . '.php';
        if (!in_array($file, $cronFileList)) {
            $this->setError('参数有误');
            return false;
        }
        //计划任务循环类型
        $data = $this->loopType($data);
        if ($data == false) {
            return false;
        }
        //计划任务类型处理
        //TODO:常量
        switch ($data['type']) {
            case C('CRON_TYPE.CUSTOM'):
                $data['data'] = '';
                unset($data['category_id'], $data['temp_id']);
                break;
            case C('CRON_TYPE.REFRESH_CATEGORY'):
                if (!$data['category_id']) {
                    $this->setError('请选择需要刷新的栏目');
                    return false;
                }
                $categoryId = implode(',', $data['category_id']);
                unset($data['category_id']);
                $data['data'] = $categoryId;
                $data['file'] = 'BPICMSRefresh_category';
                break;
            case C('CRON_TYPE.REFRESH_CUSTOM_PAGE'):
                if (!$data['temp_id']) {
                    $this->setError('请选择需要刷新自定义页面');
                    return false;
                }
                $tempId = implode(',', $data['temp_id']);
                unset($data['temp_id']);
                $data['data'] = $tempId;
                $data['file'] = 'BPICMSRefresh_custompage';
                break;
            case C('CORN_TYPE.REFRESH_INDEX'):
                $data['file'] = 'BPICMSRefresh_index';
                $data['data'] = '';
                break;
            default :
                $this->setError('计划任务类型有误');
                return false;
                break;
        }
        $createData = $this->cronModel->create($data);
        if (!$createData) {
            $this->setError($this->cronModel->getError());
            return false;
        }
        return $createData;
    }

    /**
     * 添加计划任务
     * @param type $data
     */
    public function cronAdd($data) {
        $data = $this->processing($data);
        if ($data === false) {
            return false;
        }
        $cronId = $this->cronModel->add($data);
        if ($cronId) {
            return $cronId;
        }
        $this->setError('计划任务添加失败');
        return false;
    }

    /**
     * 添加计划任务
     * @param type $data
     */
    public function cronEdit($data) {
        $data = $this->processing($data);
        if ($data === false) {
            return false;
        }
        $cronId = $this->cronModel->save($data);
        if ($cronId !== false) {
            return true;
        }
        $this->setError('计划任务添修改失败');
        return false;
    }

    /**
     * 获得下次执行时间
     * @param string $loopType month/week/day/hour/now
     * @param int $day 几号， 如果是99表示当月最后一天
     * @param int $hour 几点
     * @param int $minute 每小时的几分
     */
    public function getNextTime($loopType, $day = 0, $hour = 0, $minute = 0) {
        $time = time();
        $_minute = intval(date('i', $time));
        $_hour = date('G', $time);
        $_day = date('j', $time);
        $_week = date('w', $time);
        $_mouth = date('n', $time);
        $_year = date('Y', $time);
        $nextTime = mktime($_hour, 0, 0, $_mouth, $_day, $_year);
        switch ($loopType) {
            case 'month':
                //获得天数
                $mouthDayList = date('t', mktime(0, 0, 0, $_mouth, 1, $_year));
                //最后一天
                if ($day == C('CRON_TIME_LAST_DAY')) {
                    $day = $mouthDayList;
                }
                $nextTime += ($hour < $_hour ? -($_hour - $hour) : $hour - $_hour) * 3600;
                if ($hour <= $_hour && $day == $_day) {
                    $nextTime += ($mouthDayList - $_day + $day) * 86400;
                } else {
                    $nextTime += ($day < $_day ? $mouthDayList - $_day + $day : $day - $_day) * 86400;
                }
                break;
            case 'week':
                $nextTime += ($hour < $_hour ? -($_hour - $hour) : $hour - $_hour) * 3600;
                if ($hour <= $_hour && $day == $_week) {
                    $nextTime += (7 - $_week + $day) * 86400;
                } else {
                    $nextTime += ($day < $_week ? 7 - $_week + $day : $day - $_week) * 86400;
                }
                break;
            case 'day':
                $nextTime += ($hour < $_hour ? -($_hour - $hour) : $hour - $_hour) * 3600;
                if ($hour <= $_hour) {
                    $nextTime += 86400;
                }
                break;
            case 'hour':
                $nextTime += $minute < $_minute ? 3600 + $minute * 60 : $minute * 60;
                break;
            case 'now':
                $nextTime = mktime($_hour, $_minute, 0, $_mouth, $_day, $_year);
                $nextTime += ($day * 24 * 60 + $hour * 60 + $minute) * 60;
                break;
        }
        return $nextTime;
    }

    /**
     * 获取可用计划任务执行文件
     * @return type
     */
    public function getCronFileList() {
        $fileList = array();
        foreach (glob(APP_PATH . C('APP_GROUP_PATH') . DS . MODULE_NAME . DS . 'CronFile' . DS . 'BPICMS*.php') as $file) {
            $fileList [] = basename($file);
        }
        return $fileList;
    }

}
?>

