<?php

/**
 * 域名管理action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-22
 * @updateTime 2013-5-22
 */
class DomainAction extends AdminBaseAction {

    protected $domainModel, $unnecessaryModule;

    function _initialize() {
        parent::_initialize();
        $moduleList = array();
        foreach (FData('Module') as $module) {
            $moduleList[$module['module']] = $module['name'];
        }
        //不必要的模块名称
        $this->unnecessaryModule = array('Domain', 'Attachment', 'Content', 'Model', 'Template');
        //移除不必要的模块
        foreach ($this->unnecessaryModule as $uModule) {
            unset($moduleList[$uModule]);
        }
        $this->assign('moduleList', $moduleList);
        $this->domainModel = D('Domain/Domain');
    }

    /**
     * 显示域名绑定列表
     */
    public function index() {
        $data = $this->domainModel->select();
        $this->assign('data', $data);
        $this->display();
    }

    /**
     * 添加域名绑定
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();
            if (in_array($post['module'], $this->unnecessaryModule)) {
                $this->bpiAjaxReturn(false, '添加失败，绑定模块参数错误');
            }
            if ($this->domainModel->create($post)) {
                $result = $this->domainModel->add();
                if ($result) {
                    $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Domain/Domain/index') . '"'));
                } else {
                    $this->bpiAjaxReturn(false, '添加失败');
                }
            } else {
                $this->bpiAjaxReturn(false, $this->domainModel->getError());
            }
        } else {
            $this->display('edit');
        }
    }

    /**
     * 编辑域名绑定
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();
            if (in_array($post['module'], $this->unnecessaryModule)) {
                $this->bpiAjaxReturn(false, '编辑失败，绑定模块参数错误');
            }
            $data = $this->domainModel->create($post);
            if ($data) {
                $result = $this->domainModel->where(array('domain_id' => $data['domain_id']))->save($data);
                if ($result !== false) {
                    $this->bpiAjaxReturn(true, '修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '修改失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $this->domainModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $domainId = intval($this->_get('domain_id'));
            $domain = $this->domainModel->where(array('domain_id' => $domainId))->find();
            if (!$domain) {
                $this->error('该信息不存在');
            }
            $this->assign('domain', $domain);
            $this->display();
        }
    }

    /**
     * 删除域名绑定
     */
    public function delete() {
        $param = $this->_param('domain_id');
        $domainIdList = (array) $param;
        if (empty($domainIdList)) {
            $this->bpiAjaxReturn(false, '请选择删除条目', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
        foreach ($domainIdList as $domainId) {
            if (intval($domainId) > 0) {
                $this->domainModel->delete($domainId);
            }
        }
        $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
    }

}

?>
