<?php

/**
 * 收藏Action
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
class ApplicationFavoriteAction extends MemberBaseAction {

    protected $favoriteService;
    private $userId, $moduleId;

    function _initialize() {
        parent::_initialize();
        $this->favoriteService = BService('Favorite', 'Favorite');
        $this->moduleId = C('ACCESS_TYPE.APPLICATION');
        $this->userId = BaseAction::getVar('user_id');
    }

    /**
     * 是否收藏某应用
     */
    public function isFavorite() {
        if (IS_POST) {
            $post = $this->_post();
            if ($this->favoriteService->isFavorite($this->userId, $this->moduleId, $post['application_id'])) {
                $this->ajaxReturn(array('status' => 1));
            } else {
                $this->ajaxReturn(array('status' => 0));
            }
        }
    }

    /**
     * 获取收藏列表
     */
    public function getFavoriteList() {
        $get = $this->_get();
        $pageIndex = isset($get[C('VAR_PAGE')]) ? max(intval($get[C('VAR_PAGE')]), 1) : 1;
        $favoriteList = $this->favoriteService->getFavoriteList($this->userId, $this->moduleId, 0, 0, $pageIndex);
        $this->assign('seo', seo('', '我的收藏'));
        $this->assign('page', $favoriteList['page']->frontShow());
        $this->assign('favoriteList', $favoriteList['favoriteList']);
        $this->assign('current', 'favorite');
        $this->assign('header', 'favorite');
        $this->display('Member:Index:favorite');
    }

    /**
     * 收藏应用
     */
    public function addFavorite() {
        if (IS_POST) {
            $post = $this->_post();
            if ($this->favoriteService->addFavorite($this->userId, $this->moduleId, $post['application_id'])) {
                $this->ajaxReturn(array('status' => 1, 'info' => '收藏成功'));
            } else {
                $error = $this->favoriteService->getError();
                $info = empty($error) ? '收藏失败' : $error;
                $this->ajaxReturn(array('status' => 0, 'info' => $info));
            }
        }
    }

    /**
     * 更新收藏列表
     */
//    public function updateFavorite() {
//        // 此方法会覆盖收藏，addFavorite是会保留原收藏
//        if (IS_POST) {
//            $post = $this->_post();
////            $post = array(
////                'application_id' => 1,
////            );
//            if ($this->favoriteService->updateFavorite($this->userId, $this->moduleId, $post['application_id'])) {
//                $this->ajaxReturn(array('status' => true, 'info' => '收藏更新成功'), 'JSON');
//            } else {
//                $error = $this->favoriteService->getError();
//                $info = empty($error) ? '收藏更新失败' : $error;
//                $this->ajaxReturn(array('status' => FALSE, 'info' => $info), 'JSON');
//            }
//        }
//    }

    /**
     * 删除收藏
     */
    public function deleteFavorite() {
        if (IS_POST) {
            $post = $this->_post();
            if ($this->favoriteService->deleteFavorite($this->userId, $this->moduleId, $post['application_id'])) {
                $this->ajaxReturn(array('status' => 1, 'info' => '删除收藏成功'));
            } else {
                $error = $this->favoriteService->getError();
                $info = empty($error) ? '删除收藏失败' : $error;
                $this->ajaxReturn(array('status' => 0, 'info' => $info));
            }
        }
    }

}

?>
