<?php

/**
 * 收藏Service
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-11
 * @updateTime 2013-8-11
 */
class FavoriteService extends BaseService {

    private $favoriteModel;

    public function __construct() {
        parent::__construct();

        $this->favoriteModel = D('Favorite/Favorite');
    }

    /**
     * 判断是否收藏了某个ID
     * @param type $userId              用户ID
     * @param type $moduleId            模块ID，为NULL时自动获取当前模块ID
     * @param type $accessId            关联ID
     * @param type $type                类型，默认值为0
     * @param type $flag                标志，默认值为0
     * @return boolean
     */
    public function isFavorite($userId, $moduleId, $accessId, $type = 0, $flag = 0) {
        $userId = intval($userId);
        $accessId = intval($accessId);
        $type = intval($type);
        $flag = intval($flag);

        if (empty($userId)) {
            $this->setError('用户ID不存在');
            return FALSE;
        }

        if (empty($accessId)) {
            $this->setError('ID不存在');
            return FALSE;
        }

        // 处理模型ID
        if (FALSE === ($moduleId = $this->_parseModuleId($moduleId))) {
            $this->setError('模块ID解析失败');
            return FALSE;
        }

        $map = array(
            'module_id' => $moduleId,
            'access_id' => $accessId,
            'type' => $type,
            'flag' => $flag,
            'user_id' => $userId
        );

        if ($this->favoriteModel->where($map)->find()) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    /**
     * 获取收藏列表
     * @param type $userId              用户ID
     * @param type $moduleId            模块ID，为NULL时自动获取当前模块ID
     * @param type $type                类型，默认值为0
     * @param type $flag                标志，默认值为0
     * @return boolean|array            失败返回FALSE，成功返回收藏列表
     */
    public function getFavoriteList($userId, $moduleId, $type = 0, $flag = 0, $pageIndex = 1, $listRow = 20) {
        $userId = intval($userId);
        $type = intval($type);
        $flag = intval($flag);

        // 分页处理
        $pageIndex = max(1, intval($pageIndex));
        $listRow = intval($listRow);

        if (empty($userId)) {
            $this->setError('用户ID不存在');
            return FALSE;
        }

        // 处理模型ID
        if (FALSE === ($moduleId = $this->_parseModuleId($moduleId))) {
            $this->setError('模块ID解析失败');
            return FALSE;
        }

        $map = array(
            'module_id' => $moduleId,
            'type' => $type,
            'flag' => $flag,
            'user_id' => $userId
        );

        $favoriteList = array();
        $count = $this->favoriteModel->where($map)->count();
        $page = page($count, $listRow, $pageIndex);
        if ($count) {
            $reslut = $this->favoriteModel->field('access_id,create_time')->where($map)->order('create_time DESC')->limit($page->firstRow . ',' . $page->listRows)->select();
            if (FALSE === $reslut) {
                $this->setError('获取列表失败');
                return FALSE;
            }

            // 取出应用ID
            $applicationIdList = array();
            foreach ($reslut as $value) {
                $applicationIdList[] = $value['access_id'];
            }

            $applicationList = setArrayIndexByKey(D('Market/Application')->where(array('id' => array('IN', $applicationIdList)))->select(), 'id');

            // 格式化并根据ID进行排序
            foreach ($applicationIdList as $applicationId) {
                $favoriteList[] = BService('MarketView', 'Index')->formatSimpleApplicaition($applicationList[$applicationId]);
            }
        }

        return array(
            'favoriteList' => $favoriteList,
            'page' => $page,
        );
    }

    /**
     * 添加收藏
     * @param type $userId              用户ID
     * @param type $moduleId            模块ID，为NULL时自动获取当前模块ID
     * @param type $accessIds           关联ID列表，可以为单个ID，也可以为ID数组
     * @param type $type                分类ID，默认值为0
     * @param type $flag                标志，默认值为0
     * @return boolean                  成功返回TRUE，失败返回FALSE
     */
    public function addFavorite($userId, $moduleId, $accessIds, $type = 0, $flag = 0) {
        $userId = intval($userId);
        $type = intval($type);
        $flag = intval($flag);

        if (empty($userId)) {
            $this->setError('用户ID不存在');
            return FALSE;
        }

        // 处理ID
        is_numeric($accessIds) && $accessIds = array($accessIds);
        if (!is_array($accessIds)) {
            $this->setError('关联ID列表不合法');
            return FALSE;
        }

        // 处理模型ID
        if (FALSE === ($moduleId = $this->_parseModuleId($moduleId))) {
            $this->setError('模块ID解析失败');
            return FALSE;
        }

        $status = FALSE;
        foreach ($accessIds as $accessId) {
            if (!$this->isFavorite($userId, $moduleId, $accessId, $type, $flag)) {
                // 新增
                $data = array(
                    'module_id' => $moduleId,
                    'access_id' => $accessId,
                    'type' => $type,
                    'flag' => $flag,
                    'user_id' => $userId,
                    'create_time' => time()
                );

                $status |= (bool) $this->favoriteModel->add($data);
            } else {
                $status = TRUE;
            }
        }

        return TRUE;
    }

    /**
     * 更新收藏列表
     * @param type $userId              用户ID
     * @param type $moduleId            模块ID，为NULL时自动获取当前模块ID
     * @param type $accessIdList        关联ID列表，可以为单个ID，也可以为ID数组
     * @param type $type                分类ID，默认值为0
     * @param type $flag                标志，默认值为0
     * @return boolean                  成功返回TRUE，失败返回FALSE
     * 此方法会覆盖收藏，addFavorite是会保留原收藏
     */
//    public function updateFavorite($userId, $moduleId, $accessIdList, $type = 0, $flag = 0) {
//        $userId = intval($userId);
//        $type = intval($type);
//        $flag = intval($flag);
//
//        if (empty($userId)) {
//            $this->setError('用户ID不存在');
//            return FALSE;
//        }
//
//        // 处理ID
//        is_numeric($accessIdList) && $accessIdList = array($accessIdList);
//        if (!is_array($accessIdList)) {
//            $this->setError('关联ID列表不合法');
//            return FALSE;
//        }
//
//        // 处理模型ID
//        if (FALSE === ($moduleId = $this->_parseModuleId($moduleId))) {
//            $this->setError('模块ID解析失败');
//            return FALSE;
//        }
//
//        $map = array(
//            'module_id' => $moduleId,
//            'type' => $type,
//            'flag' => $flag,
//            'user_id' => $userId
//        );
//
//        $status = FALSE;
//        $favoriteList = setArrayIndexByKey($this->getFavoriteList($userId, $moduleId, $type, $flag), 'access_id');
//        foreach ($accessIdList as $accessId) {
//            if (!isset($favoriteList[$accessId])) {
//                // 新增
//                $data = array(
//                    'module_id' => $moduleId,
//                    'access_id' => $accessId,
//                    'type' => $type,
//                    'flag' => $flag,
//                    'user_id' => $userId,
//                    'create_time' => time()
//                );
//
//                $status |= (bool) $this->favoriteModel->add($data);
//            } else {
//                unset($favoriteList[$accessId]);
//                $status = TRUE;
//            }
//        }
//
//        // 删除多余的数据
//        if ($favoriteList) {
//            $deleteIdList = array_keys($favoriteList);
//            $this->favoriteModel->where(array('access_id' => array('IN', $deleteIdList)))->delete();
//        }
//        return $status;
//    }

    /**
     * 删除收藏
     * @param type $userId              用户ID
     * @param type $moduleId            模块ID，为NULL时自动获取当前模块ID
     * @param type $accessIds           关联ID列表，可以为单个ID，也可以为ID数组，为TRUE时删除全部
     * @param type $type              分类ID，默认值为0
     * @param type $flag                标志，默认值为0
     * @return boolean                  成功返回TRUE，失败返回FALSE
     */
    public function deleteFavorite($userId, $moduleId, $accessIds, $type = 0, $flag = 0) {
        $type = intval($type);
        $flag = intval($flag);

        // 处理模型ID
        if (FALSE === ($moduleId = $this->_parseModuleId($moduleId))) {
            $this->setError('模块ID解析失败');
            return FALSE;
        }

        $map = array(
            'module_id' => $moduleId,
            'type' => $type,
            'flag' => $flag,
        );

        if (!is_null($userId)) {
            $map['user_id'] = intval($userId);
        }

        // 根据$accessIds进行查询
        if (TRUE !== $accessIds) {
            is_numeric($accessIds) && $accessIds = array($accessIds);
            if (is_array($accessIds)) {
                $map['access_id'] = array('in', $accessIds);
            } else {
                $this->setError('关联ID列表不合法');
                return FALSE;
            }
        }

        $count = $this->favoriteModel->where($map)->delete();
        return $count;
    }

    /**
     * 处理关联模块id
     * @param type $moduleIdentify    模块标识，id/type
     * @param type $isUpdate    是否更新插入模块id
     * @return boolean          失败返回FALSE，成功返回经过处理的模块ID
     */
    private function _parseModuleId($moduleIdentify, $isUpdate = false) {
        if (is_numeric($moduleIdentify)) {
            $moduleId = $this->accessTypeModel->where(array('access_type_id' => $moduleIdentify))->getField('access_type_id');
        } else {
            //通过关联类型获取关联模块id
            $moduleId = $this->accessTypeModel->where(array('access_type' => $moduleIdentify))->getField('access_type_id');
        }

        // 判断模块ID的合法性
        if (!$moduleId) {
            if ($isUpdate) {
                $accessTypeData = array(
                    'access_type' => $moduleIdentify
                );
                //增加到附件关联类型表
                $moduleId = $this->accessTypeModel->add($accessTypeData);
            } else {
                $this->setError('模块ID不合法');
                return FALSE;
            }
        }

        return $moduleId;
    }

}

?>