<?php

/**
 * 文章评论Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
class CommentAction extends MemberBaseAction {

    protected $commentService;

    function _initialize() {
        parent::_initialize();
        $this->commentService = BService('Comment', 'Comment');
    }

    /**
     * 获取评论列表方法
     */
    public function public_getCommentList() {
        $get = $this->_get();
        $contentId = $get['content_id'];
        if (empty($contentId)) {
            return;
        }

        $pageIndex = (isset($get['page_index']) && $get['page_index']) ? intval($get['page_index']) : 1;
        $listRow = (isset($get['list_row']) && $get['list_row']) ? intval($get['list_row']) : 10;

        $commentData = $this->commentService->getCommentListByContentId($contentId, $pageIndex, $listRow, true);
        $commentList = $commentData['commentList'];
        $page = $commentData['page'];

        $this->assign('commentList', $commentList);
        $this->assign('page', $page->frontShow());
        $this->display('Path:Common:commentList');
    }

    /**
     * 添加评论
     */
    public function public_add() {
        if (IS_POST) {
            $post = $this->_post();
//            $post = array(
//                'content_id' => 1,
//                'pid' => 0,
//                'content' => '测试评论',
//                'score' => 5,
//                'version' => '1.1.1'
//            );
            $setting = BaseAction::getVar('config');
            //是否开启评论验证码
            if ($setting['comment_is_need_verify']) {
                if (!BService('Verify')->checkVerify($post[C('VERIFY_TYPE.COMMENT')], C('VERIFY_TYPE.COMMENT'))) {
                    $this->ajaxReturn(array('status' => false, 'info' => '验证码错误'), 'JSON');
                }
            }
            if ($this->commentService->add($post['content_id'], $post['content'], $post, BaseAction::getVar('user_id'), $post['pid'])) {
                $this->ajaxReturn(array('status' => true, 'info' => '评论添加成功'), 'JSON');
            } else {
                $error = $this->commentService->getError();
                $info = empty($error) ? '评论添加失败' : $error;
                $this->ajaxReturn(array('status' => FALSE, 'info' => $info), 'JSON');
            }
        } else {
//            $commentId = intval($this->_get('comment_id'));
//            $commentInfo = $this->CommentService->getCommentById($commentId);
//            if ($commentInfo) {
//                $fieldList = M('CommentField')->order('field_id DESC')->select();
//                $this->assign('commentInfo', $commentInfo);
//                $this->assign('fieldList', $fieldList);
//                $this->display();
//            } else {
//                $this->error('该评论不存在');
//            }
        }
    }

    /**
     * 编辑评论
     */
    /* public function edit() {
      if (IS_POST) {
      $post = $this->_post();
      $post = array(
      'comment_id' => 10,
      'content' => '修改评论2',
      'score' => 2,
      'version' => '2.2.2.2'
      );
      if ($this->commentService->edit($post['comment_id'], $post['content'], $post)) {
      $this->ajaxReturn(array('status' => true, 'info' => '评论编辑成功'), 'JSON');
      } else {
      $error = $this->commentService->getError();
      $info = empty($error) ? '评论编辑失败' : $error;
      $this->ajaxReturn(array('status' => FALSE, 'info' => $info), 'JSON');
      }
      } else {
      $commentId = intval($this->_get('comment_id'));
      $commentInfo = $this->CommentService->getCommentById($commentId);
      if ($commentInfo) {
      $fieldList = M('CommentField')->order('field_id DESC')->select();
      $this->assign('commentInfo', $commentInfo);
      $this->assign('fieldList', $fieldList);
      $this->display();
      } else {
      $this->error('该评论不存在');
      }
      }
      } */

    /**
     * 删除评论
     */
    /* public function delete() {
      $commentId = $this->_param('comment_id');
      if (empty($commentId)) {
      $this->bpiAjaxReturn(false, '请选择删除条目', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
      }

      $commentIdList = $commentId;
      if (!is_array($commentId)) {
      $commentIdList = array($commentId);
      }

      $count = 0;
      foreach ($commentIdList as $id) {
      if (intval($id) > 0) {
      $count += intval($this->commentService->delete($id, intval(BaseAction::getVar('user/user_id'))));
      }
      }
      if ($count > 0) {
      $this->ajaxReturn(array('status' => true, 'info' => '评论删除成功'), 'JSON');
      } else {
      $this->ajaxReturn(array('status' => false, 'info' => '评论删除失败'), 'JSON');
      }
      } */
}

?>
