<?php

/**
 * 下载Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-11-28
 * @updateTime 2013-11-28
 */
class DownloadAction extends FrontBaseAction {

    public function _initialize() {
        parent::_initialize();
    }

    /**
     * 普通下载页面
     */
    public function download() {
        $get = $this->_get();
        $attachmentHash = intval($get['hash']);
        if (!$attachmentHash) {
            $this->error('参数缺失');
        }
        $url = getAttachmentUrlByHash($attachmentHash);
        $this->assign('downloadUrl', $url);
        $this->display();
    }

    /**
     * 程序下载页面(可传url或者hash获取url)
     */
    public function downloadApplication() {
        $get = $this->_get();
        $applicationId = intval($get['id']);
        $modelName = $get['mn'];
        $attachmentHash = $get['hash'];
        $categoryId = intval($get['category_id']);
        $url = urldecode(bpiHtmlspecialcharsDecode($get['url']));
        if (empty($applicationId) || empty($modelName) || (empty($attachmentHash) && empty($url))) {
            $this->error('参数缺失');
        }
        $applicationTypeList = C('APPLICATION_TYPE');
        $applicationType = NULL;
        if (array_key_exists(strtoupper($modelName), $applicationTypeList)) {
            $applicationType = $applicationTypeList[strtoupper($modelName)];
        }
        BService('Hit')->hit(C('ACCESS_TYPE.APPLICATION'), $applicationId, $applicationType, C('HIT_FLAG.DOWNLOAD'), $categoryId);
        if (empty($url)) {
            $url = getAttachmentUrlByHash($attachmentHash);
        }
        $filePath = urlToFilePath($url);
        if (is_file($filePath)) {
            $info = D('Application')->where(array('id' => $applicationId))->find();
            $file_Info = pathinfo($filePath);
            $extension = '.' . $file_Info['extension'];
            HTTP::FileDownload($filePath, $info['package_name'] . $extension);
        } else {
            redirect($url);
        }
    }

}

?>
