<?php

/**
 * 首页Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-11-7
 * @updateTime 2013-11-7
 */
class IndexAction extends FrontBaseAction {

    protected $categoryCache, $modelCache;

    const APPLICATION_SORT_TYPE_DOWNLOAD = 'download'; //程序排序类型-下载排行
    const APPLICATION_SORT_TYPE_SCORE = 'score'; //程序排序类型-评分排行
    const APPLICATION_SORT_TYPE_UPDATE_TIME = 'update_time'; //程序排序类型-发布时间排行

    public function _initialize() {
        parent::_initialize();
    }

    /**
     * 显示首页
     */
    public function index() {
        // 开启静态重定向到首页
        if (BaseAction::getVar('config/site_index_static') && is_file(SITE_PATH . 'index.html')) {
            redirect(INDEX_URL);
        } else {
            //动态首页时候，删除静态html
            if (is_file(SITE_PATH . 'index.html')) {
                @unlink(SITE_PATH . 'index.html');
            }
        }

        $this->assign('seo', seo());
        //推荐应用列表
        $this->assign('recommendedAppList', BService('MarketView', 'Index')->getRecommendedAppList(15));
        //每日一荐程序
        $this->assign('oneDayOneApplication', BService('MarketView', 'Index')->getOneDayOneApplication());
        //游戏下载排行榜列表
        $topGameData = BService('MarketView', 'Index')->getDownloadTopApplicationList(null, C('APPLICATION_MODEL_NAME.GAME'), 1, 10);
        $this->assign('downloadTopGameList', $topGameData['applicationList']);
        //应用下载排行榜列表
        $topAppData = BService('MarketView', 'Index')->getDownloadTopApplicationList(null, C('APPLICATION_MODEL_NAME.APP'), 1, 10);
        $this->assign('downloadTopAppList', $topAppData['applicationList']);
        //最新更新排行榜列表
        $latestApplicationData = BService('MarketView', 'Index')->getLatestApplicationList(null, null, 1, 10);
        $this->assign('latestApplicationList', $latestApplicationData['applicationList']);
        //评测文章列表
        $reviewList = BService('MarketView', 'Index')->getContentList('Review', 1, 5);
        $this->assign('reviewList', $reviewList['contentList']);
        //公告列表
        $noticeList = BService('MarketView', 'Index')->getContentList('Notice', 1, 5);
        $this->assign('noticeList', $noticeList['contentList']);

        //TODO:微博地址
        //APP下载
        $appVersionList = BService('MarketView', 'Index')->getLastestAppVersionUrl(86400);
        $this->assign('androidPadAppUrl', $appVersionList[C('APP_VERSION_TYPE.ANDROID_PAD')]);
//        $this->assign('androidAppUrl', $appVersionList[C('APP_VERSION_TYPE.ANDROID')]);
        //TODO:热门搜索
        //首页幻灯片
        $topSliderList = BService('MarketView', 'Index')->getTopSlider(5);
        $this->assign('topSliderList', $topSliderList);
        //首页特别推荐
        $getSpecialRecommendedList = BService('MarketView', 'Index')->getSpecialRecommended(4);
        $this->assign('specialRecommendedList', $getSpecialRecommendedList);
        //友情链接
        $linkData = BService('Link', 'Link')->getLinkList(null, 1, 20, NULL, 86400);
        $this->assign('linkList', $linkData['linkList']);
        $this->assign('header', 'index');
        $this->display(BaseAction::getVar('config/site_index_template'));
    }

    /**
     * 显示程序列表页面
     * @return boolean
     */
    public function applicationList() {
        $get = $this->_get();
        $modelName = $get['mn'];
        $sort = isset($get['sort']) ? $get['sort'] : self::APPLICATION_SORT_TYPE_DOWNLOAD;
        $pageIndex = isset($get[C('VAR_PAGE')]) ? max(intval($get[C('VAR_PAGE')]), 1) : 1;
        if (!$modelName) {
            $this->error('操作失败');
            return false;
        }
        $categoryId = isset($get['category_id']) ? intval($get['category_id']) : NULL;
        $categoryList = BService('MarketView', 'Index')->getApplicationCategoryList($modelName);
        //过滤非法栏目id
        if ($categoryId && !array_key_exists($categoryId, $categoryList)) {
            $categoryId = NULL;
        }

        switch ($sort) {
            case self::APPLICATION_SORT_TYPE_UPDATE_TIME://更新时间排序
                $applicationData = BService('MarketView', 'Index')->getLatestApplicationList($categoryId, $modelName, $pageIndex, 10, MarketViewService::FOTMAT_TYPE_ENUM_NORMAL);
                break;
            case self::APPLICATION_SORT_TYPE_SCORE://评分排序
                $applicationData = BService('MarketView', 'Index')->getScoreTopApplicationList($categoryId, $modelName, $pageIndex, 10, MarketViewService::FOTMAT_TYPE_ENUM_NORMAL);
                break;
            case self::APPLICATION_SORT_TYPE_DOWNLOAD://下载排序
            default:
                $sort = self::APPLICATION_SORT_TYPE_DOWNLOAD;
                $applicationData = BService('MarketView', 'Index')->getDownloadTopApplicationList($categoryId, $modelName, $pageIndex, 10, MarketViewService::FOTMAT_TYPE_ENUM_NORMAL);
                break;
        }
        $applicationList = $applicationData['applicationList'];
        $page = $applicationData['page'];

        //获取本栏目下载排行
        if ($sort == self::APPLICATION_SORT_TYPE_DOWNLOAD && $pageIndex == 1) {
            $downloadTopData = $applicationData;
        } else {
            $downloadTopData = BService('MarketView', 'Index')->getDownloadTopApplicationList($categoryId, $modelName, 1, 10, MarketViewService::FOTMAT_TYPE_ENUM_NORMAL);
        }
        $downloadTopApplicationList = $downloadTopData['applicationList'];
        $this->assign('categoryId', $categoryId);
        $this->assign('applicationList', $applicationList);
        $this->assign('downloadTopApplicationList', $downloadTopApplicationList);
        $this->assign('page', $page->frontShow());
        $this->assign('categoryList', $categoryList);
        $this->assign('header', $modelName);
        $this->assign('sort', $sort);
        //SEO
        if (is_null($categoryId)) {
            $applicationCategoryList = FData('Category');
            $modelId = D('Model')->getModelIdByModelName($modelName, C('MODEL_TYPE.APPLICATION'));
            foreach ($applicationCategoryList as $_category) {
                if (empty($_category['pid_array']) && array_key_exists($modelId, $_category['model'])) {
                    $categoryId = $_category['category_id'];
                    break;
                }
            }
        }
        $this->assign('seo', seo($categoryId));
        $this->display();
    }

    /**
     * 显示内容栏目页
     */
    public function contentList() {
        $get = $this->_get();
        $pageIndex = intval($get[C('VAR_PAGE')]);
        $modelName = isset($get['mn']) ? $get['mn'] : C('CONTENT_MODEL_NAME.REVIEW');

        $modelId = D('Model')->getModelIdByModelName($modelName, C('MODEL_TYPE.CONTENT'));
        if (!$modelId) {
            $this->error('操作失败');
            return false;
        }
        $data = BService('Content')->getContentListByCategoryId($get['category_id'], $modelId, $pageIndex, 10);
        if ($data) {
            $contentList = array();
            $originContentList = $data['contentList'];
            if ($originContentList) {
                foreach ($originContentList as $_content) {
                    $contentList[] = BService('MarketView', 'Index')->formatNormalContent($_content);
                }
                $this->assign('page', $data['page']->frontShow());
            }
        }

        $this->assign('categoryId', $get['category_id']);
        $this->assign('contentList', $contentList);
        $this->assign('header', $modelName);

        //文章列表
        $this->_showContentList();

        //下载排行列表
        $this->_showDownloadTopList();
        //SEO
        $categoryId = NULL;
        $categoryList = FData('Category');
        foreach ($categoryList as $_category) {
            if (empty($_category['pid_array']) && array_key_exists($modelId, $_category['model'])) {
                $categoryId = $_category['category_id'];
                break;
            }
        }
        $this->assign('seo', seo($categoryId, '', '', '', 'content'));
        $this->display('Index:List:list');
    }

    /**
     * 显示程序页面
     */
    public function application() {
        $get = $this->_get();
        $id = intval($get['id']);
        if (!$id) {
            $this->error('操作失败');
        }

        $config = BaseAction::getVar('config');
        $applicationOriginData = BService('Application', 'Market')->getApplicationById($id, NULL, NULL, true, TRUE);
        if (empty($applicationOriginData)) {
            $this->error('内容不存在');
        }

        //格式化后的原始数据
        $applicationOriginFormatData = BService('MarketView', 'Index')->formatDetailApplication($applicationOriginData);
        $applicationData = BService('Html')->getContentData($applicationOriginData, 1, 'Application');
        $modelName = D('Model')->getModelTableName($applicationData['model_id'], false, true);
        //获取程序类型
        $applicationType = D('Market/Application')->getApplicationTypeByModelId($applicationData['model_id']);

        $categoryId = $applicationData['category_id'];
        $categoryInfo = BService('Category')->getCategoryInfo($categoryId);
        //面包屑导航
        $breadCrumbList = array(
            array('name' => $config['site_name'], 'url' => $config['site_url']),
            array('name' => '安卓' . $applicationData['application_type'], 'url' => U('Index/Index/applicationList', array('mn' => strtolower($modelName)))),
            array('name' => $categoryInfo['category_name'], 'url' => U('Index/Index/applicationList', array('mn' => strtolower($modelName), 'category_id' => $categoryId))),
            array('name' => $applicationData['title'], 'url' => '#'),
        );
        //增加浏览数
        BService('Hit')->hit(C('ACCESS_TYPE.APPLICATION'), $id, $applicationType, C('HIT_FLAG.HIT'), $applicationOriginData['category_id']);
        //评论数
        $applicationOriginFormatData['comment_count'] = BService('ApplicationComment', 'Market')->getCommentCountByApplicationId($id);
        //合并数据
        $showApplicationData = array_merge($applicationData, $applicationOriginFormatData);
        $this->_showDownloadTopList($applicationData['category_id'], $modelName);
        $this->assign('breadCrumbList', $breadCrumbList); //面包屑
        $this->assign('needVerify', $config['application_comment_is_need_verify']);
        $this->assign('appInfo', $showApplicationData);
        $this->assign('seo', seo($categoryId, $applicationOriginData['title'], $applicationOriginData['description'], $applicationOriginData['keyword']));
        $this->display($applicationData['template_file']);
    }

    /**
     * 显示文章页面
     */
    public function content() {
        $get = $this->_get();
        $id = intval($get['id']);
        $page = isset($get[C('VAR_PAGE')]) ? max(intval($get[C('VAR_PAGE')]), 1) : 1;
        if (!$id) {
            $this->error('操作失败');
        }
        $contentOriginData = BService('Content')->getContentById($id, NULL, NULL, true, TRUE);
        if (empty($contentOriginData)) {
            $this->error('内容不存在');
        }
        //格式化后的原始数据
        $contentOriginFormatData = BService('MarketView', 'Index')->formatDetailContent($contentOriginData);
        $contentData = BService('Html')->setCategoryCache('Category')->getContentData($contentOriginData, $page, 'Content');
        $config = BaseAction::getVar('config');
        $this->assign('needVerify', $config['comment_is_need_verify']); //评论是否需要验证码
        //增加浏览数
        BService('Hit')->hit(C('ACCESS_TYPE.CONTENT'), $id, NULL, C('HIT_FLAG.HIT'), $contentOriginData['category_id']);
        //面包屑导航
        $modelName = D('Model')->getModelTableName($contentData['model_id'], false, true);
        $categoryList = FData('Category');
        $breadCrumbList = array(
            array('name' => $config['site_name'], 'url' => $config['site_url']),
            array('name' => $categoryList[$contentData['category_id']]['category_name'], 'url' => U('Index/Index/contentList', array('mn' => strtolower($modelName)))),
            array('name' => '文章正文', 'url' => '#'),
        );
        $this->assign('breadcrumb', $breadCrumbList); //面包屑 
        //文章列表
        $this->_showContentList();
        //下载排行列表
        $this->_showDownloadTopList();
        //上一页下一页
        $this->_showPreviousNextLink($contentData['model_id'], $contentData['category_id'], $contentData['update_time']);
        //合并数据
        $showContentData = array_merge($contentData, $contentOriginFormatData);
        $this->assign('page', isset($contentData['page']) ? $contentData['page'] : '');
        $this->assign('data', $showContentData);
        $this->assign('config', $config);
        $this->assign('seo', seo($contentOriginData['category_id'], $contentOriginData['title'], $contentOriginData['description'], $contentOriginData['tag'], 'content'));
        $this->display($contentData['template_file']);
    }

    /**
     * 显示专题列表页面
     */
    public function topicList() {
        $topicList = BService('MarketView', 'Index')->getTopicCategoryList();
        //下载排行
        $this->_showSortDownloadList();
        //文章列表
        $this->_showContentList();
        $this->assign('topicList', $topicList);
        $this->assign('header', 'topicList');
        $this->assign('seo', seo(NULL, '推荐专题'));
        $this->display();
    }

    /**
     * 显示专题详细页面
     */
    public function topic() {
        $get = $this->_get();
        $topicId = $get['category_id'];
        if (empty($topicId)) {
            $this->error('操作失败');
        }
        $pageIndex = max(1, intval($get[C('VAR_PAGE')]));
        $topicInfo = BService('MarketView', 'Index')->getTopicByCategoryId($topicId);
        $applicationData = BService('MarketView', 'Index')->getApplicationList($topicId, null, $pageIndex, 10, MarketViewService::FOTMAT_TYPE_ENUM_NORMAL);
        $applicationList = $applicationData['applicationList'];
        $page = $applicationData['page'];
        $this->assign('topic', $topicInfo);
        $this->assign('page', $page->frontShow());
        $this->assign('applicationList', $applicationList);
        //面包屑
        $config = BaseAction::getVar('config');
        $breadCrumbList = array(
            array('name' => $config['site_name'], 'url' => $config['site_url']),
            array('name' => '推荐专题', 'url' => U('Index/Index/topicList')),
            array('name' => $topicInfo['category_name'], 'url' => '#'),
        );
        $this->assign('breadCrumbList', $breadCrumbList); //面包屑 
        //SEO
        $this->assign('seo', seo(NULL, $topicInfo['category_name']));
        //下载排行
        $this->_showSortDownloadList();
        //文章列表
        $this->_showContentList();
        $this->display();
    }

    /**
     * 显示文章列表
     */
    private function _showContentList($listRow = 5) {
        //公告列表
        $noticeList = BService('MarketView', 'Index')->getContentList('Notice', 1, $listRow);
        $this->assign('noticeList', $noticeList['contentList']);
        //评测列表
        $reviewList = BService('MarketView', 'Index')->getContentList('Review', 1, $listRow);
        $this->assign('reviewList', $reviewList['contentList']);
    }

    /**
     * 显示分类下载排行列表
     */
    private function _showSortDownloadList() {
        $this->_showDownloadTopList(null, null, false);
    }

    /**
     * 显示下载排行列表
     * @param type $categoryId
     * @param type $modelName
     */
    private function _showDownloadTopList($categoryId = null, $modelName = null, $isTotalRank = true) {
        if ($isTotalRank) {//指定模型
            $downloadTopData = BService('MarketView', 'Index')->getDownloadTopApplicationList($categoryId, $modelName, 1, 10, MarketViewService::FOTMAT_TYPE_ENUM_SIMPLE);
            $downloadList = $downloadTopData['applicationList'];
            $this->assign('downloadList', $downloadList); //注册下载排行
        } else {//注册所有下载排行
            //游戏下载排行榜列表
            $topGameData = BService('MarketView', 'Index')->getDownloadTopApplicationList(null, C('APPLICATION_MODEL_NAME.GAME'));
            $this->assign('downloadTopGameList', $topGameData['applicationList']);
            //应用下载排行榜列表
            $topAppData = BService('MarketView', 'Index')->getDownloadTopApplicationList(null, C('APPLICATION_MODEL_NAME.APP'));
            $this->assign('downloadTopAppList', $topAppData['applicationList']);
        }
    }

    /**
     * 显示上一篇，下一篇
     * @param type $modelId
     * @param type $categoryId
     * @param type $updateTime
     */
    private function _showPreviousNextLink($modelId, $categoryId, $updateTime) {
        $modelId = intval($modelId);
        $categoryId = intval($categoryId);
        $updateTime = strtotime($updateTime);

        // 找出上一篇
        $map = array(
            'status' => C('CONTENT_CHECK_STATUS.PASS'),
            'update_time' => array('LT', $updateTime),
            'model_id' => $modelId,
            'category_id' => $categoryId,
        );

        $previousPageData = M('Content')->where($map)->order('update_time DESC')->find();
        if ($previousPageData) {
            $previousPageData['url'] = BService('Url')->getContentUrl($previousPageData['category_id'], $previousPageData['id']);
        }

        // 找出下一篇
        $map['update_time'] = array('GT', $updateTime);
        $nextPageData = M('Content')->where($map)->order('update_time ASC')->find();
        if ($nextPageData) {
            $nextPageData['url'] = BService('Url')->getContentUrl($nextPageData['category_id'], $nextPageData['id']);
        }

        $this->assign('previous_page_data', $previousPageData);
        $this->assign('next_page_data', $nextPageData);
    }

}

?>
