<?php

import('Service.IViewService', LIB_PATH);

/**
 * 前台输出viewService
 * @author     bant
 * @copyright  (C) 2011-2014 EXCMS
 * @license    http://www.zyxfeng.com/license/
 * @version    1.0
 * @createTime 2014-5-6
 * @updateTime 2014-5-6
 */
class ViewService extends BaseService implements IViewService {

    const CACHE_NAME_GET_CATEGORY_LIST = 'CategoryList'; //缓存名称-getCategory用

    public function __construct() {
        parent::__construct();
    }

    /**
     * 显示分页
     * @param type $pageClass
     * @return boolean
     */
    public function showPage($pageClass) {
        if (!$pageClass) {
            return false;
        }
        return $pageClass->showByBootStrap('%first% %upPage% %linkPage% %downPage% %end%');
    }

    /**
     * 获取栏目列表
     * @param type $cacheTime
     * @return type
     */
    public function getCategoryList($limitCount = 10, $cacheTime = 86400) {
        $cacheName = self::CACHE_NAME_GET_CATEGORY_LIST . 'L' . $limitCount;
        if ($cacheTime && $return = S($cacheName)) {
            return $return;
        }
        $categoryData = $this->_getCategoryList(self::CACHE_NAME_GET_CATEGORY_LIST, null, null, null, $limitCount, self::FORMAT_TYPE_ENUM_SIMPLE, $cacheTime);
        if ($cacheTime) {
            S($cacheName, $categoryData, $cacheTime);
        }
        return $categoryData;
    }

    /**
     * 获取内容页面侧边栏数据
     * @param type $contentData     BService('Content')->getContentById()获取的内容数据
     * @return type
     */
    public function getContentSlider($contentData) {
        //栏目内内容排行
        $hitContentData = $this->getHitContentList($contentData['category_id']);
        return array(
            'hitContentList' => $hitContentData['contentList']//栏目内内容排行
        );
    }

    /**
     * 获取栏目页面侧边栏数据
     * @param type $categoryId           栏目id
     * @param type $modelId              模型id
     * @return type
     */
    public function getCategorySlider($categoryId = null, $modelId = null, $limitCount = 10, $cacheTime = 3600) {
        //栏目内内容排行
        $hitContentData = $this->getHitContentList($categoryId, $modelId, $limitCount, $cacheTime);
        return array(
            'hitContentList' => $hitContentData['contentList']//栏目内内容排行
        );
    }

    /**
     * 获取首页需要用的数据
     * @return type
     */
    public function getIndexData($cacheTime = 3600) {
        $returnData = array();
        $config = BaseAction::getVar('config');
        //配置
        $returnData['config'] = $config;
        //栏目列表
        $categoryData = BService('View', 'Index')->getCategoryList(10, 86400);
        $categoryList = setArrayIndexByKey($categoryData['categoryList'], 'category_id'); //提取栏目id为key的数组
        $returnData['categoryList'] = $categoryList;
        //seo
        $seo = seo('', $config['site_name'], $config['site_summary'], $config['site_keyword']);
        $returnData['seo'] = $seo;

        //要闻列表
        $returnData['headlineList'] = BService('View', 'Index')->getHeadlineList(5, $cacheTime);
        //国内要闻列表
        $returnData['domesticHeadlineList'] = BService('View', 'Index')->getDomesticHeadlineList(5, $cacheTime);
        //国际要闻列表
        $returnData['worldHeadlineList'] = BService('View', 'Index')->getWorldHeadlineList(5, $cacheTime);
        //幻灯片
        $returnData['topSlider'] = BService('View', 'Index')->getTopSlider(5, $cacheTime);
//        //专题列表
//        $topicData = BService('View', 'Index')->getTopicCategoryList(5, $cacheTime);
//        $returnData['topicList'] = $topicData['categoryList'];
        //新闻排行
        $hitContentData = BService('View', 'Index')->getHitContentList(null, null, 4, $cacheTime);
        $returnData['hitContentList'] = $hitContentData['contentList'];
        //模块列表
        $returnData['modList'] = BService('View', 'Index')->getModList(10, 10, $cacheTime);
        return $returnData;
    }

    /**
     * 获取模块列表
     * @param type $limitModCount       获取模块数
     * @param type $limitCountPerMod    每模块数据条数        
     * @param type $cacheTime           缓存时间
     * @return type
     */
    public function getModList($limitModCount = 6, $limitCountPerMod = 5, $cacheTime = 3600) {
        $cacheName = 'ViewModList' . 'L' . $limitModCount . 'LCPM' . $limitCountPerMod;

        if ($cacheTime && $return = S($cacheName)) {
            return $return;
        }

        $modList = array();
        //获取已经缓存的栏目列表缓存
        $categoryCacheData = $this->getCategoryList();
        $categoryCacheList = $categoryCacheData['categoryList'];
        $modIndex = 0;
        foreach ($categoryCacheList as $_category) {
            $categoryId = $_category['category_id'];
            //超过跳出
            if ($modIndex >= $limitModCount) {
                break;
            }
//            //跳过一级栏目
//            if (empty($_category['pid_array'])) {
//                unset($categoryCacheList[$categoryId]);
//                continue;
//            }
            $result = BService('Content')->getContentList($categoryId, null, 1, $limitCountPerMod, '', ContentService::FORMAT_TYPE_ENUM_NORMAL, $cacheTime);
            $contentList = $result['contentList'];
            foreach ($contentList as $contentId => $_content) {
                $contentList[$contentId] = $this->_formatSimpleContent($_content);
            }
            $modList[] = array(
                'category_name' => $_category['category_name'],
                'content_list' => $contentList,
                'url' => $_category['url']
            );
            $modIndex++;
        }

        if ($cacheTime) {
            S($cacheName, $modList, $cacheTime);
        }
        return $modList;
    }

    /**
     * 获取头条列表
     * @return type
     */
    public function getHeadlineList($limitCount = 10, $cacheTime = 3600) {
        return $this->_getHeadlineList(C('POSITION_FLAG.HEADLINE'), $limitCount, $cacheTime);
    }

    /**
     * 获取国内头条列表
     * @return type
     */
    public function getDomesticHeadlineList($limitCount = 10, $cacheTime = 3600) {
        return $this->_getHeadlineList(C('POSITION_FLAG.HEADLINE_DOMESTIC'), $limitCount, $cacheTime);
    }

    /**
     * 获取国际头条列表
     * @return type
     */
    public function getWorldHeadlineList($limitCount = 10, $cacheTime = 3600) {
        return $this->_getHeadlineList(C('POSITION_FLAG.HEADLINE_WORLD'), $limitCount, $cacheTime);
    }

    /**
     * 获取头部幻灯片数据列表
     * @param type $limitCount
     * @param type $cacheTime
     * @return type
     */
    public function getTopSlider($limitCount = 5, $cacheTime = 86400) {
        return BService('Content')->getContentListByPositionId(null, C('POSITION_FLAG.INDEX_TOP_SLIDER'), $limitCount, self::FORMAT_TYPE_ENUM_NORMAL, $cacheTime);
    }

    /**
     * 获取专题栏目列表
     * @param type $cacheTime
     * @return type
     */
    public function getTopicCategoryList($limitCount = 5, $cacheTime = 86400) {
        return $this->_getCategoryList('Topic', null, null, C('CATEGORY_TYPE.TOPIC'), $limitCount, self::FORMAT_TYPE_ENUM_NORMAL, $cacheTime);
    }

    /**
     * 获取点击最多内容列表
     * @param type $categoryId      指定栏目id
     * @param type $modelId         指定模型id
     * @param type $limitCount      限制返回数量
     * @param type $cacheTime       缓存时间
     * @return type
     */
    public function getHitContentList($categoryId = null, $modelId = null, $limitCount = 10, $cacheTime = 3600) {
        return BService('Content')->getHitContentList($categoryId, $modelId, $limitCount, C('HIT_FLAG.HIT'), C('HIT_ORDER_TYPE.WEEK'), $cacheTime);
    }

    /**
     * 获取栏目列表基方法
     * @param type $cacheName
     * @param type $modelTableName
     * @param type $modelType
     * @param type $categoryType
     * @param type $cacheTime
     * @return boolean
     */
    private function _getCategoryList($cacheName, $modelTableName = NULL, $modelType = NULL, $categoryType = NULL, $limitCount = 10, $formatType = self::FORMAT_TYPE_ENUM_DETAIL, $cacheTime = 86400) {
        if ($modelType && empty($modelTableName)) {
            $this->setError('参数缺失');
            return false;
        }

        $modelId = null;
        $cacheName = 'View' . $cacheName . ucwords($modelTableName) . 'CategoryList' . 'T' . $categoryType . 'L' . $limitCount . 'F' . $formatType;
        if ($cacheTime && $return = S($cacheName)) {
            return $return;
        }
        //指定模型
        if (isset($modelType)) {
            $modelId = D('Model')->getModelIdByModelName($modelTableName, $modelType);
        }
        $extendWhere = array(
            'is_navigate' => array('eq', 1),
        );
        $categoryData = BService('Category')->getCategoryList($modelId, $categoryType, 1, $limitCount, $formatType, $extendWhere);
        if ($cacheTime) {
            S($cacheName, $categoryData, $cacheTime);
        }
        return $categoryData;
    }

    /**
     * 获取各种头条列表
     * @param type $flag
     * @param type $limitCount
     * @param type $cacheTime
     * @return boolean
     */
    private function _getHeadlineList($flag, $limitCount = 10, $cacheTime) {
        if (empty($flag)) {
            $this->setError('参数缺失');
            return false;
        }
        return BService('Content')->getContentListByPositionId(null, $flag, $limitCount, self::FORMAT_TYPE_ENUM_SIMPLE, $cacheTime);
    }

    /**
     * 通用数据处理
     * @param type $data     数据处理
     * @return type
     */
    private function _handleData($data) {
        if ($data['pid']) {
            $relationModel = new AutoRelationModel('Content');
            return $relationModel->relation(TRUE)->find($data['pid']);
        } else {
            return $data;
        }
    }

    /**
     * 格式化输出简要程序信息
     * @param type $originData
     * @return type 
     */
    private function _formatSimpleContent($originData, $isWithThumb = false) {
        $originData = $this->_handleData($originData);
        $id = $originData['id'];
        $data = array(
            'id' => $id,
            'title' => $originData['title'],
            'url' => $originData['url'] ? $originData['url'] : BService('Url')->getContentUrl($originData['category_id'], $id),
            'hit_count' => intval($originData['hit_count']),
        );
        if ($isWithThumb && $originData['thumb']) {
            $data['thumb'] = getAttachmentSiteUrl($originData['thumb']);
        }
        return $data;
    }

    /**
     * 格式化输出一般程序信息
     * @param type $originData
     * @return type 
     */
    private function _formatNormalContent($originData) {
        $originData = $this->_handleData($originData);
        $id = $originData['id'];
        $data = array(
            'id' => $id,
            'title' => $originData['title'],
            'url' => BService('Url')->getContentUrl($originData['category_id'], $id),
            'hit_count' => intval($originData['hit_count']),
            'thumb' => getAttachmentSiteUrl($originData['thumb']),
            'description' => $originData['description'],
            'update_time' => $originData['update_time'],
        );
        return $data;
    }

}

?>
