<?php

/**
 * 友情链接模块
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-26
 * @updateTime 2013-4-26
 */
class LinkAction extends AdminBaseAction {

    protected $linkModel, $termService;

    const MODULE_VAR_NAME = 'Link'; //模块安装名称

    public function _initialize() {
        parent::_initialize();
        $this->linkModel = D('Link/Link');
        $this->termService = BService('Term');
        $this->termList = $this->termService->getTermList(self::MODULE_VAR_NAME);
        $this->assign('termList', $this->termList);
    }

    /**
     * 显示友情链接
     */
    public function index() {
        $linkData = BService('Link', 'Link')->getLinkList(NULL, NULL, NULL, NULL, 0);
        $page = $linkData['page'];
        $this->assign('linkList', $linkData['linkList']);
        $this->assign('page', $page->show());
        $this->display();
    }

    /**
     * 添加链接
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();
            $termName = $post['term_name'];
            $post['url'] = $this->_post('url', 'bpiHtmlspecialcharsDecode');
            //如果新建分类名不为空，则新建分类
            if (!empty($termName)) {
                $termId = $this->termService->addTerm($termName, self::MODULE_VAR_NAME);
                if ($termId) {
                    $post['term_id'] = $termId;
                } else {
                    $this->bpiAjaxReturn(false, $this->termService->getError());
                }
            }
            $post['update_time'] = time();
            //判断打开方式，1、默认窗口，2、新建窗口
            if (intval($post['target']) === 1) {
                $post['target'] = '_self';
            } else {
                $post['target'] = '_blank';
            }

            //处理logo
            if (($attachmentId = intval($post['attachment_id']))) {
                //检测附件是否存在
                if (($attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId))) {
                    $post['image'] = $attachmentInfo['file_path'];
                } else {
                    $this->bpiAjaxReturn(false, '友情链接LOGO文件出错', array(), C('OPERATE_TYPE.OPERATE_ADD'));
                }
            }

            if ($this->linkModel->create($post)) {
                if (($linkId = $this->linkModel->add())) {
                    if ($attachmentId) {
                        BService('Attachment')->apiUpdate(NULL, $linkId, $attachmentId);
                    }
                    $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Link/Link/index') . '"'));
                } else {
                    $this->bpiAjaxReturn(false, '添加失败');
                }
            } else {
                $this->bpiAjaxReturn(false, $this->linkModel->getError());
            }
        } else {
            $this->display('edit');
        }
    }

    /**
     * 编辑链接
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();
            //获取新建分类名
            $termName = $post['term_name'];
            $post['url'] = $this->_post('url', 'bpiHtmlspecialcharsDecode');
            //如果新建分类不为空，则新建分类
            if (!empty($termName)) {
                $post['term_id'] = $this->termService->addTerm($termName, self::MODULE_VAR_NAME);
                if (!$post['term_id']) {
                    $this->bpiAjaxReturn(false, $this->termService->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            }

            //处理logo
            if (($attachmentId = intval($post['attachment_id']))) {
                //检测附件是否存在
                if (($attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId))) {
                    $post['image'] = $attachmentInfo['file_path'];
                } else {
                    $this->bpiAjaxReturn(false, '友情链接LOGO文件出错', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            }

            if ($this->linkModel->create($post)) {
                if ($this->linkModel->save() !== FALSE) {
                    if ($attachmentId) {
                        BService('Attachment')->apiUpdate(NULL, intval($post['link_id']), $attachmentId);
                    }
                    $this->bpiAjaxReturn(true, '修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '修改失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $this->linkModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $linkId = intval($this->_get('link_id'));
            $linkList = $this->linkModel->where(array('link_id' => $linkId))->find();
            if (!is_array($linkList)) {
                $this->error('该信息不存在');
            }
            $this->assign('linkList', $linkList);
            $this->display();
        }
    }

    /**
     * 删除链接
     */
    public function delete() {
        $param = $this->_param('link_id');
        $linkIds = is_array($param) ? $param : array($param);

        if (empty($linkIds)) {
            $this->bpiAjaxReturn(false, '请选择删除条目', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
        foreach ($linkIds as $linkId) {
            $linkId = intval($linkId);
            if ($linkId > 0) {
                if ($this->linkModel->delete($linkId)) {
                    BService('Attachment')->apiDelete(NULL, $linkId);
                }
            }
        }
        $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
    }

    /**
     * 显示分类列表
     */
    public function termList() {
        $this->display('Admin@Term:termList');
    }

    /**
     * 删除分类
     */
    public function termDelete() {
        parent::deleteTerm(self::MODULE_VAR_NAME);
    }

    /**
     * 编辑分类
     */
    public function termEdit() {
        parent::editTerm(self::MODULE_VAR_NAME);
    }

}

?>
