<?php

/**
 * 友情链接Service
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-11-29
 * @updateTime 2013-11-29
 */
class LinkService extends BaseService {

    protected $linkModel;

    public function __construct() {
        parent::__construct();
        $this->linkModel = D('Link/Link');
    }

    /**
     * 获取友链列表
     * @param type $termId
     * @param type $pageIndex
     * @param type $listRow
     * @param type $order
     * @param type $cacheTime
     * @return type
     */
    public function getLinkList($termId = NULL, $pageIndex = 1, $listRow = 10, $order = 'link_id DESC', $cacheTime = 86400) {
        $termId = $termId ? intval($termId) : NULL;
        $linkList = array();
        $cacheName = 'LinkList' . 'TermId' . $termId . 'P' . $pageIndex . 'L' . $listRow . 'O' . $order;
        if ($cacheTime && $linkCache = S($cacheName)) {
            return $linkCache;
        }

        $map = array();
        if ($termId) {
            $map['term_id'] = $termId;
        }
        $count = $this->linkModel->where($map)->count();
        $page = page($count, $listRow, $pageIndex);
        if ($count) {
            $linkList = $this->linkModel->where($map)->limit($page->firstRow . ',' . $page->listRows)->order($order)->select();
        }

        $cacheData = array(
            'linkList' => $linkList,
            'page' => $page,
        );
        if ($cacheTime) {
            S($cacheName, $cacheData, $cacheTime);
        }
        return $cacheData;
    }

}

?>
