<?php

/**
 * 应用管理Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
class ApplicationAction extends AdminBaseAction {

    protected $categoryCache, $modelCache, $applicationService, $isSystemAdmin;
    protected $modelId, $categoryId;
    protected $searchType;

    const NOT_AUTH_ACTION_INDEX = 'index'; //本action无需验证函数名
    const NOT_AUTH_ACTION_APPLICATION_LIST = 'applicationList'; //本action无需验证函数名
    const CACHE_CLASS_LIST_PREFIX = 'CacheClassList'; //栏目菜单列表缓存名前缀
    //搜索类型
    const SERACH_TYPE_TITLE = 1;        // 文章标题
    const SERACH_TYPE_DESCRIPTION = 2;  // 文章简介
    const SERACH_TYPE_USERNAME = 3;     // 发布人名称
    const SERACH_TYPE_ID = 4;           // 文章ID

    function _initialize() {
        parent::_initialize();
        $this->categoryCache = FData('Category');
        $this->modelCache = D('Model')->getModelByType(NULL, 1);
        $this->applicationService = BService('Application', 'Market');
        $this->isSystemAdmin = BaseAction::getVar('user_id') === BaseAction::getVar('super_role_id'); //是否超级管理员

        $get = $this->_get();
        $this->categoryId = intval($get['category_id']);
        $this->modelId = intval($get['model_id']);
        //后面关联用，如编辑器
        C('CURRENT_ACCESS_TYPE', C('ACCESS_TYPE.APPLICATION'));

        // 如果存在栏目ID，则进行检查
        if ($this->categoryId) {
            $category = $this->categoryCache[$this->categoryId];
            if (empty($category)) {
                $this->error('栏目不存在');
            }

            if ($this->modelId && !(array_key_exists($this->modelId, $category['model']) && array_key_exists($this->modelId, $this->modelCache))) {
                $this->error('模型ID非法');
            }
        } else {
            $this->categoryId = 0;
            $this->modelId = 0;
            $this->id = 0;
        }


        //验证权限
        if (!$this->isSystemAdmin) {
            // 通过部分无需验证action,如public_开头和index方法
            if (strpos(ACTION_NAME, C('NOT_AUTH_ACTION_PREFIX_AFTER_LOGIN')) !== 0 && !in_array(ACTION_NAME, array(self::NOT_AUTH_ACTION_INDEX, self::NOT_AUTH_ACTION_APPLICATION_LIST))) {
                //对非一般栏目只要有index权限即有全权限
                $action = intval($category['type']) === C('CATEGORY_TYPE.NORMAL') ? ACTION_NAME : self::NOT_AUTH_ACTION_INDEX;
                $map = array(
                    'category_id' => $this->categoryId,
                    'is_admin' => 1,
                    'role_id' => BaseAction::getVar('user/role_id'),
                    'action' => $action,
                );
                //权限列表
                $purviewList = M('CategoryPurview')->where($map)->select();
                if (!$purviewList) {
                    $this->error('权限不足');
                }
            }
        }

        //搜索类型
        $this->searchType = array(
            self::SERACH_TYPE_TITLE => '标题',
            self::SERACH_TYPE_USERNAME => '发布人名称',
            self::SERACH_TYPE_ID => 'ID',
        );
    }

    /**
     * 显示首页
     * ps:此action不能随意改名，如需要改名，请一同更改NOT_AUTH_ACTION_INDEX
     */
    public function index() {
        if ($this->categoryId) {
            $this->assign('applicationListUrl', U('Market/Application/applicationList', array('category_id' => $this->categoryId)));
        }
        $this->display();
    }

    /**
     * 添加信息
     * ps:此action不能随意改名，如需要改名，请一同更改C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.ADD')
     */
    public function add() {
        if (!($this->categoryId && $this->modelId)) {
            $this->error('栏目ID或模型ID不能为空');
        }

        $category = $this->categoryCache[$this->categoryId];
        if (IS_POST) {
            // 判断栏目是否一般栏目
            if (C('CATEGORY_TYPE.NORMAL') !== intval($category['type'])) {
                $this->bpiAjaxReturn(false, '该栏目下无法添加信息');
            }

            // 获取数据
            $post = $this->_post();
            $post['category_id'] = $this->categoryId;
            $post['model_id'] = $this->modelId;

            // 调用Service添加内容
            if ($this->applicationService->add($post)) {
                $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Market/Application/index', array('category_id' => $this->categoryId)) . '"'));
            } else {
                $this->bpiAjaxReturn(false, $this->applicationService->getError());
            }
        } else {
            $this->_showApplicationForm();
        }
    }

    /**
     * 编辑文章
     * ps:此action不能随意改名，如需要改名，请一同更改C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.EDIT')
     */
    public function edit() {
        $id = intval($this->_get('id'));
        if (!($id && $this->categoryId && $this->modelId)) {
            $this->error('文章ID、栏目ID或模型ID不能为空');
        }

//        $category = $this->categoryCache[$this->categoryId];
//        // 获取当前模型
//        $contentRelationModel = new AutoRelationModel('Content');
//
//        //内容信息
//        $data = $contentRelationModel->relation(true)->where(array('id' => $id, 'category_id' => $this->categoryId, 'model_id' => $this->modelId))->find();
//        if (empty($data)) {
//            $this->error('信息不存在');
//        }
        if (IS_POST) {
            // 获取数据
            $post = $this->_post();
            $post['category_id'] = $this->categoryId;
            $post['model_id'] = $this->modelId;
            $post['id'] = $id;

            // 删除旧文章
//            if ($category['setting']['content_is_set_html']) {
//                BService('Html')->deleteHtml($data['category_id'], $data['id'], $data['post_time'], $data['alias']);
//            }

            if ($this->applicationService->edit($post)) {
                $this->success('修改成功');
            } else {
                $this->error($this->applicationService->getError());
            }
        } else {
            $this->_showApplicationForm($this->applicationService->getApplicationById($id, $this->categoryId, $this->modelId));
        }
    }

    /**
     * 获取栏目菜单列表
     */
    public function public_categoryList() {
        $categoryTree = BService('Category')->getPostCategoryTreeList(C('MODEL_TYPE.APPLICATION'), C('CATEGORY_TYPE.NORMAL'), U('Market/Application/applicationList'));
        $this->assign('categoryList', $categoryTree);
        $this->display();
    }

    /**
     * 获取内容列表
     */
    public function applicationList() {
        $category = $this->categoryCache[$this->categoryId];
        // 判断栏目是否存在
        if (empty($category)) {
            $this->error('栏目不存在');
        }

        // 查询当前分类
        $map = array('category_id' => $this->categoryId);

        // 判断是否搜索
        if ($this->_get('search')) {
            // 状态
            $status = $this->_get('status');
            $status !== null && $map['status'] = intval($status);
            // 开始时间和结束时间
            $startTime = strtotime($this->_get('start_time', '', 0));
            $endTime = strtotime($this->_get('end_time', '', time()));
            if ($endTime > $startTime) {
                $map['create_time'] = array(array('EGT', $startTime), array('ELT', $endTime));
                $this->assign('startTime', date('Y-m-d', $startTime));
                $this->assign('endTime', date('Y-m-d', $endTime));
            }
            // 搜索类型
            $keyword = $this->_get('keyword');
            if (!empty($keyword)) {
                $type = $this->_get('search_type');
                switch ($type) {
                    case self::SERACH_TYPE_ID:
                        $map['id'] = intval($keyword);
                        break;
                    case self::SERACH_TYPE_TITLE:
                        $map['title'] = array('LIKE', '%' . $keyword . '%');
                        break;
                    case self::SERACH_TYPE_USERNAME:
                        $memberIds = M('Member')->where(array('user_name' => array('like', '%' . $keyword . '%')))->order('last_login_date DESC')->limit(50)->getField('user_id', true);
                        $adminIds = M('Admin')->where(array('user_name' => array('like', '%' . $keyword . '%')))->getField('user_id', true);

                        if ($memberIds && $adminIds) {
                            //两者同时拥有
                            $map['_string'] = '(is_admin_add = 0 AND user_id IN (' . implode(',', $memberIds) . ')) OR (is_admin_add = 1 AND user_id IN (' . implode(',', $adminIds) . '))';
                        } else if ($memberIds) {
                            //只搜索到用户组
                            $map['is_admin_add'] = 0;
                            $map['user_id'] = array('in', $memberIds);
                        } else if ($adminIds) {
                            //只搜索到管理员
                            $map['is_admin_add'] = 1;
                            $map['user_id'] = array('in', $adminIds);
                        } else {
                            //找不到结果
                            unset($map);
                            $map['id'] = 0;
                        }
                        break;
                    default:
                        $type = self::SERACH_TYPE_TITLE;
                        $map['title'] = array('LIKE', '%' . $keyword . '%');
                        break;
                }
                $this->assign('type', $type);
                $this->assign('keyword', $keyword);
            }
        }

        $applicationModel = M('Application');
        $count = $applicationModel->where($map)->count();
        $page = page($count);
        $applicationList = $applicationModel->where($map)->limit($page->firstRow, $page->listRows)->order(array('id' => 'DESC'))->select();

        foreach ($applicationList as &$application) {
            if ($application['pid']) {
                $application['_parent_'] = $applicationModel->find($application['pid']);
            }

            $id = intval($application['_parent_'] ? $application['_parent_']['id'] : $application['id']);
            $modelId = intval($application['_parent_'] ? $application['_parent_']['model_id'] : $application['model_id']);
            $categoryId = intval($application['_parent_'] ? $application['_parent_']['category_id'] : $application['category_id']);

            //下载量
            $applicationType = D('Market/Application')->getApplicationTypeByModelId($application['model_id']);
            $hitInfo = BService('Hit')->getHit(C('ACCESS_TYPE.APPLICATION'), $id, $applicationType, C('HIT_FLAG.DOWNLOAD'));
            $application['hit_count'] = intval($hitInfo[$id]['total_count']);
            $application['user_name'] = getUserNameById($application['user_id'], $application['is_admin_add']);
            //url
            if (empty($application['url'])) {
                $application['url'] = BService('Url')->getContentUrl($categoryId, $application['id']);
            }
        }

        // 显示可添加的模型
        $modelList = array();
        foreach ($this->modelCache as $modelId => $model) {
            if (array_key_exists($modelId, $category['model'])) {
                $modelList[$modelId] = $model['name'];
            }
        }

        $this->assign('searchType', $this->searchType);
        $this->assign('category', $category);
        $this->assign('modelList', $modelList);
        $this->assign('applicationList', $applicationList);
        $this->assign('page', $page->show());
        $this->display();
    }

    /**
     * 栏目下的文章排序处理
     * ps:此action不能随意改名，如需要改名，请一同更改C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.SORT')
     */
    public function sort() {
        parent::saveSort(M('Application'), $this->_post('sort'), 'sort', true);
    }

    /**
     * 更改文章状态
     */
    public function status() {
        $status = $this->applicationService->changeStatus($this->_post('id'), intval($this->_get('status')));
        if (FALSE !== $status) {
            $json = array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH'));
            $info = '操作成功';
        } else {
            $json = array();
            $info = '操作失败';
        }
        $this->bpiAjaxReturn($status, $info, $json, C('OPERATE_TYPE.OPERATE_UPDATE'));
    }

    /**
     * 栏目下的文章排序处理
     * ps:此action不能随意改名，如需要改名，请一同更改C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.PUSH')
     */
    public function push() {
        if (IS_POST) {
            $post = $this->_post();
            $action = trim($post['action']);

            $explodeIdList = explode(',', $post['id']);
            if (empty($explodeIdList) || empty($action)) {
                $this->error('参数不正确');
            }

            $applicationRelationModel = new AutoRelationModel('Application');
            // 过滤ID选项，映射计算
            $applicationList = $applicationRelationModel->field('id,pid')->where(array('id' => array('IN', $explodeIdList)))->select();
            $idList = array();
            foreach ($applicationList as $applicationInfo) {
                $idList[] = intval($applicationInfo[intval($applicationInfo['pid']) ? 'pid' : 'id']);
            }

            if ('pushToPosition' === $action) {
                // 推荐位处理
                $pushToPositionIdList = $post['position'];
                if (is_array($pushToPositionIdList) && $pushToPositionIdList) {
                    $positionService = BService('Position');

                    // 拉取应用信息
                    $applicationList = $applicationRelationModel->relation(TRUE)->where(array('id' => array('IN', $idList)))->select();
                    foreach ($applicationList as $applicationInfo) {
                        // 过滤应用信息
                        foreach (F('ModelField' . $applicationInfo['model_id']) as $field => $fieldInfo) {
                            if (!$fieldInfo['is_position']) {
                                unset($applicationInfo[$field]);
                            }
                        }

                        // 推送到推荐位
                        $positionService->updateData($applicationInfo['model_id'], $applicationInfo['category_id'], $applicationInfo['id'], $pushToPositionIdList, $applicationInfo);
                    }
                    $this->success("推送到推荐位成功！");
                } else {
                    $this->error("请选择推荐位！");
                }
            } else if ('pushToCategory' === $action) {
                // 栏目处理
                $pushToCategoryIdList = $post['category'];
                if (is_array($pushToCategoryIdList) && $pushToCategoryIdList) {
                    // 拉取应用信息
                    $applicationList = $applicationRelationModel->where(array('id' => array('IN', $idList)))->select();

                    // 推送数据
                    $status = FALSE;
                    $applicationService = BService('Application');
                    foreach ($pushToCategoryIdList as $categoryId) {
                        foreach ($applicationList as $applicationInfo) {
                            $status |= $applicationService->push($applicationInfo['model_id'], $categoryId, $applicationInfo);
                        }
                    }
                    if ($status) {
                        $this->success("推送其他栏目成功！");
                    } else {
                        $message = $applicationService->getError();
                        $this->error($message ? $message : '推送失败');
                    }
                } else {
                    $this->error("请选择需要推送的栏目！");
                }
            }
        } else {
            $get = $this->_get();
            $id = $get['id'];
            $categoryId = $get['category_id'];

            if (!$id || !$categoryId) {
                $this->error('参数不正确！');
            }

            $categoryCache = $this->categoryCache;
            $modelCache = $this->modelCache;
            if (!isset($categoryCache[$categoryId])) {
                $this->error('栏目不存在');
            }
            $categoryInfo = $categoryCache[$categoryId];
            $categoryModelList = $categoryInfo['model'];
            $action = ($get['action'] == 'pushToCategory') ? 'pushToCategory' : 'pushToPosition';

            switch ($action) {
                case "pushToPosition":
                    $position = F("Position");
                    $array = array();
                    if (!empty($position)) {
                        foreach ($position as $_key => $_value) {
                            //当前栏目指定模型不存在于推荐位指定栏目中
                            if ($_value['model_id'] && !isset($categoryModelList[$_value['model_id']])) {
                                continue;
                            }
                            //当前栏目不存在与推荐位指定栏目中
                            if ($_value['category_id'] && ($_value['category_id'] != $categoryId && !in_array($_value['category_id'], $categoryCache['child_id_array']))) {
                                continue;
                            }
                            $array[$_key] = $_value['name'];
                        }
                    }
                    $this->assign("position", $array);
                    break;
                //同步发布到其他栏目
                case "pushToCategory":
                    $categoryList = array();
                    foreach ($categoryCache as $value) {
                        //跳过外链栏目、跳过自身栏目、无绑定模型栏目
                        if (intval($value['type']) == C('CATEGORY_TYPE.CHAIN') || $value['category_id'] == $categoryId || empty($value['model'])) {
                            continue;
                        }
                        //跳过模型不允许的栏目
                        $allowModel = array_intersect_key($categoryModelList, $value['model']);
                        if (empty($allowModel)) {
                            continue;
                        }

                        //所属模型
                        $value['modelName'] = '';
                        foreach ($value['model'] as $modelId => $model) {
                            if (isset($modelCache[$modelId])) {
                                if (empty($value['modelName'])) {
                                    $value['modelName'] .= $modelCache[$modelId]['name'];
                                } else {
                                    $value['modelName'] .= '、' . $modelCache[$modelId]['name'];
                                }
                            }
                        }
                        $value['disabled'] = empty($value['child_id_array']) ? '' : 'disabled="disabled"';
                        $categoryList[$value['category_id']] = $value;
                    }

                    $str = "<tr>
                                <td class='center'><input type='checkbox' name='category[]' value='\$category_id' class='child' \$disabled/></td>
                                <td>\$category_id</td>
                                <td align='left'>\$spacer\$category_name</td>
                                <td><a href='javascript:;' class='longtext' title='\$modelName'>\$modelName</a></td>
                            </tr>";
                    $categoryTree = getTree($categoryList, $str);
                    $this->assign('list', $categoryTree);
                    break;
                default:
                    $this->error('操作错误');
                    break;
            }

            $this->assign("id", $id);
            $this->assign("action", $action);
            $this->assign("categoryId", $categoryId);
            $this->display($action);
        }
    }

    /**
     * 删除文章
     * ps:此action不能随意改名，如需要改名，请一同更改C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.DELETE')
     */
    public function delete() {
        // TODO : 批量删除文章时的权限判断
        $id = $this->_param('id');
        if ($this->applicationService->delete($id)) {
            $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->bpiAjaxReturn(false, $this->applicationService->getError(), array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 检测文章标题
     */
    public function public_checkTitle() {
        $map = array();
        $map['title'] = trim($this->_get('title'));
        $map['category_id'] = intval($this->_get('category_id'));

        if (M('Application')->where($map)->find()) {
            $this->ajaxReturn(array('status' => 1));
        } else {
            $this->ajaxReturn(array('status' => 0));
        }
    }

    /**
     * 图片裁剪
     */
    public function public_imageCrop() {
        $status = false;    //信息是否有效
        $get = $this->_get();
        $post = $this->_post();
        $attachmentId = $this->_param('id', 'intval');
        if (!$attachmentId) {
            $this->error('参数错误');
        }

        $attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId);
        if ($attachmentInfo && $attachmentInfo['is_image']) {
            $status = true;
        }
        if (IS_POST) {
            $data = array('status' => 0);
            if ($status) {
                if (($result = BService('Attachment')->imageCrop($attachmentInfo, $post))) {
                    $result && $data = array('status' => 1, 'data' => array($result));
                } else {
                    $data['data'] = BService('Attachment')->getError();
                }
            } else {
                $data['data'] = '获取附件信息失败或附件不是图片';
            }
            $this->ajaxReturn($data);
        } else {
            if ($status) {
                $this->assign('category_id', intval($get['category_id']));
                $this->assign('attachmentInfo', $attachmentInfo);
                $this->display('imageCrop');
            } else {
                $this->error('图片不存在');
            }
        }
    }

    /**
     * 加载相关文章列表
     */
    public function public_getRelationList() {
        $get = $this->_get();
        $ajax = array('status' => 0);
        if (!$get['id'] || !$get['field_name']) {
            $ajax['info'] = '文章ID或字段名不能为空';
            $this->ajaxReturn($ajax);
        }

        $applicationModel = M('Application');

        //内容信息
        $data = $applicationModel->where(array('id' => intval($get['id'])))->find();
        if (!$data) {
            $this->ajaxReturn($ajax);
        }

        if (!isset($data[$get['field_name']])) {
            $this->ajaxReturn($ajax);
        }

        $relationIds = explode('|', $data[$get['field_name']]);
        $relationList = array();
        foreach ($relationIds as $relationId) {
            $relationInfo = $applicationModel->field('id, title, url')->where(array('id' => intval($relationId), 'status' => C('CONTENT_CHECK_STATUS.PASS')))->find();
            if ($relationInfo) {
                $relationList[] = $relationInfo;
            }
        }
        $ajax['status'] = 1;
        $ajax['data'] = $relationList;
        $this->ajaxReturn($ajax);
    }

    /**
     * 获取APK文件信息
     */
    public function public_getApkInfo() {
        $attachmentId = intval($this->_get('attachment_id'));

		import('@.ORG.ApkParser');
        $ApkParser = new ApkParser();
        import('@.ORG.Xml');
        $xml = new Xml();

        //import('@.ORG.ApkParser.loader');

        $attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId);
        if (empty($attachmentInfo)) {
            $this->ajaxReturn(array('status' => 0, 'content' => '附件不存在'));
        }

        $filename = urlToFilePath($attachmentInfo['file_url']);
        if (!file_exists($filename)) {
            $this->ajaxReturn(array('status' => 0, 'content' => '文件不存在'));
        }


        //$apk = new \ApkParser\Parser($filename);
        //$manifest = $apk->getManifest();

        //$sdkVersion = array_pop($manifest->getMinSdk()->versions);
        //if ($sdkVersion) {
            // 取前两个数字组成SDK版本号
            //$explode = explode('.', $sdkVersion);
            //$sdkVersion = $explode[0] . $explode[1];
        //}

		$ApkParser->open($filename);
        $manifest = $xml->xml_unserialize($ApkParser->getXML());

        //权限
        foreach ($manifest['manifest']['uses-permission'] as $k => $v) {
			foreach ($v as $row) {
				$permission[] = $row;
			}
		}

        $apkInfo = array(
            'file_size' => $attachmentInfo['file_size'],
			//包名
            'package_name' => $manifest['manifest attr']['package'],
            //版本名称
            'version' => $manifest['manifest attr']['android:versionName'],
            //版本代码
            'version_code' => $manifest['manifest attr']['android:versionCode'],
            //SDK版本号
            'min_sdk_version' => $manifest['manifest']['uses-sdk attr']['android:minSdkVersion'],
            //权限列表
            'permission_list' => implode(',', $permission)
        );

		/*$apkInfo = array(
            'file_size' => $attachmentInfo['file_size'],
            'package_name' => $manifest->getPackageName(),
            'version' => $manifest->getVersionName(),
            'version_code' => $manifest->getVersionCode(),
            'min_sdk_level' => $manifest->getMinSdkLevel(),
            'min_sdk_version' => $sdkVersion,
            'permission_list' => $manifest->getPermissions()
        );*/
        $this->ajaxReturn(array('status' => 1, 'data' => $apkInfo));
//        echo '<pre>';
//        echo "Package Name      : " . $manifest->getPackageName() . "\r\n";
//        echo "Vesrion           : " . $manifest->getVersionName() . " (" . $manifest->getVersionCode() . ")\r\n";
//        echo "Min Sdk Level     : " . $manifest->getMinSdkLevel() . "\r\n";
//        echo "Min Sdk Platfrom  : " . $manifest->getMinSdk()->platform . "\r\n";
//        dump($manifest);
//
//        echo "------------- Permssions List -------------\r\n";
//
//        // find max length to print more pretty.
//        $perm_keys = array_keys($permissions);
//        $perm_key_lengths = array_map(function($perm) {
//            return strlen($perm);
//        }, $perm_keys);
//        $max_length = max($perm_key_lengths);
//
//        foreach ($permissions as $perm => $description) {
//            echo str_pad($perm, $max_length + 4, ' ') . "=> " . $description . " \r\n";
//        }
    }

    /**
     * 显示添加内容页面
     * @param type $data
     */
    private function _showApplicationForm($data = array()) {
        $applicationFormData = $this->applicationService->getApplicationForm($this->categoryId, $this->modelId, C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.INDEX'), $data);
        $this->assign('applicationFormData', $applicationFormData);
        $this->display('applicationForm');
    }

}

?>
