<?php
define('IN_ADMIN', true);
/**
 * 应用管理Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
class PostAction extends FrontBaseAction {

    protected $categoryCache, $modelCache, $applicationService, $isSystemAdmin;
    protected $modelId, $categoryId;
    protected $searchType;

    const NOT_AUTH_ACTION_INDEX = 'index'; //本action无需验证函数名
    const NOT_AUTH_ACTION_APPLICATION_LIST = 'applicationList'; //本action无需验证函数名
    const CACHE_CLASS_LIST_PREFIX = 'CacheClassList'; //栏目菜单列表缓存名前缀
    //搜索类型
    const SERACH_TYPE_TITLE = 1;        // 文章标题
    const SERACH_TYPE_DESCRIPTION = 2;  // 文章简介
    const SERACH_TYPE_USERNAME = 3;     // 发布人名称
    const SERACH_TYPE_ID = 4;           // 文章ID

    function _initialize() {
        parent::_initialize();
        $this->categoryCache = FData('Category');
        $this->modelCache = D('Model')->getModelByType(NULL, 1);
        $this->applicationService = BService('Application', 'Market');
        $this->isSystemAdmin = BaseAction::getVar('user_id') === BaseAction::getVar('super_role_id'); //是否超级管理员

        $get = $this->_get();
        $this->categoryId = intval($get['category_id']);
        $this->modelId = intval($get['model_id']);

        // 如果存在栏目ID，则进行检查
        if ($this->categoryId) {
            $category = $this->categoryCache[$this->categoryId];
            if (empty($category)) {
                $this->error('栏目不存在');
            }

            if ($this->modelId && !(array_key_exists($this->modelId, $category['model']) && array_key_exists($this->modelId, $this->modelCache))) {
                $this->error('模型ID非法');
            }
        } else {
            $this->categoryId = 0;
            $this->modelId = 0;
            $this->id = 0;
        }




        //搜索类型
        $this->searchType = array(
            self::SERACH_TYPE_TITLE => '标题',
            self::SERACH_TYPE_USERNAME => '发布人名称',
            self::SERACH_TYPE_ID => 'ID',
        );
    }
	public function test(){
		header("Content-Type: text/html; charset=UTF-8");
		$data = F('yes');
		$length = filesize('I:/yidongku/Upload/File/2014/04/13/20140522041300147750.apk');
		dump($length);
		// 调用Service添加内容
            //if ($this->applicationService->add($data)) {
                //dump('1');
            //} else {
                //header("Content-Type: text/html; charset=UTF-8");
				//dump($this->applicationService->getError());
            //}
	}


    /**
     * 添加信息
     * ps:此action不能随意改名，如需要改名，请一同更改C('CATEGORY_ROLE_PURVIEW_ACTION_LIST.ADD')
     */
    public function add() {
        if (!($this->categoryId && $this->modelId)) {
            $this->error('栏目ID或模型ID不能为空');
        }

        $category = $this->categoryCache[$this->categoryId];
        if (IS_POST) {
            // 判断栏目是否一般栏目
            if (C('CATEGORY_TYPE.NORMAL') !== intval($category['type'])) {
                $this->bpiAjaxReturn(false, '该栏目下无法添加信息');
            }

            // 获取数据
            $post = $this->_post();
            $post['category_id'] = $this->categoryId;
            $post['model_id'] = $this->modelId;



        
            //缩略图处理
			$info[icon]=preg_replace("/<img src=\"(.*)\" \/>/is","\\1",bpiHtmlspecialcharsDecode($post['info']['icon']));
			$file_Info = pathinfo('I:/yidongku/Upload/File/'.$info[icon]);
			$file_size = filesize('I:/yidongku/Upload/File/'.$info[icon]);
			$icon = BService("Attachment")->saveAttachmentInfo('Application', $post['category_id'], $info[icon], str_replace($file_Info['basename'], '', $info[icon]), $file_Info['basename'], $file_size, $file_Info['extension'], $water = false, $qrcode = false, $isThumb = '1');
			$post['info']['icon'] = $icon['id'];
			//缩略图处理结束

			//应用截图处理
			//加上换行和特殊标识
			$post['info']['screenshot'] = str_replace('" />','" />#@@@#
			',bpiHtmlspecialcharsDecode($post['info']['screenshot'])); //简单替换一下

			//提取地址
			$post['info']['screenshot']=preg_replace("/<img src=\"(.+)\" \/>/i","\\1",$post['info']['screenshot']);
			//去掉换行
			$post['info']['screenshot'] = str_replace(' 
			','',$post['info']['screenshot']); //简单替换一下
			$post['info']['screenshot'] = $this->DeleteHtml($post['info']['screenshot']);
			$post['info']['screenshot'] = substr($post['info']['screenshot'],0,-5);

			$screenshot = explode('#@@@#',$post['info']['screenshot']);
			foreach ($screenshot as $key => $value) {
				$file_Infob = pathinfo('I:/yidongku/Upload/File/'.$value);
				$file_sizeb = filesize('I:/yidongku/Upload/File/'.$value);
				//附件入库
				$picdb[] = BService("Attachment")->saveAttachmentInfo('Application', $post['category_id'], $value, str_replace($file_Infob['basename'], '', $value), $file_Infob['basename'], $file_sizeb, $file_Infob['extension'], $water = false, $qrcode = false, $isThumb = false);
				$picbd2['url'][$key] = $picdb[$key]['url'];
				$picbd2['name'][$key] = $picdb[$key]['name'];
				$picbd2['attachment_id'][$key] = ''.$picdb[$key]['id'].'';
				$picbd2['group_id'][$key] = '2';
				$picbd2['point'][$key] = '0';

			}
			$post['info']['screenshot'] = $picbd2;
			//应用截图处理结束

			//下载地址处理
			$download_url = str_replace('<a href="','',bpiHtmlspecialcharsDecode($post['info']['download_url'])); //简单替换一下
			$download_url = str_replace('" >免费下载</a>','',$download_url); //简单替换一下


			$file_Infoc = pathinfo('I:/yidongku/Upload/File/'.$download_url);
			$file_sizec = filesize('I:/yidongku/Upload/File/'.$download_url);

			$download = BService("Attachment")->saveAttachmentInfo('Application', $post['category_id'], $download_url, str_replace($file_Infoc['basename'], '', $download_url), $file_Infoc['basename'], $file_sizec, $file_Infoc['extension'], $water = false, $qrcode = '1', $isThumb = false);
			$post['info']['download_url'] = $download['id'];
			$post['info']['size'] = $file_sizec;
			//下载地址处理结束
			//F('yes',$post);
			// 调用Service添加内容
			$applicationId = $this->applicationService->add($post);
            if ($applicationId) {
				if($post['model_id']=='50'){
					$modelName = 'app';
				}else{
					$modelName = 'game';
				}
				$applicationTypeList = C('APPLICATION_TYPE');
        		$applicationType = NULL;
        		if (array_key_exists(strtoupper($modelName), $applicationTypeList)) {
        		    $applicationType = $applicationTypeList[strtoupper($modelName)];
        		}
        		$abctest = BService('Hit')->hit(C('ACCESS_TYPE.APPLICATION'), $applicationId, $applicationType, C('HIT_FLAG.DOWNLOAD'), $post['category_id']);
                echo '发布成功';
            } else {
                F('getError',$this->applicationService->getError());
				echo $this->applicationService->getError();
            }
        } else {
			header("Content-Type: text/html; charset=UTF-8");
			$categoryTree = BService('Category')->getPostCategoryTreeList(C('MODEL_TYPE.APPLICATION'), C('CATEGORY_TYPE.NORMAL'), U('Market/Application/applicationList'));
			$this->assign('categoryList', $categoryTree);
            $this->display();
            //$this->_showApplicationForm();
        }
    }
	public function replace(){

		$Model = new Model(); // 实例化一个model对象 没有对应任何数据表
        $applicationList = $Model->query("select id,category_id from bpi_application where model_id='52' limit 10000,5000");
		$oo = 0;
        foreach($applicationList as $row)
        {
            //dump($row);
			//$kid = $row['id'];
            //$rpf = $this->DeleteHtml($row['icon']);
			//$rs = $Model->execute("update bpi_application set icon='$rpf' where id='$kid'");
			$modelName = 'game';

			$applicationTypeList = C('APPLICATION_TYPE');
        	$applicationType = NULL;
        	if (array_key_exists(strtoupper($modelName), $applicationTypeList)) {
        	    $applicationType = $applicationTypeList[strtoupper($modelName)];
        	}

			$rs = BService('Hit')->hit(C('ACCESS_TYPE.APPLICATION'), $row['id'], $applicationType, C('HIT_FLAG.DOWNLOAD'), $row['category_id']);
            if($rs)
            {
                $oo++;
            }
        }
		echo $oo;

	}
   	

    public function DeleteHtml($str){
		$str = trim($str); 
        $str = ereg_replace("\t","",$str); 
        $str = ereg_replace("\r\n","",$str); 
        $str = ereg_replace("\r","",$str); 
        $str = ereg_replace("\n","",$str); 
        return trim($str); 
	}

    /**
     * 获取栏目菜单列表
     */
    public function public_categoryList() {
        $categoryTree = BService('Category')->getPostCategoryTreeList(C('MODEL_TYPE.APPLICATION'), C('CATEGORY_TYPE.NORMAL'), U('Market/Application/applicationList'));
        $this->assign('categoryList', $categoryTree);
        $this->display();
    }
    /**
     * 获取APK文件信息
     */
    public function public_getApkInfo() {
        $attachmentId = intval($this->_get('attachment_id'));
        import('@.ORG.ApkParser.loader');

        $attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId);
        if (empty($attachmentInfo)) {
            $this->ajaxReturn(array('status' => 0, 'content' => '附件不存在'));
        }

        $filename = urlToFilePath($attachmentInfo['file_url']);
        if (!file_exists($filename)) {
            $this->ajaxReturn(array('status' => 0, 'content' => '文件不存在'));
        }

        $apk = new \ApkParser\Parser($filename);
        $manifest = $apk->getManifest();

        $sdkVersion = array_pop($manifest->getMinSdk()->versions);
        if ($sdkVersion) {
            // 取前两个数字组成SDK版本号
            $explode = explode('.', $sdkVersion);
            $sdkVersion = $explode[0] . $explode[1];
        }

        $apkInfo = array(
            'file_size' => $attachmentInfo['file_size'],
            'package_name' => $manifest->getPackageName(),
            'version' => $manifest->getVersionName(),
            'version_code' => $manifest->getVersionCode(),
            'min_sdk_level' => $manifest->getMinSdkLevel(),
            'min_sdk_version' => $sdkVersion,
            'permission_list' => $manifest->getPermissions()
        );
        $this->ajaxReturn(array('status' => 1, 'data' => $apkInfo));
//        echo '<pre>';
//        echo "Package Name      : " . $manifest->getPackageName() . "\r\n";
//        echo "Vesrion           : " . $manifest->getVersionName() . " (" . $manifest->getVersionCode() . ")\r\n";
//        echo "Min Sdk Level     : " . $manifest->getMinSdkLevel() . "\r\n";
//        echo "Min Sdk Platfrom  : " . $manifest->getMinSdk()->platform . "\r\n";
//        dump($manifest);
//
//        echo "------------- Permssions List -------------\r\n";
//
//        // find max length to print more pretty.
//        $perm_keys = array_keys($permissions);
//        $perm_key_lengths = array_map(function($perm) {
//            return strlen($perm);
//        }, $perm_keys);
//        $max_length = max($perm_key_lengths);
//
//        foreach ($permissions as $perm => $description) {
//            echo str_pad($perm, $max_length + 4, ' ') . "=> " . $description . " \r\n";
//        }
    }


}

?>
