<?php

/**
 * 专题管理Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
class TopicAction extends AdminBaseAction {

    protected $categoryCache, $modelCache, $applicationService, $isSystemAdmin;
    protected $modelId, $categoryId;
    protected $searchType;

    const NOT_AUTH_ACTION_INDEX = 'index'; //本action无需验证函数名
    const NOT_AUTH_ACTION_SPECIAL_LIST = 'topicList'; //本action无需验证函数名
    const CACHE_CLASS_LIST_PREFIX = 'CacheClassList'; //栏目菜单列表缓存名前缀
    //搜索类型
    const SERACH_TYPE_TITLE = 1;        // 文章标题
    const SERACH_TYPE_DESCRIPTION = 2;  // 文章简介
    const SERACH_TYPE_USERNAME = 3;     // 发布人名称
    const SERACH_TYPE_ID = 4;           // 文章ID

    function _initialize() {
        parent::_initialize();
        $this->categoryCache = FData('Category');
        $this->modelCache = D('Model')->getModelByType(C('MODEL_TYPE.APPLICATION'), 1);
        $this->applicationService = BService('Application', 'Market');
        $this->isSystemAdmin = BaseAction::getVar('user_id') === BaseAction::getVar('super_role_id'); //是否超级管理员

        $get = $this->_get();
        $this->categoryId = intval($get['category_id']);
        $this->modelId = intval($get['model_id']);

        // 如果存在栏目ID，则进行检查
        if ($this->categoryId) {
            $category = $this->categoryCache[$this->categoryId];
            if (empty($category)) {
                $this->error('栏目不存在');
            }

            if ($this->modelId && !(array_key_exists($this->modelId, $category['model']) && array_key_exists($this->modelId, $this->modelCache))) {
                $this->error('模型ID非法');
            }
        } else {
            $this->categoryId = 0;
            $this->modelId = 0;
            $this->id = 0;
        }


        //验证权限
        if (!$this->isSystemAdmin) {
            // 通过部分无需验证action,如public_开头和index方法
            if (strpos(ACTION_NAME, C('NOT_AUTH_ACTION_PREFIX_AFTER_LOGIN')) !== 0 && !in_array(ACTION_NAME, array(self::NOT_AUTH_ACTION_INDEX, self::NOT_AUTH_ACTION_SPECIAL_LIST))) {
                //对非一般栏目只要有index权限即有全权限
                $action = intval($category['type']) === C('CATEGORY_TYPE.NORMAL') ? ACTION_NAME : self::NOT_AUTH_ACTION_INDEX;
                $map = array(
                    'category_id' => $this->categoryId,
                    'is_admin' => 1,
                    'role_id' => BaseAction::getVar('user/role_id'),
                    'action' => $action,
                );
                //权限列表
                $purviewList = M('CategoryPurview')->where($map)->select();
                if (!$purviewList) {
                    $this->error('权限不足');
                }
            }
        }

        //搜索类型
        $this->searchType = array(
            self::SERACH_TYPE_TITLE => '标题',
            self::SERACH_TYPE_USERNAME => '发布人名称',
            self::SERACH_TYPE_ID => 'ID',
        );
    }

    /**
     * 显示首页
     * ps:此action不能随意改名，如需要改名，请一同更改NOT_AUTH_ACTION_INDEX
     */
    public function index() {//
        if ($this->categoryId) {
            $this->assign('topicListUrl', U('Market/Topic/topicList', array('category_id' => $this->categoryId)));
        }
        $this->display();
    }

    /**
     * 获取栏目菜单列表
     */
    public function public_categoryList() {
        $categoryTree = BService('Category')->getPostCategoryTreeList(NULL, C('CATEGORY_TYPE.TOPIC'), U('Market/Topic/topicList'));
        $this->assign('categoryList', $categoryTree);
        $this->display();
    }

    /**
     * 获取专题列表
     */
    public function topicList() {
        $category = $this->categoryCache[$this->categoryId];
        // 判断栏目是否存在
        if (empty($category)) {
            $this->error('栏目不存在');
        }

        // 查询当前分类
        $map = array('category_id' => $this->categoryId);

        // 判断是否搜索
        if ($this->_get('search')) {
            // 状态
            $status = $this->_get('status');
            $status !== null && $map['status'] = intval($status);
            // 开始时间和结束时间
            $startTime = strtotime($this->_get('start_time', '', 0));
            $endTime = strtotime($this->_get('end_time', '', time()));
            if ($endTime > $startTime) {
                $map['create_time'] = array(array('EGT', $startTime), array('ELT', $endTime));
                $this->assign('startTime', date('Y-m-d', $startTime));
                $this->assign('endTime', date('Y-m-d', $endTime));
            }
            // 搜索类型
            $keyword = $this->_get('keyword');
            if (!empty($keyword)) {
                $type = $this->_get('search_type');
                switch ($type) {
                    case self::SERACH_TYPE_ID:
                        $map['id'] = intval($keyword);
                        break;
                    case self::SERACH_TYPE_TITLE:
                        $map['title'] = array('LIKE', '%' . $keyword . '%');
                        break;
                    case self::SERACH_TYPE_USERNAME:
                        $memberIds = M('Member')->where(array('user_name' => array('like', '%' . $keyword . '%')))->order('last_login_date DESC')->limit(50)->getField('user_id', true);
                        $adminIds = M('Admin')->where(array('user_name' => array('like', '%' . $keyword . '%')))->getField('user_id', true);

                        if ($memberIds && $adminIds) {
                            //两者同时拥有
                            $map['_string'] = '(is_admin_add = 0 AND user_id IN (' . implode(',', $memberIds) . ')) OR (is_admin_add = 1 AND user_id IN (' . implode(',', $adminIds) . '))';
                        } else if ($memberIds) {
                            //只搜索到用户组
                            $map['is_admin_add'] = 0;
                            $map['user_id'] = array('in', $memberIds);
                        } else if ($adminIds) {
                            //只搜索到管理员
                            $map['is_admin_add'] = 1;
                            $map['user_id'] = array('in', $adminIds);
                        } else {
                            //找不到结果
                            unset($map);
                            $map['id'] = 0;
                        }
                        break;
                    default:
                        $type = self::SERACH_TYPE_TITLE;
                        $map['title'] = array('LIKE', '%' . $keyword . '%');
                        break;
                }
                $this->assign('type', $type);
                $this->assign('keyword', $keyword);
            }
        }

        $applicationModel = M('Application');
        $count = $applicationModel->where($map)->count();
        $page = page($count);
        $applicationList = $applicationModel->where($map)->limit($page->firstRow, $page->listRows)->order(array('id' => 'DESC'))->select();

        foreach ($applicationList as &$application) {
            if ($application['pid']) {
                $application['_parent_'] = $applicationModel->find($application['pid']);
            }

            $id = intval($application['_parent_'] ? $application['_parent_']['id'] : $application['id']);
            $modelId = intval($application['_parent_'] ? $application['_parent_']['model_id'] : $application['model_id']);
            $categoryId = intval($application['_parent_'] ? $application['_parent_']['category_id'] : $application['category_id']);

            //下载量
            $applicationType = D('Market/Application')->getApplicationTypeByModelId($application['model_id']);
            $hitInfo = BService('Hit')->getHit(C('ACCESS_TYPE.APPLICATION'), $id, $applicationType, C('HIT_FLAG.DOWNLOAD'));
            $application['hit_count'] = intval($hitInfo[$id]['total_count']);
            $application['user_name'] = getUserNameById($application['user_id'], $application['is_admin_add']);
            //url
            if (empty($application['url'])) {
                $application['url'] = BService('Url')->getContentUrl($categoryId, $application['id']);
            }
        }

        // 显示可添加的模型
        $modelList = array();
        foreach ($this->modelCache as $modelId => $model) {
            if (array_key_exists($modelId, $category['model'])) {
                $modelList[$modelId] = $model['name'];
            }
        }

        $this->assign('searchType', $this->searchType);
        $this->assign('category', $category);
        $this->assign('modelList', $modelList);
        $this->assign('applicationList', $applicationList);
        $this->assign('page', $page->show());
        $this->display();
    }

}

?>
