<?php

/**
 * 程序模型model
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-18
 * @updateTime 2013-4-18
 */
class ApplicationModel extends Model {

    /**
     * 根据模型名称获取程序类型
     * @param type $modelName
     * @return null
     */
    public function getApplicationTypeByModelName($modelName) {
        $modelName = strtolower($modelName);
        switch ($modelName) {
            case C('APPLICATION_MODEL_NAME.GAME'):
                $applicationType = C('APPLICATION_TYPE.GAME');
                break;
            case C('APPLICATION_MODEL_NAME.APP'):
            default:
                $applicationType = C('APPLICATION_TYPE.APP');
                break;
        }
        return $applicationType;
    }

    /**
     * 根据模型id获取程序类型
     * @param type $modelId
     * @return boolean
     */
    public function getApplicationTypeByModelId($modelId) {
        if ($modelId) {
            $modelId = intval($modelId);
        } else {
            $this->error('参数缺失');
            return false;
        }
        $modelName = D('Model')->getModelTableName($modelId, false, true);
        if ($modelName) {
            return $this->getApplicationTypeByModelName($modelName);
        } else {
            return false;
        }
    }

}

?>
