<?php

namespace ApkParser;

/**
 * ApkManifest
 * -- description is coming.
 * 
 * @todo  Add getPackageName();
 * @todo  Add getVersion();
 * @todo  Add getUsesSdk();
 * @todo  Add getMinSdk();
 * 
 * @property $xmlParser \ApkParser\XmlParser
 */
class Manifest extends \ApkParser\Xml {

    private $xmlParser;
    private $attrs = null;

    public function __construct(\ApkParser\XmlParser $xmlParser) {
        $this->xmlParser = $xmlParser;
    }

    /**
     * Returns ManifestXml as a String.
     * @return string
     */
    public function getXmlString() {
        return $this->xmlParser->getXmlString();
    }

    /**
     * Get Application Permissions
     * @return array
     */
    public function getPermissions() {
        return $this->getXmlObject()->getPermissions();
    }

    /**
     * Android Package Name
     * @return string
     */
    public function getPackageName() {
        return $this->getAttribute('package');
    }

    /**
     * Application Version Name
     * @return string
     */
    public function getVersionName() {
        return $this->getAttribute('versionName');
    }

    /**
     * Application Version Code
     * @return mixed
     */
    public function getVersionCode() {
        return hexdec($this->getAttribute('versionCode'));
    }

    /**
     * @return bool
     */
    public function isDebuggable() {
        return (bool) $this->getAttribute('debuggable');
    }

    /**
     * The minimum API Level required for the application to run.
     * @return int
     */
    public function getMinSdkLevel() {
        $xmlObj = $this->getXmlObject();
        $usesSdk = get_object_vars($xmlObj->{'uses-sdk'});
        return hexdec($usesSdk['@attributes']['minSdkVersion']);
    }

    private function getAttribute($attributeName) {
        if ($this->attrs === NULL) {
            $xmlObj = $this->getXmlObject();
            $vars = get_object_vars($xmlObj->attributes());
            $this->attrs = $vars['@attributes'];
        }

        if (!isset($this->attrs[$attributeName])) {
            throw new \Exception("Attribute not found : " . $attributeName);
        }

        return $this->attrs[$attributeName];
    }

    /**
     * More Information About The minimum API Level required for the application to run.
     * @return \ApkParser\AndroidPlatform
     */
    public function getMinSdk() {
        return new \ApkParser\AndroidPlatform($this->getMinSdkLevel());
    }

    /**
     * get SimleXmlElement created from AndroidManifest.xml
     * 
     * @param mixed $className
     * @return \ApkParser\ManifestXmlElement
     */
    public function getXmlObject($className = '\ApkParser\ManifestXmlElement') {
        return $this->xmlParser->getXmlObject($className);
    }

    /**
     * Basicly string casting method.
     */
    public function __toString() {
        return $this->getXmlString();
    }

    /**
     * Android Permissions list 
     * @see http://developer.android.com/reference/android/Manifest.permission.html
     * 
     * @todo: Move to {lang}_perms.php file, for easly translations.
     * @var mixed
     */
    public static $permissions = array(
        'android.permission.ACCESS_CHECKIN_PROPERTIES' => '允许读写访问”properties”表在checkin数据库中，改值可以修改上传',
        'android.permission.ACCESS_COARSE_LOCATION' => '允许一个程序访问CellID或WiFi热点来获取粗略的位置',
        'android.permission.ACCESS_FINE_LOCATION' => '允许一个程序访问精良位置(如GPS)',
        'android.permission.ACCESS_LOCATION_EXTRA_COMMANDS' => '允许应用程序访问额外的位置提供命令',
        'android.permission.ACCESS_MOCK_LOCATION' => '允许程序创建模拟位置提供用于测试',
        'android.permission.ACCESS_NETWORK_STATE' => '允许程序访问有关GSM网络信息',
        'android.permission.ACCESS_SURFACE_FLINGER' => '允许程序使用SurfaceFlinger底层特性',
        'android.permission.ACCESS_WIFI_STATE' => '允许程序访问Wi-Fi网络状态信息',
        'android.permission.ADD_SYSTEM_SERVICE' => '允许程序发布系统级服务',
        'android.permission.ACCOUNT_MANAGER' => '获取账户验证信息，主要为GMail账户信息，只有系统级进程才能访问的权限',
        'android.permission.AUTHENTICATE_ACCOUNTS' => '允许一个程序通过账户验证方式访问账户管理ACCOUNT_MANAGER相关信息',
        'android.permission.BIND_APPWIDGET' => '允许一个程序告诉appWidget服务需要访问小插件的数据库，只有非常少的应用才用到此权限',
        'android.permission.BIND_DEVICE_ADMIN' => '请求系统管理员接收者receiver，只有系统才能使用',
        'android.permission.BIND_INPUT_METHOD' => '请求InputMethodService服务，只有系统才能使用',
        'android.permission.BIND_REMOTEVIEWS' => '必须通过RemoteViewsService服务来请求，只有系统才能用',
        'android.permission.BIND_WALLPAPER' => '必须通过WallpaperService服务来请求，只有系统才能用',
        'android.permission.KILL_BACKGROUND_PROCESSES' => '允许应用调用killBackgroundProcesses(String)',
        'android.permission.CELL_PHONE_MASTER_EX' => '手机优化大师扩展权限',
        'com.android.launcher.permission.WRITE_SETTINGS' => '允许应用程序更改主屏幕中的设置和快捷方式',
        'com.android.launcher.permission.READ_SETTINGS' => '创建快捷方式和判断是否已经创建',
        'android.permission.BATTERY_STATS' => '允许程序更新手机电池统计信息',
        'android.permission.BLUETOOTH' => '允许程序连接到已配对的蓝牙设备',
        'android.permission.BLUETOOTH_ADMIN' => '允许程序发现和配对蓝牙设备',
        'android.permission.BRICK' => '请求能够禁用设备(非常危险)',
        'android.permission.BROADCAST_PACKAGE_REMOVED' => '允许程序广播一个提示消息在一个应用程序包已经移除后',
        'android.permission.BROADCAST_STICKY' => '允许一个程序广播常用intents',
        'android.permission.CALL_PHONE' => '允许一个程序初始化一个电话拨号不需通过拨号用户界面需要用户确认',
        'android.permission.CALL_PRIVILEGED' => '允许一个程序拨打任何号码，包含紧急号码无需通过拨号用户界面需要用户确认',
        'android.permission.CAMERA' => '请求访问使用照相设备',
        'android.permission.CHANGE_COMPONENT_ENABLED_STATE' => '允许一个程序是否改变一个组件或其他的启用或禁用',
        'android.permission.CHANGE_CONFIGURATION' => '允许一个程序修改当前设置，如本地化',
        'android.permission.CHANGE_NETWORK_STATE' => '允许程序改变网络连接状态',
        'android.permission.CHANGE_WIFI_STATE' => '允许程序改变Wi-Fi连接状态',
        'android.permission.CLEAR_APP_CACHE' => '允许一个程序清楚缓存从所有安装的程序在设备中',
        'android.permission.CLEAR_APP_USER_DATA' => '允许一个程序清除用户设置',
        'android.permission.CONTROL_LOCATION_UPDATES' => '允许启用禁止位置更新提示从无线模块',
        'android.permission.DELETE_CACHE_FILES' => '允许程序删除缓存文件',
        'android.permission.DELETE_PACKAGES' => '允许一个程序删除包',
        'android.permission.DEVICE_POWER' => '允许访问底层电源管理',
        'android.permission.DIAGNOSTIC' => '允许程序RW诊断资源',
        'android.permission.DISABLE_KEYGUARD' => '允许程序禁用键盘锁',
        'android.permission.DUMP' => '允许程序返回状态抓取信息从系统服务',
        'android.permission.EXPAND_STATUS_BAR' => '允许一个程序扩展收缩在状态栏,应该是一个类似Windows Mobile中的托盘程序',
        'android.permission.FACTORY_TEST' => '作为一个工厂测试程序，运行在root用户',
        'android.permission.FLASHLIGHT' => '访问闪光灯,HTC Dream不包含闪光灯',
        'android.permission.FORCE_BACK' => '允许程序强行一个后退操作是否在顶层activities',
        'android.permission.FOTA_UPDATE' => '暂时不了解这是做什么使用的，这可能是一个预留权限.',
        'android.permission.GET_ACCOUNTS' => '访问一个帐户列表在Accounts Service中',
        'android.permission.GET_PACKAGE_SIZE' => '允许一个程序获取任何package占用空间容量',
        'android.permission.GET_TASKS' => '允许一个程序获取信息有关当前或最近运行的任务，一个缩略的任务状态，是否活动等等',
        'android.permission.HARDWARE_TEST' => '允许访问硬件',
        'android.permission.INJECT_EVENTS' => '允许一个程序截获用户事件如按键、触摸、轨迹球等等到一个时间流',
        'android.permission.INSTALL_PACKAGES' => '允许一个程序安装packages',
        'android.permission.INTERNAL_SYSTEM_WINDOW' => '允许打开窗口使用系统用户界面',
        'android.permission.INTERNET' => '允许程序打开网络套接字',
        'android.permission.MANAGE_APP_TOKENS' => '允许程序管理(创建、催后、 z- order默认向z轴推移)程序引用在窗口管理器中',
        'android.permission.MASTER_CLEAR' => '目前还没有明确的解释，查资料说可能是清除一切数据，类似硬格机',
        'android.permission.MODIFY_AUDIO_SETTINGS' => '允许程序修改全局音频设置',
        'android.permission.MODIFY_PHONE_STATE' => '允许修改话机状态，如电源，人机接口等',
        'android.permission.MOUNT_UNMOUNT_FILESYSTEMS' => '允许挂载和反挂载文件系统可移动存储',
        'android.permission.PERSISTENT_ACTIVITY' => '允许一个程序设置他的activities显示',
        'android.permission.PROCESS_OUTGOING_CALLS' => '允许程序监视、修改有关播出电话',
        'android.permission.READ_CALENDAR' => '允许程序读取用户日历数据',
        'android.permission.READ_CONTACTS' => '允许程序读取用户联系人数据',
        'android.permission.READ_FRAME_BUFFER' => '允许程序屏幕波或和更多常规的访问帧缓冲数据',
        'android.permission.READ_INPUT_STATE' => '允许程序返回当前按键状态',
        'android.permission.READ_LOGS' => '允许程序读取底层系统日志文件',
        'android.permission.READ_OWNER_DATA' => '允许程序读取所有者数据',
        'android.permission.READ_SMS' => '允许程序读取短信息',
        'android.permission.READ_SYNC_SETTINGS' => '允许程序读取同步设置',
        'android.permission.READ_SYNC_STATS' => '允许程序读取同步状态',
        'android.permission.REBOOT' => '请求能够重新启动设备',
        'android.permission.RECEIVE_BOOT_COMPLETED' => '允许一个程序接收到',
        'android.permission.RECEIVE_MMS' => '允许一个程序监控将收到MMS彩信,记录或处理',
        'android.permission.RECEIVE_SMS' => '允许程序监控一个将收到短信息，记录或处理',
        'android.permission.RECEIVE_WAP_PUSH' => '允许程序监控将收到WAP PUSH信息',
        'android.permission.RECORD_AUDIO' => '允许程序录制音频',
        'android.permission.REORDER_TASKS' => '允许程序改变Z轴排列任务',
        'android.permission.RESTART_PACKAGES' => '允许程序重新启动其他程序',
        'android.permission.SEND_SMS' => '允许程序发送SMS短信',
        'android.permission.SET_ACTIVITY_WATCHER' => '允许程序监控或控制activities已经启动全局系统中',
        'android.permission.SET_ALWAYS_FINISH' => '允许程序控制是否活动间接完成在处于后台时',
        'android.permission.SET_ANIMATION_SCALE' => '修改全局信息比例',
        'android.permission.SET_DEBUG_APP' => '配置一个程序用于调试',
        'android.permission.SET_ORIENTATION' => '允许底层访问设置屏幕方向和实际旋转',
        'android.permission.SET_PREFERRED_APPLICATIONS' => '允许一个程序修改列表参数PackageManager.addPackageToPreferred() 和PackageManager.removePackageFromPreferred()方法',
        'android.permission.SET_PROCESS_FOREGROUND' => '允许程序当前运行程序强行到前台',
        'android.permission.SET_PROCESS_LIMIT' => '允许设置最大的运行进程数量',
        'android.permission.SET_TIME_ZONE' => '允许程序设置时间区域',
        'android.permission.SET_WALLPAPER' => '允许程序设置壁纸',
        'android.permission.SET_WALLPAPER_HINTS' => '允许程序设置壁纸hits',
        'android.permission.SIGNAL_PERSISTENT_PROCESSES' => '允许程序请求发送信号到所有显示的进程中',
        'android.permission.STATUS_BAR' => '允许程序打开、关闭或禁用状态栏及图标Allows an application to open, close, or disable the status bar and its icons.',
        'android.permission.SUBSCRIBED_FEEDS_READ' => '允许一个程序访问订阅RSS Feed内容提供',
        'android.permission.SUBSCRIBED_FEEDS_WRITE' => '系统暂时保留改设置,未知',
        'android.permission.SYSTEM_ALERT_WINDOW' => '允许一个程序打开窗口使用 TYPE_SYSTEM_ALERT，显示在其他所有程序的顶层(Allows an application to open windows using the type TYPE_SYSTEM_ALERT, shown on top of all other applications. )',
        'android.permission.VIBRATE' => '允许访问振动设备',
        'android.permission.WAKE_LOCK' => '允许使用PowerManager的 WakeLocks保持进程在休眠时从屏幕消失',
        'android.permission.WRITE_APN_SETTINGS' => '允许程序写入API设置',
        'android.permission.WRITE_CALENDAR' => '允许一个程序写入但不读取用户日历数据',
        'android.permission.WRITE_CONTACTS' => '允许程序写入但不读取用户联系人数据',
        'android.permission.WRITE_GSERVICES' => '允许程序修改Google服务地图',
        'android.permission.WRITE_OWNER_DATA' => '允许一个程序写入但不读取所有者数据',
        'android.permission.WRITE_SETTINGS' => '允许程序读取或写入系统设置',
        'android.permission.WRITE_SMS' => '允许程序写短信',
        'android.permission.WRITE_SYNC_SETTINGS' => '允许程序写入同步设置',
        'android.permission.BROADCAST_SMS' => '允许程序监视、修改有关播出电话',
        'android.permission.READ_PHONE_STATE' => '允许读取话机状态',
        'android.permission.READ_EXTERNAL_STORAGE' => '允许程序读取外部存储(读取SD卡)',
        'android.permission.WRITE_EXTERNAL_STORAGE' => '允许程序写入外部存储(写入SD卡)',
        'com.android.launcher.permission.INSTALL_SHORTCUT' => '允许创建快捷方式相关权限',
    );

}
