<?php

namespace ApkParser;

class ManifestXmlElement extends \SimpleXMLElement {

    public function getPermissions() {
        /**
         * @var \ApkParser\ManifestXmlElement
         */
        $permsArray = $this->{'uses-permission'};

        $perms = array();
        foreach ($permsArray as $perm) {
            $permAttr = get_object_vars($perm);
            $fullPermName = $permAttr['@attributes']['name'];
            $permName = trim(array_pop(explode('.', $fullPermName)));
            $perms[$permName] = \ApkParser\Manifest::$permissions[$fullPermName];
        }

        return $perms;
    }

}
