<?php

/**
 * 第三方登陆
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-31
 * @updateTime 2013-5-31
 */
class ConnectAction extends MemberBaseAction {

    protected $memberConfig, $connectConfig, $connectModel;

    public function _initialize() {
        parent::_initialize(true);
        $this->memberConfig = FData('MemberConfig', 'Member');
        $this->connectConfig = $this->memberConfig['connect'];
        $this->connectModel = D('Connect');
    }

    public function index() {
        $this->display();
    }

    /**
     * 跳转到授权界面
     */
    public function authorize() {
        $type = $this->_get('type');
        empty($type) && $this->error('参数错误');
        import('@.ORG.ThinkOauth');
        $connect = ThinkOauth::getInstance($type);
        //跳转到授权页面
        redirect($connect->getRequestCodeURL());
    }

    /**
     * 授权回调方法
     */
    public function callback() {
        $type = $this->_get('type');
        $code = $this->_get('code');
        (empty($type) || empty($code)) && $this->error('参数错误');
        //腾讯微博需传递的额外参数
        $extend = null;
        if ($type === 'tencent') {
            $extend = array('openid' => $this->_get('openid'), 'openkey' => $this->_get('openkey'));
        }

        $this->_oauthCallback($type, $code, $extend);
    }

    /**
     * 绑定
     */
    public function bind() {
        parent::register('Connect:bind', false);
    }

    /**
     * 登陆/注册/绑定，授权回调主体方法
     * @param type $openid 标识
     */
    private function _oauthCallback($type, $code, $extend = NULL) {
        // 获取 TOKEN
        import("@.ORG.ThinkOauth");
        $connect = ThinkOauth::getInstance($type);
        $token = $connect->getAccessToken($code, $extend);

        $connectData = array(
            'type' => $type,
            'add_time' => time(),
            'expire_time' => time() + intval($token['expires_in']),
            'access_token' => $token['access_token'],
            'unique_id' => $token['unique_id'],
        );
        session(C('CONNECT_SESSION_KEY'), $connectData);

        if (empty($token['unique_id'])) {
            $this->error('登陆失败');
        }

        //绑定流程
        $redirect = U('Member/Index/index');
        if (BaseAction::getVar('user_id')) {//绑定当前用户
            // 尝试绑定第三方
            if (BService('Connect')->connectBindBySession()) {
                $this->success('绑定当前账户成功', $redirect);
                exit;
            } else {
                $this->error(BService('Member')->getError(), $redirect);
            }
        }

        //登录/注册流程
        $connectModel = D('Connect');
        $map = array('unique_id' => $token['unique_id'], 'type' => $type);
        $connectInfo = $connectModel->field('user_id,login_count')->where($map)->find();
        if ($connectInfo) {//已绑定，登录流程
            // 更新登陆信息
            $connectModel->where($map)->save(array(
                'access_token' => $token['access_token'],
                'expire_time' => time() + intval($token['expires_in']),
                'login_count' => intval($connectInfo['login_count']) + 1,
            ));
            //存在直接登陆
            //parent::userLoginMain(false);
            BService('Member')->registerLogin($connectInfo['user_id']);
            $this->success('登陆成功！', $redirect);
        } else {//未绑定，授权绑定注册流程
            //绑定新注册用户
            if ($this->connectConfig['bind']) {//手动绑定新用户
                $this->success('授权成功，跳转中', U('Member/Connect/bind'));
                exit;
            } else {//自动授权注册
                $userName = cutString($connectData['type'], 0, 6) . date('mdHis') . random(3, TRUE); //注意超长
                $password = random(16);
                //注册用户
                $this->_registerUserAfterOauthCallback($userName, $password, $type, $connectData);
            }
        }
    }

    /**
     * 第三方登录回调后注册用户
     * @param type $userName
     * @param type $password
     * @param type $type
     */
    private function _registerUserAfterOauthCallback($userName, $password, $type, $connectData) {
        $userId = BService('Member')->userRegister($userName, $password, '');
        if ($userId) {
            //TODO:提取到service
            $connectData = array_merge($connectData, array(
                'user_id' => $userId,
                'status' => 1,
                'login_count' => 1,
            ));
            $this->connectModel->add($connectData);
            //登陆成功动态分享
            BService('Connect')->sendWeibo($type);
            $this->userLoginMain(true, $userName, $password);
        }
    }

}
?>
