<?php

/**
 * 会员前台投稿管理
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-7-10
 * @updateTime 2013-7-10
 */
class ContentAction extends MemberBaseAction {

    protected $categoryCache, $modelCache;

    public function _initialize() {
        parent::_initialize();
        $this->categoryCache = FData('Category');
        $this->modelCache = D('Model')->getModelByType(C('MODEL_TYPE.CONTENT'), 1);
    }

    /**
     * 在线投稿
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();
            $data = $this->_checkBeforeContentAction($post);
            $category = $data['category'];
            $categoryId = $category['category_id'];
            $setting = $category['setting'];

            //调用service投稿
            $id = BService('Content')->add($post);
            if ($id) {
                //前台投稿，根据栏目配置和用户配置
                $memberGroupCache = FData('MemberGroup');
                //如果会员组设置中设置，投稿不需要审核，直接无视栏目设置
                $isCalcPoint = 0;
                if ($memberGroupCache[BaseAction::getVar('user/group_id')]['is_allow_post_no_verify'] || intval($setting['member_check']) === 0) {
                    //TODO:计算用户积分
                    //$isCalcPoint=Bservice('Member')->calcPoint();
                    $isCalcPoint = 0;
                }

                //增加投稿记录
                $addData = array(
                    'category_id' => $categoryId,
                    'content_id' => $id,
                    'user_id' => BaseAction::getVar('user_id'),
                    'is_calc_point' => $isCalcPoint,
                    'time' => time(),
                );
                D('MemberContent')->add($addData);
                $this->success('投稿成功', U('Member/Content/contentList'));
            } else {
                $error = BService('Content')->getError();
                $this->error(empty($error) ? '投稿失败' : $error);
            }
        } else {
            $categoryId = intval($this->_get('category_id'));
            $modelId = intval($this->_get('model_id'));
            if ($categoryId) {//选中栏目，显示投稿页面
                $this->_checkBeforeContentAction($this->_get());
                $isShowCategoryList = false;
                $this->_showContentForm($categoryId, $modelId);
            } else {
                $isShowCategoryList = true;
                import('Tree');
                $categoryTree = BService('Category')->getPostCategoryTreeList();
                $this->assign('categoryList', $categoryTree);
            }
            $this->assign('isShowCategoryList', $isShowCategoryList);
            $this->display('edit');
        }
    }

    /**
     * 编辑稿件
     */
    public function edit() {
        if (IS_POST) {
            $this->_checkBeforeContentAction($this->_post());
            if (BService('Content')->edit($this->_post())) {
                $this->success('编辑成功');
            } else {
                $error = BService('Content')->getError();
                $this->error(empty($error) ? '编辑失败' : $error);
            }
        } else {
            $contentId = intval($this->_get('id'));
            if (!$contentId) {
                $this->error('内容id缺失');
            }

            //获取数据
            $contentData = BService('Content')->getContentById($contentId);
            if (!$contentData) {
                $this->error('内容不存在');
            }

            //验证内容显示权限
            if (($contentData['is_admin_add'] == 1 || $contentData['user_id'] != BaseAction::getVar('user_id'))) {
                $this->error('权限错误');
            }

            $this->_showContentForm($contentData['category_id'], $contentData['model_id'], $contentData);
            $this->display('edit');
        }
    }

    /**
     * 显示投稿列表
     */
    public function contentList() {
        $contentList = array();
        //TODO: member_conteng表可以不要
        $memberContentModel = D('MemberContent');
        $userId = BaseAction::getVar('user_id');
        $map = array('user_id' => $userId);
        $count = $memberContentModel->where($map)->count();
        if ($count > 0) {
            $page = page($count);
            $dataList = $memberContentModel->where($map)->limit($page->firstRow . ',' . $page->listRows)->select();
            //轮询获取内容
            $contentModel = new AutoRelationModel('Content');
            foreach ($dataList as $value) {
                $info = $contentModel->where(array('id' => $value['content_id'], 'user_id' => $userId, 'is_admin_add' => 0))->find();
                if ($info) {
                    $contentList[$info['id']] = $info;
                }
            }
        }
        $this->assign('page', $page->show());
        $this->assign('contentList', $contentList);
        $this->display();
    }

    /**
     * 显示投稿页面
     * @param type $categoryId
     * @param type $modelId
     * @param type $contentData
     */
    public function _showContentForm($categoryId, $modelId, $contentData = array()) {
        $formModuleList = BService('Content')->getContentForm($categoryId, $modelId, C('CATEGORY_MEMBER_PURVIEW_ACTION_LIST.ADD'), $contentData);
        $this->assign('formModuleList', $formModuleList);
    }

    /**
     * 投稿/编辑投稿前的验证操作
     * @param type $request
     * @return type
     */
    private function _checkBeforeContentAction($request) {
        //栏目id
        $categoryId = $request['category_id'];
        if (!$categoryId) {
            $this->error('栏目id缺失');
        }
        $category = $this->categoryCache[$categoryId];
        if (!$category) {
            $this->error('栏目不存在');
        }

        //检查权限
        //TODO:封装此段SQL，经常用到
        $groupId = BaseAction::getVar('user/group_id');
        $purview = D('CategoryPurview')->where(array('category_id' => $categoryId, 'is_admin' => 0, 'role_id' => $groupId, 'action' => C('CATEGORY_MEMBER_PURVIEW_ACTION_LIST.ADD')))->find();
        if (!$purview) {
            $this->error('没有此栏目投稿权限');
        }
        // 判断栏目是否一般栏目
        if (intval($category['type']) !== C('CATEGORY_TYPE.NORMAL')) {
            $this->error('该栏目无法添加信息');
        }
        return $return = array(
            'category' => $category,
        );
    }

}

?>
