<?php

/**
 * 前台会员IndexAction
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-5-16
 * @updateTime 2013-5-16
 */
class IndexAction extends MemberBaseAction {

    public $memberModel, $memberRelationModel, $memberService, $memberModelCache;

    public function _initialize() {
        parent::_initialize();
        $this->memberModel = D('Member');
        $this->memberRelationModel = new AutoRelationModel('Member');
        $this->memberService = BService('Member');
        $this->memberModelCache = F('ModelMember');
    }

    /**
     * 会员中心首页
     */
    public function index() {
        $this->assign('seo', seo('', '个人中心 - 修改密码'));
        $this->assign('current', 'managePassword');
        $this->display();
    }

    /**
     * 管理个人信息
     */
    /*public function manageInfo() {
        if (IS_POST) {
            $post = $this->_post();
            $userId = BaseAction::getVar('user_id');
            //传递主键
            $post['user_id'] = $userId;
            $data = $this->memberModel->create($post);
            if ($data) {
                //修改nickname
                //TODO:关于nickname的规则
                $userInfo = array(
                    'nickname' => trim($data['nickname']),
                    C('SIDE_TABLE_DATA_FIELD') => $post['info']
                );
                $status = $this->memberService->userEdit($userId, NULL, NULL, NULL, TRUE, $userInfo, true);
                if ($status !== false) {
                    $this->success('更新成功', U('Member/Index/manageInfo'));
                } else {
                    $this->error(BService('Member')->getError());
                }
            } else {
                $this->error($this->memberModel->getError());
            }
        } else {
            $userInfo = $this->memberService->getMemberById(BaseAction::getVar('user_id'));
            $formModuleList = $this->memberService->getMemberModelField($userInfo['model_id'], $userInfo);
            $this->assign('formList', $formModuleList);
            $this->assign('user', $userInfo);
            $this->display();
        }
    }*/

    /**
     * 管理密码
     */
    public function managePassword() {
        if (IS_POST) {
            $post = $this->_post();
            $password = $post['password'];
            $newPassword = $post['new_password'];
            $confirmNewPassword = $post['confirm_new_password'];
            if (empty($password)) {
                $this->error('原密码不能为空');
            }
            if (empty($newPassword)) {
                $this->error('新密码不能为空');
            }
            if ($password === $newPassword) {
                $this->error('新密码不能与原密码相同');
            }
            if ($newPassword !== $confirmNewPassword) {
                $this->error('新密码两次输入不一致');
            }
            $data = $this->memberModel->create();
            if ($data) {
                $user = BaseAction::getVar('user');
                $status = BService('Member')->userEdit($user['user_id'], $password, $newPassword);
                if ($status) {
                    $this->success('修改密码成功', U('Member/Index/index'));
                } else {
                    $this->error(BService('Member')->getError(), U('Member/Index/managePassword'));
                }
            } else {
                $this->error($this->memberModel->getError());
            }
        } else {
            $this->assign('seo', seo('', '个人中心 - 修改密码'));
            $this->assign('current', 'managePassword');
            $this->display('index');
        }
    }

}

?>
