<?php

/**
 * 会员组Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-4-8
 * @updateTime 2013-4-8
 */
class MemberGroupManageAction extends AdminBaseAction {

    protected $memberGroupModel;

    function _initialize() {
        parent::_initialize();
        $this->memberGroupModel = D('MemberGroup');
    }

    /**
     * 会员组管理 
     */
    public function index() {
        $memberModel = D('Member');
        $data = $this->memberGroupModel->order(array('sort' => 'ASC', 'group_id' => 'ASC'))->select();
        foreach ($data as $k => $v) {
            //统计会员总数
            $data[$k]['count'] = $memberModel->where(array('group_id' => $v['group_id']))->count();
        }
        $this->assign('data', $data);
        $this->display();
    }

    /**
     * 添加会员组
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();

            //处理图标
            if (!empty($post['attachment_id'])) {
                //检测附件是否存在
                $attachment = BService('Attachment')->getAttachmentInfo($post['attachment_id']);
                if (!$attachment) {
                    $this->bpiAjaxReturn(false, '会员组图标出错');
                }
                $post['icon'] = $attachment['file_path'];
            }

            $data = $this->memberGroupModel->create($post);
            if ($data) {
                $id = BService('MemberGroup')->groupAdd($data);
                if ($id) {
                    BService('Attachment')->apiUpdate(C('ACCESS_TYPE.MEMBER_GROUP'), $id, $post['attachment_id']);
                    $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Member/MemberGroupManage/index') . '"'));
                } else {
                    $this->bpiAjaxReturn(false, '添加失败');
                }
            } else {
                $this->bpiAjaxReturn(false, $this->memberGroupModel->getError());
            }
        } else {
            $this->display('edit');
        }
    }

    /**
     * 删除会员组
     */
    public function delete() {
        if (IS_POST) {
            $groupId = $this->_post('group_id');
            if (empty($groupId)) {
                $this->bpiAjaxReturn(false, '请选择需要删除的会员组', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
            }
            foreach ($groupId as $gid) {
                $isSystem = $this->memberGroupModel->where('group_id = ' . intval($gid))->getField('is_system');
                if ($isSystem) {
                    $this->bpiAjaxReturn(false, '系统用户组不能删除', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
                }

                $this->memberGroupModel->where(array('group_id' => $gid))->delete();
                //删除图标
                BService('Attachment')->apiDelete(C('ACCESS_TYPE.MEMBER_GROUP'), $gid);
            }
            $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 编辑会员组
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();

            //处理图标
            if (!empty($post['attachment_id'])) {
                //检测附件是否存在
                $attachment = BService('Attachment')->getAttachmentInfo($post['attachment_id']);
                if (!$attachment) {
                    $this->bpiAjaxReturn(false, '会员组图标出错', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
                $post['icon'] = $attachment['file_path'];
            }

            $data = $this->memberGroupModel->create($post);
            if ($data) {
                if (FALSE !== BService('MemberGroup')->groupEdit($data)) {
                    BService('Attachment')->apiUpdate(C('ACCESS_TYPE.MEMBER_GROUP'), $data['group_id'], $post['attachment_id']);
                    $this->bpiAjaxReturn(true, '修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '修改失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $this->memberGroupModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $groupId = intval($this->_get('group_id'));
            $data = $this->memberGroupModel->where(array('group_id' => $groupId))->find();
            if (!$data) {
                $this->error('该会员组不存在！', U('MemberGroupManage/index'));
            }
            $this->assign('data', $data);
            $this->display();
        }
    }

    /**
     * 排序 
     */
    public function sort() {
        parent::saveSort($this->memberGroupModel, $this->_post('sort'), 'sort', true);
    }

}

?>
