<?php

/**
 * 会员Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 */
class MemberManageAction extends AdminBaseAction {

    protected $memberModel, $memberSerivce;

    //搜索类型

    const SERACH_TYPE_USER_NAME = 1;    // 会员名
    const SERACH_TYPE_USER_ID = 2;      // 会员ID
    const SERACH_TYPE_EMAIL = 3;        // 会员邮箱
    const SERACH_TYPE_REG_IP = 4;       // 会员注册IP
    const SERACH_TYPE_NICKNAME = 5;     // 会员昵称

    function _initialize() {
        parent::_initialize();
        $this->memberModel = D('Member');
        $this->memberSerivce = BService('Member');

        //会员组
        $memberGroupList = array();
        $group = FData('MemberGroup');
        foreach ($group as $value) {
            $memberGroupList[$value['group_id']] = $value['name'];
        }

        //会员模型
        $modelMemberList = D('Model')->getModelByType(C('MODEL_TYPE.MEMBER'), 1);

        //搜索类型
        $searchType = array(
            self::SERACH_TYPE_USER_NAME => '会员名',
            self::SERACH_TYPE_USER_ID => '会员ID',
            self::SERACH_TYPE_EMAIL => '会员邮箱',
            self::SERACH_TYPE_REG_IP => '会员注册IP',
            self::SERACH_TYPE_NICKNAME => '会员昵称'
        );

        $this->assign('memberGroupList', $memberGroupList);
        $this->assign('modelMemberList', $modelMemberList);
        $this->assign('searchType', $searchType);
    }

    /**
     * 会员管理
     */
    public function index() {
        $this->_showList();
    }

    /**
     * 会员设置
     */
    public function setting() {
        $Module = M('Module');
        if (IS_POST) {
            $setting = $this->_post('setting');
            $data['setting'] = serialize($setting);
            if ($Module->create()) {
                $result = $Module->where(array('module' => 'Member'))->save($data);
                if ($result !== false) {
                    BService('Cache')->memberCache();
                    $this->bpiAjaxReturn(true, '更新成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '更新失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $Module->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $setting = BService('Module')->getModuleSetting('Member');
            $this->assign('setting', $setting);
            $this->display();
        }
    }

    /**
     * 添加会员
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();
            //更改积分同步更改所在会员组
            if ($post['sys_chg_group']) {
                $group = $this->memberSerivce->getUserGroupByPoint($post['point']);
                $post['group_id'] = $group['group_id'];
            }
            $data = $this->memberModel->create($post);
            if ($data) {
                // 副表字段名字调整
                $data[C('SIDE_TABLE_DATA_FIELD')] = $post['info'];
                $userId = $this->memberSerivce->userRegister($data['user_name'], $data['password'], $data['email'], $data);
                if ($userId > 0) {
                    //添加头像
                    if ($post['avatar_id']) {
                        $this->memberSerivce->saveUserAvatarByAdmin($userId, $post['avatar_id']);
                    }
                    $this->bpiAjaxReturn(true, '添加会员成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Member/MemberManage/index') . '"'));
                    //添加扩展字段
//                    $status = $this->memberSerivce->saveMemberModelField($userId, $post['info']);
//                    if ($status) {
//                    } else {
//                        $this->bpiAjaxReturn(false, '添加会员成功，但添加扩展信息失败<br/>错误信息：' . $this->memberSerivce->getError(), array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Member/MemberManage/index') . '"'));
//                    }
                } else {
                    $error = $this->memberSerivce->getError();
                    $info = empty($error) ? '会员添加失败' : $error;
                    $this->bpiAjaxReturn(false, $info);
                }
            }
            $error = $this->memberModel->getError();
            $info = empty($error) ? '会员添加失败' : $error;
            $this->bpiAjaxReturn(false, $info);
        } else {
            $setting = BService('Module')->getModuleSetting('Member');
            $data = array(
                'point' => $setting['defualt_point'],
                'group_id' => $setting['default_group'],
                'model_id' => $setting['default_model_id']
            );
            $modelFieldList = $this->memberSerivce->getMemberModelField($setting['default_model_id']);
            $this->assign('data', $data);
            $this->assign('modelFieldList', $modelFieldList);
            $this->display('edit');
        }
    }

    /**
     * 编辑会员
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();
            //更改积分同步更改所在会员组
            if ($post['sys_chg_group']) {
                $group = $this->memberSerivce->getUserGroupByPoint($post['point']);
                $post['group_id'] = $group['group_id'];
            }
            $data = $this->memberModel->create($post);
            if ($data) {
                // 副表字段名字调整
                $data[C('SIDE_TABLE_DATA_FIELD')] = $post['info'];
                if ($this->memberSerivce->userEdit($data['user_id'], '', $data['password'], $post['email'], true, $data)) {
                    //删除头像
                    if ($post['del_avatar']) {
                        $this->memberSerivce->userDeleteAvatar($post['user_id']);
                    } else if ($post['avatar_id']) {
                        $this->memberSerivce->saveUserAvatarByAdmin($data['user_id'], $post['avatar_id']);
                    }
//                    $userInfo = $this->memberSerivce->getMemberById($data['user_id']);
//                    if ($userInfo) {
//                    //保存扩展字段信息
//                        $status = $this->memberSerivce->saveMemberModelField($data['user_id'], $post['info']);
//                        //删除冗余信息
//                        if ($post['model_id'] != $userInfo['model_id']) {
//                            BService('Member')->deleteMemberModelField($data['user_id'], $userInfo['model_id']);
//                        }
//                    }
                    $this->bpiAjaxReturn(true, '会员修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }

                $error = BService('Member')->getError();
                $info = empty($error) ? '会员修改失败' : $error;
                $this->bpiAjaxReturn(false, $info, array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            } else {
                $this->bpiAjaxReturn(false, $this->memberModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $userInfo = $this->memberSerivce->getMemberById($this->_get('user_id'));
            if (empty($userInfo)) {
                $this->error('该会员不存在！');
            }

            $modelFieldList = $this->memberSerivce->getMemberModelField($userInfo['model_id'], $userInfo);
            $this->assign('modelFieldList', $modelFieldList);

            $this->assign('data', $userInfo);
            $this->display();
        }
    }

    /**
     * 删除会员
     */
    public function delete() {
        if (IS_POST) {
            $userIds = $this->_post('user_id');
            if (empty($userIds)) {
                $this->bpiAjaxReturn(false, '请选择需要删除的会员', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
            }
            foreach ($userIds as $uid) {
                $status = BService('Member')->userDelete($uid);
                if (!$status) {
                    $error = BService('Member')->getError();
                    $info = empty($error) ? '会员ID ' . $uid . ' 删除失败' : $error;
                    $this->bpiAjaxReturn(false, $info, array(), C('OPERATE_TYPE.OPERATE_DELETE'));
                }
            }
            $this->bpiAjaxReturn(true, '删除会员成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
    }

    /**
     * 禁用会员
     */
    public function lock() {
        if (IS_POST) {
            $userId = $this->_post('user_id');
            if (empty($userId)) {
                $this->bpiAjaxReturn(false, '请选择需要禁用的会员', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
            foreach ($userId as $uid) {
                $modelid = $this->memberModel->where(array('user_id' => $uid))->getField('model_id');
                if ($modelid) {
                    $this->memberModel->where(array('user_id' => $uid))->save(array('status' => 0));
                }
            }
            $this->bpiAjaxReturn(true, '会员禁用成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }
    }

    /**
     * 审核通过会员
     */
    public function unlock() {
        if (IS_POST) {
            $userId = $this->_post('user_id');
            if (empty($userId)) {
                $this->bpiAjaxReturn(false, '请选择需要审核的会员', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
            foreach ($userId as $uid) {
                $modelid = $this->memberModel->where(array('user_id' => $uid))->getField('model_id');
                if ($modelid) {
                    $this->memberModel->where(array('user_id' => $uid))->save(array('status' => 1));
                }
            }
            $this->bpiAjaxReturn(true, '会员审核成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
        }
    }

    /**
     * 获取未审核会员列表
     */
    public function check() {
        $extPost = array(
            'search' => 1,
            'status' => 0,
        );
        self::_showList($extPost);
    }

    /**
     * 显示会员列表私有方法
     * @param type $extPost
     */
    private function _showList($extPost = array()) {
        $where = array();

        $get = array_merge($extPost, $this->_get());
        if ($get['search'] == 1) {
            //注册时间段
            $start = $get['start_time'];
            $end = $get['end_time'];
            if (!empty($start) || !empty($end)) {
                $startTime = empty($start) ? '' : $start;
                $endTime = empty($end) ? date('Y-m-d', time()) : $end;
                //开始时间
                $whereStartTime = strtotime($startTime) ? strtotime($startTime) : 0;
                //结束时间
                $whereEndTime = strtotime($endTime) ? (strtotime($endTime) + 86400) : 0;
                //开始时间大于结束时间，置换变量
                if ($whereStartTime > $whereEndTime) {
                    $tmp = $whereStartTime;
                    $whereStartTime = $whereEndTime;
                    $whereEndTime = $tmp;
                }
                //时间范围
                if ($whereStartTime) {
                    $where['reg_date'] = array('BETWEEN', array($whereStartTime, $whereEndTime));
                    $this->assign('startTime', date('Y-m-d', $whereStartTime));
                    $this->assign('endTime', date('Y-m-d', $whereEndTime));
                }
            }

            //状态
            $status = intval($get['status']);
            if ($status >= 0) {
                $where['status'] = $status == 0 ? 0 : 1;
                $this->assign('status', $status);
            }

            //会员组
            $groupId = intval($get['group_id']);
            if ($groupId > 0) {
                $where['group_id'] = $groupId;
                $this->assign('groupId', $groupId);
            }

            //会员模型
            $modelId = intval($get['model_id']);
            if ($modelId > 0) {
                $where['model_id'] = $modelId;
                $this->assign('modelId', $modelId);
            }

            //关键字
            $keyword = $get['keyword'];
            if (!empty($keyword)) {
                $type = intval($get['type']);
                switch ($type) {
                    case self::SERACH_TYPE_USER_NAME:
                        $where['user_name'] = array('LIKE', '%' . $keyword . '%');
                        break;
                    case self::SERACH_TYPE_USER_ID:
                        $where['user_id'] = $keyword;
                        break;
                    case self::SERACH_TYPE_EMAIL:
                        $where['email'] = array('LIKE', '%' . $keyword . '%');
                        break;
                    case self::SERACH_TYPE_REG_IP:
                        $where['reg_ip'] = $keyword;
                        break;
                    case self::SERACH_TYPE_NICKNAME:
                        $where['nickname'] = array('LIKE', '%' . $keyword . '%');
                        break;
                    default:
                        $where['user_name'] = array('LIKE', '%' . $keyword . '%');
                        break;
                }
                $this->assign('type', $type);
                $this->assign('keyword', $keyword);
            }
        }

        $count = $this->memberModel->where($where)->count();
        $page = page($count);
        $data = $this->memberModel->where($where)->limit($page->firstRow . ',' . $page->listRows)->order('user_id DESC')->select();
        $this->assign('data', $data);
        $this->assign('page', $page->show());

        $this->display('index');
    }

    /**
     * 根据积分获取会员组ID
     */
    public function public_getGroupByPoint() {
        $point = intval($this->_get('point'));
        $group = BService('Member')->getUserGroupByPoint($point);
        $this->ajaxReturn(array('groupId' => $group['group_id']));
    }

    /**
     * 获取会员模型字段
     */
    public function public_getMemberModelField() {
        $userId = intval($this->_get('user_id'));
        $modelId = intval($this->_get('model_id'));
        $userInfo = BService('Member')->getMemberById($userId);
        $modelFieldList = BService('Member')->getMemberModelField($modelId, $userInfo);
        $this->ajaxReturn(array('data' => $modelFieldList));
    }

}

?>
