<?php

/**
 * 通用通行证Service
 * @author     Tinpont
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-9-3
 * @updateTime 2013-9-3
 */
class PassportAction extends MemberBaseAction {

    protected $memberConfig, $memberModel, $memberService;

    public function _initialize() {
        parent::_initialize(true);
        $this->memberConfig = FData('MemberConfig', 'Member');
        $this->memberModel = D('Member');
        $this->memberService = BService('Member');
    }

    /**
     * 会员注册
     */
    public function register() {
        parent::register('Passport:register');
    }

    /**
     * 登录验证
     */
    public function checkLogin() {
        $post = $this->_post();
        $userName = trim($post['user_name']);
        $password = $post['password'];

        $effectiveTime = $post['effective_time'] ? C('USER_DEFAULT_EFFECTIVE_TIME') : 0;
        if (empty($userName) || empty($password)) {
            $this->error('请填写用户名或密码');
        }

        //是否开启登录验证码
        /* if ($this->memberConfig['is_open_verification']) {
          //验证码
          $verify = $post['verify'];
          if (!BService('Verify')->checkVerify($verify, C('VERIFY_TYPE.MEMBER_LOGIN'))) {
          $this->error('验证码错误');
          }
          } */
        parent::userLoginMain(true, $userName, $password, $effectiveTime);
    }

    /**
     * 登录界面
     */
    public function login() {
        if (BaseAction::getVar('user_id')) {
            $this->redirect(U('Member/Index/index'));
        } else {
            $get = $this->_get();
            if (isset($get['referer']) && $get['referer']) {
                $httpReferer = urldecode(bpiHtmlspecialcharsDecode($get['referer']));
            } else {
                $httpReferer = $_SERVER['HTTP_REFERER'];
            }
            //TODO: 是否需要严格检查 $httpReferer 是否为本站
            cookie('http_referer', $httpReferer, 600);
            $this->assign('seo', seo('', '用户登录'));
            $this->display('Passport:login');
        }
    }

    /**
     * 会员登出
     */
    public function logout() {
        BService('Member')->userLogout();
        //TODO:注销一些session
        $this->redirect(U('Index/Index/index'));
    }

    /**
     * 验证邮箱
     */
    public function verifyEmail() {
        if (BService('Member')->verifyToken(C('MEMBER_TOKEN_TYPE.ACTIVE_ACCOUNT'), $this->_get('token'))) {
            $this->success('邮箱验证成功', SITE_URL);
        } else {
            $this->error('验证链接失效', SITE_URL);
        }
    }

    /**
     * 忘记密码页面
     */
    public function forgetPassword() {
        if (IS_POST) {
            $post = $this->_post();
            if (isset($post['email'])) {
                if ($this->memberService->sendForgetEmail($post['user_id'], $post['email'])) {
                    $this->success('重置密码的信息已经发到您的邮箱了，请注意查收', U('Member/Passport/login'));
                    exit;
                } else {
                    $this->error($this->memberService->getError());
                }
            } else {
                $userInfo = $this->memberService->getForgetUserInfo($post['identifier']);
                if ($userInfo) {
                    $this->assign($userInfo);
                } else {
                    $this->error($this->memberService->getError());
                }
            }
        }
        $this->assign('seo', seo('', '忘记密码'));
        $this->display('Passport:forgetPassword');
    }

    /**
     * 重置密码
     */
    public function resetPassword() {
        $memberService = BService('Member');
        if (IS_POST) {
            $post = $this->_post();

            // 验证密码规范
            if (empty($post['password'])) {
                $this->error('新密码不能为空');
            }

            if ($post['password'] !== $post['re_password']) {
                $this->error('两次输入的密码不一致');
            }

            // 验证TOKEN
            $userId = $memberService->verifyToken(C('MEMBER_TOKEN_TYPE.RESET_PASSWORD'), $this->_post('token'));
            if ($userId) {
                if ($memberService->userEdit($userId, '', $post['password'], NULL, TRUE)) {
                    $this->success('密码修改成功', U('Member/Passport/login'));
                    exit;
                } else {
                    $this->error('密码修改失败');
                }
            } else {
                $this->error('链接已失效', SITE_URL);
            }
        } else {
            $userId = $memberService->verifyToken(C('MEMBER_TOKEN_TYPE.RESET_PASSWORD'), $this->_get('token'), FALSE);
            if ($userId) {
                $this->assign('seo', seo('', '重置密码'));
                $this->display('Passport:resetPassword');
                exit;
            }
        }
    }

}

?>
