<?php

// +----------------------------------------------------------------------
// | TOPThink [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://topthink.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 杨维杰 <zuojiazi.cn@gmail.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
// | SinaSDK.class.php 2013-03-01
// +----------------------------------------------------------------------

class DiandianSDK extends ThinkOauth {

    /**
     * 获取requestCode的api接口
     * @var string
     */
    protected $GetRequestCodeURL = 'https://api.diandian.com/oauth/authorize';

    /**
     * 获取access_token的api接口
     * @var string
     */
    protected $GetAccessTokenURL = 'https://api.diandian.com/oauth/token';

    /**
     * API根路径
     * @var string
     */
    protected $ApiBase = 'https://api.diandian.com/v1/';

    /**
     * 组装接口调用参数 并调用接口
     * @param  string $api    点点网API
     * @param  string $param  调用API的额外参数
     * @param  string $method HTTP请求方法 默认为GET
     * @return json
     */
    public function call($api, $param = '', $method = 'GET', $multi = false) {
        /* 点点网调用公共参数 */
        $params = array(
            'access_token' => $this->Token['access_token'],
        );

        $data = $this->http($this->url($api, '.json'), $this->param($params, $param), $method);
        return json_decode($data, true);
    }

    /**
     * 解析access_token方法请求后的返回值
     * @param string $result 获取access_token的方法的返回值
     */
    protected function parseToken($result, $extend) {
        $data = json_decode($result, true);
        if ($data['access_token'] && $data['expires_in'] && $data['token_type'] && $data['uid']) {
            $data['unique_id'] = $data['uid'];
            unset($data['uid']);
            return $data;
        } else {
            throw new Exception("获取点点网ACCESS_TOKEN出错：{$data['error']}");
        }
    }

    /**
     * 获取当前授权应用的openid
     * @return string
     */
    public function uniqueId() {
        $data = $this->Token;
        if (isset($data['unique_id'])) {
            return $data['unique_id'];
        } else {
            throw new Exception('没有获取到点点网用户ID！');
        }
    }

    /**
     * 发送微博
     * @param type $sendInfo        微博相关内容
     * @return boolean              成功返回TRUE，失败返回错误信息
     */
    public function sendWeibo($sendInfo) {
        return TRUE;
    }

    /**
     * 获取用户信息
     * @return type     成功返回用户信息，失败抛出错误
     */
    public function userInfo() {
        $data = $this->call('user/info');
        if (!empty($data['meta']['status']) && $data['meta']['status'] == 200) {
            $userInfo = array(
                'type' => 'DIANDIAN',
                'name' => $data['response']['name'],
                'nick' => $data['response']['name'],
                'avatar' => "https://api.diandian.com/v1/blog/{$data['response']['blogs'][0]['blogUuid']}/avatar/144"
            );
            return $userInfo;
        } else {
            throw_exception("获取点点用户信息失败：{$data}");
        }
    }

}
