<?php

// +----------------------------------------------------------------------
// | TOPThink [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://topthink.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi.cn@gmail.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
// | GithubSDK.class.php 2013-02-26
// +----------------------------------------------------------------------

class GithubSDK extends ThinkOauth {

    /**
     * 获取requestCode的api接口
     * @var string
     */
    protected $GetRequestCodeURL = 'https://github.com/login/oauth/authorize';

    /**
     * 获取access_token的api接口
     * @var string
     */
    protected $GetAccessTokenURL = 'https://github.com/login/oauth/access_token';

    /**
     * API根路径
     * @var string
     */
    protected $ApiBase = 'https://api.github.com/';

    /**
     * 组装接口调用参数 并调用接口
     * @param  string $api    微博API
     * @param  string $param  调用API的额外参数
     * @param  string $method HTTP请求方法 默认为GET
     * @return json
     */
    public function call($api, $param = '', $method = 'GET', $multi = false) {
        /* Github 调用公共参数 */
        $params = array();
        $header = array("Authorization: bearer {$this->Token['access_token']}");

        $data = $this->http($this->url($api), $this->param($params, $param), $method, $header);
        return json_decode($data, true);
    }

    /**
     * 解析access_token方法请求后的返回值
     * @param string $result 获取access_token的方法的返回值
     */
    protected function parseToken($result, $extend) {
        $data = array();
        parse_str($result, $data);
        if ($data['access_token'] && $data['token_type']) {
            $data['unique_id'] = $this->uniqueId();
            $this->Token = $data;
            return $data;
        } else {
            throw new Exception("获取 Github ACCESS_TOKEN出错：未知错误");
        }
    }

    /**
     * 获取当前授权应用的openid
     * @return string
     */
    public function uniqueId() {
        if (isset($this->Token['unique_id'])) {
            return $this->Token['unique_id'];
        }

        $data = $this->call('user');
        if (!empty($data['id'])) {
            return $data['id'];
        } else {
            throw new Exception('没有获取到 Github 用户ID！');
        }
    }

    /**
     * 发送微博
     * @param type $sendInfo        微博相关内容
     * @return boolean              成功返回TRUE，失败返回错误信息
     */
    public function sendWeibo($sendInfo) {
        return TRUE;
    }

    /**
     * 获取用户信息
     * @return type     成功返回用户信息，失败抛出错误
     */
    public function userInfo() {
        $data = $this->call('user');
        if (empty($data['code'])) {
            $userInfo = array(
                'type' => 'GITHUB',
                'name' => $data['login'],
                'nick' => $data['name'],
                'avatar' => $data['avatar_url']
            );
            return $userInfo;
        } else {
            throw_exception("获取Github用户信息失败：{$data}");
        }
    }

}
