<?php

// +----------------------------------------------------------------------
// | TOPThink [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://topthink.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi.cn@gmail.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
// | QqSDK.class.php 2013-02-25
// +----------------------------------------------------------------------

class QqSDK extends ThinkOauth {

    /**
     * 获取requestCode的api接口
     * @var string
     */
    protected $GetRequestCodeURL = 'https://graph.qq.com/oauth2.0/authorize';

    /**
     * 获取access_token的api接口
     * @var string
     */
    protected $GetAccessTokenURL = 'https://graph.qq.com/oauth2.0/token';

    /**
     * 获取request_code的额外参数,可在配置中修改 URL查询字符串格式
     * @var srting
     */
    protected $Authorize = 'scope=get_user_info,add_share,check_page_fans,add_weibo,add_t,del_t,add_pic_t,get_repost_list, get_other_info,get_fanslist,get_idollist,add_idol,del_idol,get_info';

    /**
     * API根路径
     * @var string
     */
    protected $ApiBase = 'https://graph.qq.com/';

    /**
     * 组装接口调用参数 并调用接口
     * @param  string $api    微博API
     * @param  string $param  调用API的额外参数
     * @param  string $method HTTP请求方法 默认为GET
     * @return json
     */
    public function call($api, $param = '', $method = 'GET', $multi = false) {
        /* 腾讯QQ调用公共参数 */
        $params = array(
            'oauth_consumer_key' => $this->AppKey,
            'access_token' => $this->Token['access_token'],
            'openid' => $this->uniqueId(),
            'format' => 'json'
        );

        $data = $this->http($this->url($api), $this->param($params, $param), $method);
        return json_decode($data, true);
    }

    /**
     * 解析access_token方法请求后的返回值
     * @param string $result 获取access_token的方法的返回值
     */
    protected function parseToken($result, $extend) {
        parse_str($result, $data);
        if ($data['access_token'] && $data['expires_in']) {
            $data['unique_id'] = $this->uniqueId();
            $this->Token = $data;
            return $data;
        } else {
            throw new Exception("获取腾讯QQ ACCESS_TOKEN 出错：{$result}");
        }
    }

    /**
     * 获取当前授权应用的openid
     * @return string
     */
    public function uniqueId() {
        $data = $this->Token;
        if (isset($data['unique_id'])) {
            return $data['unique_id'];
        } else if ($data['access_token']) {
            $data = $this->http($this->url('oauth2.0/me'), array('access_token' => $data['access_token']));
            $data = json_decode(trim(substr($data, 9), " );\n"), true);
            if (isset($data['openid'])) {
                return $data['openid'];
            } else {
                throw new Exception("获取用户openid出错：{$data['error_description']}");
            }
        } else {
            throw new Exception('没有获取到openid！');
        }
    }

    /**
     * 发送微博
     * @param type $sendInfo        微博相关内容
     * @return boolean              成功返回TRUE，失败返回错误信息
     */
    public function sendWeibo($sendInfo) {
        $param = array(
            'title' => $sendInfo['title'],
            'url' => $sendInfo['url'],
            'summary' => $sendInfo['content'],
            'images' => $sendInfo['pic_url'],
            'site' => $sendInfo['site'],
            'fromurl' => $sendInfo['from_url'],
        );
        $data = $this->call('share/add_share', $param, 'POST');

        if ($data['ret'] == 0) {
            return true;
        } else {
            return $data;
        }
    }

    /**
     * 获取用户信息
     * @return type     成功返回用户信息，失败抛出错误
     */
    public function userInfo() {
        $data = $this->call('user/get_user_info');
        if ($data['ret'] == 0) {
            $userInfo = array(
                'type' => 'QQ',
                'name' => $data['nickname'],
                'nick' => $data['nickname'],
                'avatar' => $data['figureurl_2']
            );
            return $userInfo;
        } else {
            throw_exception("获取腾讯QQ用户信息失败：{$data['msg']}");
        }
    }

}
