<?php

// +----------------------------------------------------------------------
// | TOPThink [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://topthink.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi.cn@gmail.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
// | RenrenSDK.class.php 2013-02-25
// +----------------------------------------------------------------------

class RenrenSDK extends ThinkOauth {

    /**
     * 获取requestCode的api接口
     * @var string
     */
    protected $GetRequestCodeURL = 'https://graph.renren.com/oauth/authorize';

    /**
     * 获取access_token的api接口
     * @var string
     */
    protected $GetAccessTokenURL = 'https://graph.renren.com/oauth/token';

    /**
     * API根路径
     * @var string
     */
    protected $ApiBase = 'http://api.renren.com/restserver.do';

    /**
     * 组装接口调用参数 并调用接口
     * @param  string $api    微博API
     * @param  string $param  调用API的额外参数
     * @param  string $method HTTP请求方法 默认为GET
     * @return json
     */
    public function call($api, $param = '', $method = 'POST', $multi = false) {
        /* 人人网调用公共参数 */
        $params = array(
            'method' => $api,
            'access_token' => $this->Token['access_token'],
            'v' => '1.0',
            'format' => 'json',
        );

        $data = $this->http($this->url(''), $this->param($params, $param), $method);
        return json_decode($data, true);
    }

    /**
     * 合并默认参数和额外参数
     * @param array $params  默认参数
     * @param array/string $param 额外参数
     * @return array:
     */
    protected function param($params, $param) {
        $params = parent::param($params, $param);

        /* 签名 */
        ksort($params);
        $param = array();
        foreach ($params as $key => $value) {
            $param[] = "{$key}={$value}";
        }
        $sign = implode('', $param) . $this->AppSecret;
        $params['sig'] = md5($sign);

        return $params;
    }

    /**
     * 解析access_token方法请求后的返回值
     * @param string $result 获取access_token的方法的返回值
     */
    protected function parseToken($result, $extend) {
        $data = json_decode($result, true);
        if ($data['access_token'] && $data['expires_in'] && $data['refresh_token'] && $data['user']['id']) {
            $data['unique_id'] = $data['user']['id'];
            unset($data['user']);
            return $data;
        } else {
            throw new Exception("获取人人网ACCESS_TOKEN出错：{$data['error_description']}");
        }
    }

    /**
     * 获取当前授权应用的openid
     * @return string
     */
    public function uniqueId() {
        $data = $this->Token;
        if (!empty($data['unique_id'])) {
            return $data['unique_id'];
        } else {
            throw new Exception('没有获取到人人网用户ID！');
        }
    }

    /**
     * 发送微博
     * @param type $sendInfo        微博相关内容
     * @return boolean              成功返回TRUE，失败返回错误信息
     */
    public function sendWeibo($sendInfo) {
        $param = array(
            'url' => $sendInfo['url'],
            'comment' => $sendInfo['content'],
            'type' => '6',
        );
        $data = $this->call('share.share', $param, 'POST');
        if ($data['id']) {
            return true;
        } else {
            return $data;
        }
    }

    /**
     * 获取用户信息
     * @return type     成功返回用户信息，失败抛出错误
     */
    public function userInfo() {
        $data = $this->call('users.getInfo');
        if (!isset($data['error_code'])) {
            $userInfo = array(
                'type' => 'RENREN',
                'name' => $data[0]['name'],
                'nick' => $data[0]['name'],
                'avatar' => $data[0]['headurl']
            );
            return $userInfo;
        } else {
            throw_exception("获取人人网用户信息失败：{$data['error_msg']}");
        }
    }

}
