<?php

// +----------------------------------------------------------------------
// | TOPThink [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://topthink.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi.cn@gmail.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
// | SinaSDK.class.php 2013-02-25
// +----------------------------------------------------------------------

class SinaSDK extends ThinkOauth {

    /**
     * 获取requestCode的api接口
     * @var string
     */
    protected $GetRequestCodeURL = 'https://api.weibo.com/oauth2/authorize';

    /**
     * 获取access_token的api接口
     * @var string
     */
    protected $GetAccessTokenURL = 'https://api.weibo.com/oauth2/access_token';

    /**
     * 获取request_code的额外参数,可在配置中修改 URL查询字符串格式
     * @var srting
     */
    protected $Authorize = 'scope=all';

    /**
     * API根路径
     * @var string
     */
    protected $ApiBase = 'https://api.weibo.com/2/';

    /**
     * 组装接口调用参数 并调用接口
     * @param  string $api    微博API
     * @param  string $param  调用API的额外参数
     * @param  string $method HTTP请求方法 默认为GET
     * @return json
     */
    public function call($api, $param = '', $method = 'GET', $multi = false) {
        /* 新浪微博调用公共参数 */
        $params = array(
            'access_token' => $this->Token['access_token'],
        );

        $vars = $this->param($params, $param);
        $data = $this->http($this->url($api, '.json'), $vars, $method, array(), $multi);
        return json_decode($data, true);
    }

    /**
     * 解析access_token方法请求后的返回值
     * @param string $result 获取access_token的方法的返回值
     */
    protected function parseToken($result, $extend) {
        $data = json_decode($result, true);
        if ($data['access_token'] && $data['expires_in'] && $data['remind_in'] && $data['uid']) {
            $data['unique_id'] = $data['uid'];
            unset($data['uid']);
            return $data;
        }
        else {
            throw new Exception("获取新浪微博ACCESS_TOKEN出错：{$data['error']}");
        }
    }

    /**
     * 获取当前授权应用的openid
     * @return string
     */
    public function uniqueId() {
        $data = $this->Token;
        if (isset($data['unique_id'])) {
            return $data['unique_id'];
        } else {
            throw new Exception('没有获取到新浪微博用户ID！');
        }
    }

    /**
     * 发送微博
     * @param type $sendInfo        微博相关内容
     * @return boolean              成功返回TRUE，失败返回错误信息
     */
    public function sendWeibo($sendInfo) {
        $param = array(
            'status' => $sendInfo['content'],
            'url' => $sendInfo['pic_url']
        );
        if ($param['url']) {
            $api = 'statuses/upload_url_text';
        } else {
            $api = 'statuses/update';
        }
        $data = $this->call($api, $param, 'POST');
        if ($data['id']) {
            return true;
        } else {
            return $data;
        }
    }

    /**
     * 获取用户信息
     * @return type     成功返回用户信息，失败抛出错误
     */
    public function userInfo() {
        $data = $this->call('users/show', "uid={$this->uniqueId()}");
        if ($data['error_code'] == 0) {
            $userInfo = array(
                'type' => 'SINA',
                'name' => $data['name'],
                'nick' => $data['screen_name'],
                'avatar' => $data['avatar_large']
            );
            return $userInfo;
        } else {
            throw_exception("获取新浪微博用户信息失败：{$data['error']}");
        }
    }

}