<?php

// +----------------------------------------------------------------------
// | TOPThink [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://topthink.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi.cn@gmail.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
// | T163SDK.class.php 2013-02-25
// +----------------------------------------------------------------------

class T163SDK extends ThinkOauth {

    /**
     * 获取requestCode的api接口
     * @var string
     */
    protected $GetRequestCodeURL = 'https://api.t.163.com/oauth2/authorize';

    /**
     * 获取access_token的api接口
     * @var string
     */
    protected $GetAccessTokenURL = 'https://api.t.163.com/oauth2/access_token';

    /**
     * API根路径
     * @var string
     */
    protected $ApiBase = 'https://api.t.163.com/';

    /**
     * 组装接口调用参数 并调用接口
     * @param  string $api    微博API
     * @param  string $param  调用API的额外参数
     * @param  string $method HTTP请求方法 默认为GET
     * @return json
     */
    public function call($api, $param = '', $method = 'GET', $multi = false) {
        /* 新浪微博调用公共参数 */
        $params = array(
            'oauth_token' => $this->Token['access_token'],
        );



        $data = $this->http($this->url($api, '.json'), $this->param($params, $param), $method);
        return json_decode($data, true);
    }

    /**
     * 解析access_token方法请求后的返回值
     * @param string $result 获取access_token的方法的返回值
     */
    protected function parseToken($result, $extend) {
        $data = json_decode($result, true);
        if ($data['uid'] && $data['access_token'] && $data['expires_in'] && $data['refresh_token']) {
            $data['unique_id'] = $data['uid'];
            unset($data['uid']);
            return $data;
        } else {
            throw new Exception("获取网易微博ACCESS_TOKEN出错：{$data['error']}");
        }
    }

    /**
     * 获取当前授权应用的openid
     * @return string
     */
    public function uniqueId() {
        if (isset($this->Token['unique_id'])) {
            return $this->Token['unique_id'];
        }

        $data = $this->call('users/show');
        if (!empty($data['id'])) {
            return $data['id'];
        } else {
            throw new Exception('没有获取到网易微博用户ID！');
        }
    }

    /**
     * 发送微博
     * @param type $sendInfo        微博相关内容
     * @return boolean              成功返回TRUE，失败返回错误信息
     */
    public function sendWeibo($sendInfo) {
        $param = array(
            'status' => $sendInfo['content'] . $sendInfo['pic_url'],
        );
        $data = $this->call('statuses/update', $param, 'POST');
        if ($data['id']) {
            return true;
        } else {
            return $data;
        }
    }

    /**
     * 获取用户信息
     * @return type     成功返回用户信息，失败抛出错误
     */
    public function userInfo() {
        $data = $this->call('users/show');
        if ($data['error_code'] == 0) {
            $userInfo = array(
                'type' => 'T163',
                'name' => $data['name'],
                'nick' => $data['screen_name'],
                'avatar' => str_replace('w=48&h=48', 'w=180&h=180', $data['profile_image_url'])
            );
            return $userInfo;
        } else {
            throw_exception("获取网易微博用户信息失败：{$data['error']}");
        }
    }

}
