<?php

// +----------------------------------------------------------------------
// | TOPThink [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://topthink.com All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi.cn@gmail.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------
// | ThinkOauth.class.php 2013-02-25
// +----------------------------------------------------------------------

abstract class ThinkOauth {

    /**
     * oauth版本
     * @var string
     */
    protected $Version = '2.0';

    /**
     * 申请应用时分配的app_key
     * @var string
     */
    protected $AppKey = '';

    /**
     * 申请应用时分配的 app_secret
     * @var string
     */
    protected $AppSecret = '';

    /**
     * 授权类型 response_type 目前只能为code
     * @var string
     */
    protected $ResponseType = 'code';

    /**
     * grant_type 目前只能为 authorization_code
     * @var string
     */
    protected $GrantType = 'authorization_code';

    /**
     * 回调页面URL  可以通过配置文件配置
     * @var string
     */
    protected $Callback = '';

    /**
     * 获取request_code的额外参数 URL查询字符串格式
     * @var srting
     */
    protected $Authorize = '';

    /**
     * 获取request_code请求的URL
     * @var string
     */
    protected $GetRequestCodeURL = '';

    /**
     * 获取access_token请求的URL
     * @var string
     */
    protected $GetAccessTokenURL = '';

    /**
     * API根路径
     * @var string
     */
    protected $ApiBase = '';

    /**
     * 授权后获取到的TOKEN信息
     * @var array
     */
    protected $Token = null;

    /**
     * 调用接口类型
     * @var string
     */
    private $Type = '';

    /**
     * 构造方法，配置应用信息
     * @param array $token
     */
    public function __construct($token = null) {
        //设置SDK类型
        $class = get_class($this);
        $this->Type = strtoupper(substr($class, 0, strlen($class) - 3));
        $lowerType = strtolower($this->Type);

        // 自动根据当前登陆用户获取TOKEN
        if (empty($token)) {
            if (($userId = intval(BaseAction::getVar('user_id')))) {
                $token = D('Connect')->where(array('user_id' => $userId, 'type' => $lowerType))->find();
            }
        }

        $this->memberConfig = FData('MemberConfig', 'Member');
        $connect = $this->memberConfig['connect'];

        $callback = bpiHtmlspecialcharsDecode($connect['callback']) . $lowerType;
        $config = $connect[$lowerType];
        if (empty($config['appkey']) || empty($config['appsecret'])) {
            throw new Exception('请配置您申请的APP_KEY和APP_SECRET');
        } else {
            $this->AppKey = $config['appkey'];
            $this->AppSecret = $config['appsecret'];
            $this->Callbackurl = $callback;
            $this->Token = $token; //设置获取到的TOKEN
        }
    }

    /**
     * 取得Oauth实例
     * @static
     * @return mixed 返回Oauth
     */
    public static function getInstance($type, $token = null) {
        $name = ucfirst(strtolower($type)) . 'SDK';
        require_once "ContentSDK/{$name}.class.php";
        if (class_exists($name)) {
            return new $name($token);
        } else {
            halt(L('_CLASS_NOT_EXIST_') . ':' . $name);
        }
    }

    /**
     * 初始化配置
     */
    private function config() {
        $config = $this->memberConfig['connect'][$this->Type];
        if (!empty($config['AUTHORIZE']))
            $this->Authorize = $config['AUTHORIZE'];
        if (!empty($this->Callbackurl))
            $this->Callback = $this->Callbackurl;
        else
            throw new Exception('请配置回调页面地址');
    }

    /**
     * 请求code
     */
    public function getRequestCodeURL() {
        $this->config();
        //Oauth 标准参数
        $params = array(
            'client_id' => $this->AppKey,
            'redirect_uri' => $this->Callback,
            'response_type' => $this->ResponseType,
        );

        //获取额外参数
        if ($this->Authorize) {
            parse_str($this->Authorize, $_param);
            if (is_array($_param)) {
                $params = array_merge($params, $_param);
            } else {
                throw new Exception('AUTHORIZE配置不正确！');
            }
        }
        return $this->GetRequestCodeURL . '?' . http_build_query($params);
    }

    /**
     * 获取access_token
     * @param string $code 上一步请求到的code
     */
    public function getAccessToken($code, $extend = null) {
        $this->config();
        $params = array(
            'client_id' => $this->AppKey,
            'client_secret' => $this->AppSecret,
            'grant_type' => $this->GrantType,
            'code' => $code,
            'redirect_uri' => $this->Callback,
        );

        $data = $this->http($this->GetAccessTokenURL, $params, 'POST');
        $this->Token = $this->parseToken($data, $extend);
        return $this->Token;
    }

    /**
     * @param type $url 地址
     * @param type $method 请求方式
     * @param type $fields 附带参数，可以是数组，也可以是字符串
     * @param type $header 头部，数组形式
     * @param type $timeout 超时
     * @param type $userAgent 浏览器UA
     * @return boolean
     */
    public function Http($url, $fields, $method = 'POST', $header, $multi, $timeout = '30', $userAgent) {
        //载入HTTP类
        import('HTTP');
        $this->https = new Http();
        $data = $this->https->execute($url, $method, $fields, $header, $timeout = '30', $userAgent, $multi);
        return $data;
    }

    /**
     * 合并默认参数和额外参数
     * @param array $params  默认参数
     * @param array/string $param 额外参数
     * @return array:
     */
    protected function param($params, $param) {
        if (is_string($param))
            parse_str($param, $param);
        return array_merge($params, $param);
    }

    /**
     * 获取指定API请求的URL
     * @param  string $api API名称
     * @param  string $fix api后缀
     * @return string      请求的完整URL
     */
    protected function url($api, $fix = '') {
        return $this->ApiBase . $api . $fix;
    }

    /**
     * 抽象方法，在SNSSDK中实现
     * 组装接口调用参数 并调用接口
     */
    abstract protected function call($api, $param = '', $method = 'GET', $multi = false);

    /**
     * 抽象方法，在SNSSDK中实现
     * 解析access_token方法请求后的返回值
     */
    abstract protected function parseToken($result, $extend);

    /**
     * 抽象方法，在SNSSDK中实现
     * 获取当前授权用户的SNS标识
     */
    abstract public function uniqueId();

    /**
     * 抽象方法，在SNSSDK中实现
     * 发送微博
     */
    abstract public function sendWeibo($sendInfo);
}
