<?php

/**
 * 单页管理
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-9-15
 */
class OnepageAction extends AdminBaseAction {

    protected $onepageModel;

    const MODULE_VAR_NAME = 'Onepage'; //模块名称

    function _initialize() {
        parent::_initialize();
        $this->onepageModel = D('Onepage');
        $this->termService = BService('Term');
        $this->termList = $this->termService->getTermList('Onepage');
        $this->assign('termList', $this->termList);
    }

    /**
     * 首页
     */
    public function index() {
        $count = $this->onepageModel->count();
        $page = page($count);
        $onepageList = $this->onepageModel->limit($page->firstRow . ',' . $page->listRows)->order('page_id DESC')->select();
        $this->assign("onepageList", $onepageList);
        $this->assign("pages", $page->show());
        $this->display();
    }

    /**
     * 添加
     */
    public function add() {
        if (IS_POST) {
            $post = $this->_post();            
            if (empty($post['title'])) {
                $this->bpiAjaxReturn(false, '名称不能为空');
            }
            //获取新建分类名
            $newTermName = $post['new_term_name'];
            //如果新建分类不为空，则新建分类
            if (!empty($newTermName)) {
                $post['term_id'] = $this->termService->addTerm($newTermName, 'Onepage');
                if (!$post['term_id']) {
                    $this->bpiAjaxReturn(false, $this->termService->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            }

            //处理icon图
            if (($attachmentId = intval($post['icon_id']))) {
                //检测附件是否存在
                if (($attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId))) {
                    $post['icon'] = $attachmentInfo['file_path'];
                }
            }
            //默认分类
            if (empty($post['term_id'])) {
                $post['term_id'] = '0';
            }

            //默认模版
            if (empty($post['template'])) {
                $post['template'] = 'show';
            }

            //自动分词
            if (empty($post['keyword'])) {
                $post['keyword'] = get_keywords_str($post['title']);
            }

            $page_id = $this->onepageModel->add($post);
            if ($page_id) {
                if (empty($post['filename'])) {
                    $post['filename'] = $page_id ;
                } 
                if (empty($post['filepath'])) {
                    $post['filepath'] = 'html/onepage/' . $post['term_id'] . '/';
                }
                if ($post['ishtml'] == '1') {
                    $map['url'] = SITE_URL . $post['filepath'] . $post['filename'];
                } else {
                    $map['url'] = SITE_URL . 'index.php?m=Onepage&a=show&page_id=' . $page_id .'.html';
                }
                $this->onepageModel->where(array('page_id' => $page_id))->save($map);
                $this->_createhtml($page_id);
                //更新缩略图
                BService('Attachment')->apiUpdate(NULL, $page_id, $post['icon_id']);

                $this->bpiAjaxReturn(true, '添加成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Onepage/index') . '"'));
            } else {
                $this->bpiAjaxReturn(false, '添加失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            $this->display('edit');
        }
    }

    /**
     * 修改
     */
    public function edit() {
        if (IS_POST) {
            $post = $this->_post();
            if (empty($post['title'])) {
                $this->bpiAjaxReturn(false, '名称不能为空');
            }

            //获取新建分类名
            $newTermName = $post['new_term_name'];
            //如果新建分类不为空，则新建分类
            if (!empty($newTermName)) {
                $post['term_id'] = $this->termService->addTerm($newTermName, 'Onepage');
                if (!$post['term_id']) {
                    $this->bpiAjaxReturn(false, $this->termService->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            }

            //处理icon图
            if (($attachmentId = intval($post['icon_id']))) {
                //检测附件是否存在
                if (($attachmentInfo = BService('Attachment')->getAttachmentInfo($attachmentId))) {
                    $post['icon'] = $attachmentInfo['file_path'];
                }
            }
            
            //默认分类
            if (empty($post['term_id'])) {
                $post['term_id'] = '0';
            }

            //默认模版
            if (empty($post['template'])) {
                $post['template'] = 'show';
            }
           
            //自动分词
            if (empty($post['keyword'])) {
                $post['keyword'] = get_keywords_str($post['title']);
            }

            if (empty($post['filename'])) {
                $post['filename'] = $post['page_id'];
            } 
            if (empty($post['filepath'])) {
                $post['filepath'] = 'html/onepage/' . $post['term_id'] . '/';
            }
            if ($post['ishtml'] == '1') {
                $post['url'] = SITE_URL . $post['filepath'] . $post['filename'];
            } else {
                $post['url'] = SITE_URL . 'index.php?m=Onepage&a=show&page_id=' . $page_id .'.html';
            }
            $status = $this->onepageModel->where(array('page_id' => $post['page_id']))->save($post);
            if ($status) {
                $this->_createhtml($post['page_id']);
                //更新缩略图
                BService('Attachment')->apiUpdate(NULL, $post['page_id'], $post['icon_id']);
                $this->bpiAjaxReturn(true, '修改成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Onepage/Onepage/index') . '"'));
            } else {
                $this->bpiAjaxReturn(false, '修改失败');
            }
        } else {
            $Info = $this->onepageModel->where(array('page_id' => $_GET['page_id']))->find();
            $this->assign('Info', $Info);
            $this->display('edit');
        }
    }

    //状态
    public function status() {
        if (IS_POST) {
            $post = $this->_post();
            $status = $this->onepageModel->where(array('page_id' => $post['page_id']))->save($post);
            if ($status) {
                $this->_createhtml($post['page_id']);
                $this->bpiAjaxReturn(true, '更新成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Onepage/Onepage/index') . '"'));
            } else {
                $this->bpiAjaxReturn(false, '修改失败');
            }
        }
    }

    /**
     * 删除
     */
    public function delete() {
        $page_id = $this->_get('page_id');
        if (empty($page_id)) {
            $this->bpiAjaxReturn(false, '请选择删除条目', array(), C('OPERATE_TYPE.OPERATE_DELETE'));
        }
        $iconID = BService('Attachment')->apiGetAttachmentId(NULL, $page_id);
        BService('Attachment')->apiDelete(NULL, $page_id, $iconID);
        $this->_createhtml($page_id,'1');
        //删除内容
        if ($this->onepageModel->delete($page_id)) {
            $this->bpiAjaxReturn(true, '删除成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
        } else {
            $this->bpiAjaxReturn(false, '删除失败');
        }
    }

    /**
     * 模版路径
     */
    public function templateFile($template) {
        $theme = BaseAction::getVar('config/theme');
        $templateTheme = $theme ? $theme : C('FRONT_TMPL_DEFAULT_THEME');
        //检查CONFIG_THEME是否被定义
        if (!defined('TMPL_THEME')) {
            define('TMPL_THEME', $templateTheme);
        }
        
        $templateFile = TEMPLATE_PATH . $templateTheme . DS . 'Index' . DS . MODULE_NAME . DS . $template . C('TMPL_TEMPLATE_SUFFIX');
        if (!file_exists_case($templateFile)) {
            //当前主题下默认模版
            $templateFile = TEMPLATE_PATH . $templateTheme . DS . 'Index' . DS . MODULE_NAME . DS . 'show' . C('TMPL_TEMPLATE_SUFFIX');
            if (!file_exists_case($templateFile)) {
                //默认主题下默认模版
                $templateFile = TEMPLATE_PATH . C('FRONT_TMPL_DEFAULT_THEME') . DS . 'Index' . DS . MODULE_NAME . DS . 'show' . C('TMPL_TEMPLATE_SUFFIX');
            }
        }
        return $templateFile;
    }

    /**
     * 生成静态
     */
    public function createhtml() {
        $param = $this->_param('page_id');
        $pageIds = is_array($param) ? $param : array($param);
        if (empty($pageIds)) {
            foreach ($pageIds as $pageId) {
                $pageId = intval($pageId);
                if ($pageId > 0) {
                    $this->_createhtml($pageId);
                }
            }
        } else {
            //更新全部
            $Info = $this->onepageModel->select();
            foreach ($Info as $k => $v) {
                $this->_createhtml($v['page_id']);
            }
            $this->success("更新完成！", U("Custompage/index"));
        }
        $this->bpiAjaxReturn(true, '更新成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
    }
    /**
     * 生成静态
     */
    public function _createhtml($page_id,$delete='0') {
        $Info = $this->onepageModel->where(array('page_id' => $page_id))->find();
        if ($delete == '1') {
           $filename = SITE_PATH . DS . $Info['filepath'] . $Info['filename'] . '.html';
            if (file_exists($filename)) {
                unlink($filename);
            }
        } elseif ($Info['ishtml'] == '1' && $Info['status'] == '99') {
            $Info['content'] = bpiHtmlspecialcharsDecode($Info['content']);
            $seo = seo('', $Info['title'], $Info['description'], $Info['keyword']);
            $this->assign('seo', $seo);
            $this->assign('onepageInfo', $Info);
            $this->buildHtml($Info['filename'], SITE_PATH . DS . $Info['filepath'], $this->templateFile($Info['template']));
        } else {
            $filename = SITE_PATH . DS . $Info['filepath'] . $Info['filename'] . '.html';
            if (file_exists($filename)) {
                unlink($filename);
            }
        }
    }

    /**
     * 显示分类列表
     */
    public function termList() {
        $this->display('Admin@Term:termList');
    }

    /**
     * 删除分类
     */
    public function termDelete() {
        parent::deleteTerm(self::MODULE_VAR_NAME);
    }

    /**
     * 编辑分类
     */
    public function termEdit() {
        parent::editTerm(self::MODULE_VAR_NAME);
    }

}
?>
