<?php
/**
 * 支付模块
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-5
 */
class PaymentAction extends FrontBaseAction {

    protected $setting;

    function _initialize() {
        parent::_initialize();
		$this->paymentModel = D('Payment');
    }

	//列出启用的支付方式
	public function index() {

	}

    public function respond() {
		$post = $this->_post();
		$get = $this->_get();
		if (!empty($post)){
			$get['ispost'] = '1';
            foreach($post as $key => $data){
                $get[$key] = $data;
            }
        }
    	/* 支付方式代码 */
    	$pay_code = !empty($get['code']) ? trim($get['code']) : '';

    	//获取首信支付方式
    	if (empty($pay_code) && !empty($get['v_pmode']) && !empty($get['v_pstring'])){
			$pay_code = 'cappay';
		}

    	//获取快钱神州行支付方式
    	if (empty($pay_code) && ($get['ext1'] == 'shenzhou') && ($get['ext2'] == 'bpicms')){
    	    $pay_code = 'shenzhou';
    	}

    	/* 参数是否为空 */
    	if (empty($pay_code)) {
    	    $msg = '参数丢失';
    	} else {
    	    /* 检查code里面有没有问号 */
    	    if (strpos($pay_code, '?') !== false){
				$arr1 = explode('?', $pay_code);
     	        $arr2 = explode('=', $arr1[1]);

      	        $get['code']       = $arr1[0];
       	        $get[$arr2[0]]     = $arr2[1];
       	        $pay_code           = $arr1[0];
    	    }

    	    /* 判断是否启用 */
			$paymentinfo = $this->paymentModel->where(array('pay_code' => $pay_code,'enabled' => '1'))->find();

    	    if (empty($paymentinfo)){
				$msg = '支付方式没启用';
			} else {
				$pay_config = unserialize($paymentinfo['pay_config']);
				//取得支付方式信息
				import("@.ORG.".$pay_code,'','.php');
				$pay = new $pay_code($pay_config);
				$return_data = $pay->respond($get);
				if(isset($return_data)) {
					if($return_data['order_status'] == 0) {				
						//更新订单状态
						BService('Payment')->update_trade($return_data['order_id']);
					} 

				} else {
					//记录错误参数
					BService('Payment')->log_result($pay_code,$get);
					$msg = '支付失败';
				}

    	    }
		}
        //$this->assign('msg',$msg);
        //$this->display();
    }

}

?>
