<?php

/**
 * 支付管理模块
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-7-25
 */
class PaymentManageAction extends AdminBaseAction {

    function _initialize() {
        parent::_initialize();
		$this->paymentModel = D('Payment');
    }

    public function index() {
    	$pay_list = array();
		/* 取得插件文件中的支付方式 */
    	$files = glob(APP_PATH . C('APP_GROUP_PATH').DS.GROUP_NAME.DS.'ORG'.DS.'*'.'.php');
		foreach ($files as $file) {
			$pay_code = basename($file, '.php');
			//取得支付方式信息
			import("@.ORG.".$pay_code,'','.php');
			$pay = new $pay_code();
			$pay_list[$pay_code] = $pay->pay_info();

			$paymentinfo = $this->paymentModel->where(array('pay_code' => $pay_code))->find();
		    //支付方式是否安装
     	    if(isset($paymentinfo)){
                $paymentinfo['pay_config'] = unserialize($paymentinfo['pay_config']);
				$pay_list[$pay_code]['pay_id'] = $paymentinfo['pay_id'];
				$pay_list[$pay_code]['pay_order'] = $paymentinfo['pay_order'];
				$pay_list[$pay_code]['pay_desc'] = $paymentinfo['pay_desc'];
				$pay_list[$pay_code]['name'] = $paymentinfo['pay_name'];
				if($paymentinfo['pay_config']['fee_method'] == '0' && $paymentinfo['pay_fee'] != ''){
					$pay_list[$pay_code]['pay_fee'] = $paymentinfo['pay_fee'].'%';
				}else{
					$pay_list[$pay_code]['pay_fee'] = $paymentinfo['pay_fee'];
				}
				$pay_list[$pay_code]['install'] = '1';
     	    }else{
			    $pay_list[$pay_code]['pay_code'] = $pay_list[$pay_code]['code'];
				$pay_list[$pay_code]['pay_fee'] = '0';
				$pay_list[$pay_code]['pay_order'] = '0';
				$pay_list[$pay_code]['install'] = '0';
		    }
        }
    	$this->assign('paylist',$pay_list);
        $this->display();
    }


    public function edit() {
		if (IS_POST) {
            $post = $this->_post();
			$post['pay_desc']=bpiHtmlspecialcharsDecode($post['pay_desc']);
			if($post['pay_config']['fee_method'] == '0'){
				$post['pay_fee'] = $post['pay_rate'];
			} else {
				$post['pay_fee'] = $post['pay_fix'];
			}
			$post['pay_config'] = serialize($post['pay_config']);
			$data = $this->paymentModel->create($post);
            if ($data) {
				$status = $this->paymentModel->where(array('pay_id' => $data['pay_id']))->save($data);
                if ($status !== FALSE) {
                    $this->bpiAjaxReturn(true, '配置成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.RETURNLIST')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '配置失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
			}
            
        } else {
            $PayId = intval($this->_get('pay_id'));
		    $paymentinfo = $this->paymentModel->where(array('pay_id' => $PayId))->find();
		    $paymentinfo['pay_config'] = unserialize($paymentinfo['pay_config']);
    	    $this->assign('payment',$paymentinfo);
            $this->display($paymentinfo['pay_code']);
        }
		
    }

    public function install() {
		if (IS_POST) {
            $post = $this->_post();
			$post['pay_desc']=bpiHtmlspecialcharsDecode($post['pay_desc']);
			if($post['pay_config']['fee_method'] == '0'){
				$post['pay_fee'] = $post['pay_rate'];
			} else {
				$post['pay_fee'] = $post['pay_fix'];
			}
			$post['pay_config'] = serialize($post['pay_config']);
			$data = $this->paymentModel->create($post);
            if ($data) {
				$data['enabled'] = '1';
				$status = $this->paymentModel->add($data);
                if ($status !== FALSE) {
					$this->bpiAjaxReturn(true, '安装成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.URL') . '"' . U('Payment/PaymentManage/Index') . '"'));

                } else {
                    $this->bpiAjaxReturn(false, '安装失败');
                }
			}
            
        } else {
            $pay_code = $this->_get('pay_code');
		    //取得支付方式信息
		    import("@.ORG.".$pay_code,'','.php');
		    $pay = new $pay_code();
		    $paymentinfo = $pay->pay_info();	
			foreach ($paymentinfo as $key => $value) {
				$payment['pay_'.$key] = $value;
			}
			$payment['is_cod'] = $payment['pay_is_cod'];
			$payment['is_online'] = $payment['pay_is_online'];
		    $this->assign('payment',$payment);
            $this->display($pay_code);
        }
	}
    /**
     * 卸载
     */
    public function uninstall() {
        $PayId = intval($this->_get('pay_id'));
        if ($this->paymentModel->delete($PayId)) {
			$this->bpiAjaxReturn(true, '卸载成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_DELETE'));
		} else {
			$this->bpiAjaxReturn(false, '卸载失败');
		}
    }

	/**
     * 排序
     */
    public function sort() {
        parent::saveSort($this->paymentModel, $this->_post('pay_order'), 'pay_order', true);
    }

}

?>
