<?php
/**
 * 支付宝支付
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-5
 */
class alipay{

	public $config = array()  ;

    public function __construct($config=array()) {
        $this->config = $config;
		if ($this->config['alipay_pay_method']== '1'){
			$this->config['service'] = 'create_partner_trade_by_buyer'; //担保
		} elseif ($this->config['alipay_pay_method']== '2'){
			$this->config['service'] = 'create_direct_pay_by_user'; //即时
		} else { 
			$this->config['service'] = 'trade_create_by_buyer';	//标准
		}
		$this->config['gateway_url'] = 'https://www.alipay.com/cooperate/gateway.do?_input_charset=utf-8';
		$this->config['gateway_method'] = 'POST';
		$this->config['notify_url'] =  return_url('alipay');
		$this->config['return_url'] =  return_url('alipay');
    }

    //配置信息
	public function pay_info(){

        /* 名称 */
        $pay['name']    = '支付宝';

		/* 描述 */
        $pay['pay_desc']    = '支付宝网站(www.alipay.com) 是国内先进的网上支付平台。<br/>支付宝收款接口：在线即可开通，<font color="red"><b>零预付，免年费</b></font>，单笔阶梯费率，无流量限制。<br/><a href="http://cloud.ecshop.com/payment_apply.php?mod=alipay" target="_blank"><font color="red">立即在线申请</font></a>';
		
		/* 代码 */
        $pay['code']    = basename(__FILE__, '.php');

        /* 是否支持货到付款 */
        $pay['is_cod']  = '0';

        /* 是否支持在线支付 */
        $pay['is_online']  = '1';

        /* 作者 */
        $pay['author']  = '天之骄子';

        /* 网址 */
        $pay['website'] = 'http://www.wufar.cn';

        /* 版本号 */
        $pay['version'] = '1.0.0';

        /* 配置信息 */
        $pay['config']  = array(
            array('name' => 'alipay_account',           'type' => 'text',   'value' => ''),
            array('name' => 'alipay_key',               'type' => 'text',   'value' => ''),
            array('name' => 'alipay_partner',           'type' => 'text',   'value' => ''),
            array('name' => 'alipay_pay_method',        'type' => 'select', 'value' => '')
        );

		return $pay;
    }

	/**
     * 生成支付表单
     * @param   array    $order       订单信息
     */
    public function pay_form($order){
		$parameters = $this->getpreparedata($order);
		if (strtoupper($this->config['gateway_method']) == 'POST'){
			$button = '<form action="' . $this->config['gateway_url'] . '" method="POST" target="_blank">';
		} else {
			$button = '<form action="' . $this->config['gateway_url'] . '" method="GET" target="_blank">';
		}
        foreach ($parameters AS $key=>$value){
        	$button  .= "<input type='hidden' name=\"$key\" value=\"$value\" />\n";
        }
		$button.= "<input type=\"submit\" value=\"支付宝支付\">";
		$button.= "</form>";
        return $button;	
    }



	/**
	*获取带参数的请求URL
	* @param   array    $order       订单信息
	*/
	public function pay_url($order) {
		$parameters = $this->getpreparedata($order);
		$reqPar = "";
		ksort($parameters);
		reset($parameters);
		foreach($parameters as $k => $v) {
			$reqPar .= $k . "=" . urlencode($v) . "&";
		}
		//去掉最后一个&
		$reqPar = substr($reqPar, 0, strlen($reqPar)-1);
		
		$pay_url = 'https://www.alipay.com/cooperate/gateway.do' . "?" . $reqPar;
		
		return $pay_url;
		
	}

    /**
     * 响应操作
	 * 状态码说明  （0 交易完成 1 交易失败 2 交易超时 3 交易处理中 4 交易未支付 5交易取消 6交易发生错误）
     */
    public function respond($get){
		$receive_sign = $get['sign'];
		$ispost = $get['ispost'];
    	$receive_data = $this->filterParameter($get);

		//载入HTTP类
        import('HTTP');
        $this->https = new Http();
        $verify_result = $this->https->execute('http://notify.alipay.com/trade/notify_query.do?partner=' . $this->config['alipay_partner'] . '&notify_id=' . $receive_data['notify_id'], 'POST', $send_str, $header, $timeout = '30');

		if (preg_match('/true$/i', $verify_result)){
			$receive_data = $this->arg_sort($receive_data);
        	$sign = '';
			$sign = $this->build_mysign($receive_data,$this->config['alipay_key'],'MD5');
        	if ($sign == $receive_sign){
        	    $return_data['order_id'] = $receive_data['out_trade_no'];
				$return_data['order_total'] = $receive_data['total_fee'];
				$return_data['price'] = $receive_data['price'];
				if ($receive_data['trade_status'] == 'WAIT_BUYER_PAY'){
				$return_data['order_status'] = '3';
        		} elseif ($receive_data['trade_status'] == 'WAIT_SELLER_SEND_GOODS'){
        	        $return_data['order_status'] = '3';
        	    } elseif ($receive_data['trade_status'] == 'WAIT_BUYER_CONFIRM_GOODS'){
         		   	$return_data['order_status'] = '3';
        		} elseif ($receive_data['trade_status'] == 'TRADE_CLOSED'){
           	 		$return_data['order_status'] = '5';
        		} elseif ($receive_data['trade_status'] == 'TRADE_FINISHED'){
            		$return_data['order_status'] = '0';
        		} elseif ($receive_data['trade_status'] == 'TRADE_SUCCESS'){
            		$return_data['order_status'] = '0';
        		} else {
            		$return_data['order_status'] = '5';
        		}
				if($ispost == '1') echo 'success';
				return $return_data;
        	} else {
				return false;
			}
		} else {
			return false;
		}
    }


	/**
     * 生成参数数组
     * @param   array    $order       订单信息
     */
    private function getpreparedata($order){

        $prepare_data['service'] = $this->config['service'];
		$prepare_data['payment_type'] = '1';
		$prepare_data['seller_email'] = $this->config['alipay_account'];
		$prepare_data['partner'] = $this->config['alipay_partner'];
		$prepare_data['_input_charset'] = 'utf-8';		
		$prepare_data['notify_url'] = $this->config['notify_url'];
		$prepare_data['return_url'] = $this->config['return_url'];
		
		// 商品信息
		$prepare_data['subject'] = $order['order_name'];
		$prepare_data['price'] = $order['order_amount'];
		if (array_key_exists('show_url', $order)) $prepare_data['show_url'] = $order['show_url'];
		$prepare_data['body'] = $order['body'];
		
		//订单信息
		$prepare_data['out_trade_no'] = $order['order_sn'];
		$prepare_data['quantity'] = '1';

		// 物流信息
		if($this->config['service'] == 'create_partner_trade_by_buyer' || $this->config['service'] == 'trade_create_by_buyer') {
			$prepare_data['logistics_type'] = 'EXPRESS';
			$prepare_data['logistics_fee'] = '0.00';
			$prepare_data['logistics_payment'] = 'SELLER_PAY';
		}
		//买家信息
		$prepare_data['buyer_email'] = $order['buyer_email'];
		$prepare_data['receive_name']	    =  $order['receive_name']; //收货人姓名
		$prepare_data['receive_address']	=  $order['receive_address']; //如：XX省XXX市XXX区XXX路XXX号
		$prepare_data['receive_zip']	    =  $order['receive_zip']; //收货人邮编
		$prepare_data['receive_phone']	    =  $order['receive_phone']; //收货人电话号码
		$prepare_data['receive_mobile']	=  $order['receive_mobile']; //收货人手机号码


		$prepare_data = $this->arg_sort($prepare_data);
		// 数字签名
		$prepare_data['sign'] = $this->build_mysign($prepare_data,$this->config['alipay_key'],'MD5');

		return $prepare_data;


    }

	/**
     * 返回字符过滤
     * @param $parameter
     */
	private function filterParameter($parameter)
	{
		$para = array();
		foreach ($parameter as $key => $value)
		{
			if ('sign' == $key || 'sign_type' == $key || '' == $value || 'm' == $key  || 'a' == $key  || 'c' == $key   || 'code' == $key || 'ispost' == $key) continue;
			else $para[$key] = $value;
		}
		return $para;
	}

	/**
	 * 生成签名结果
	 * @param $array要加密的数组
	 * @param return 签名结果字符串
	*/
	private function build_mysign($sort_array,$security_code,$sign_type = "MD5") {
	    $prestr = $this->create_linkstring($sort_array);     	//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
 	   $prestr = $prestr.$security_code;				//把拼接后的字符串再与安全校验码直接连接起来
 	   $mysgin = $this->sign($prestr,$sign_type);			    //把最终的字符串加密，获得签名结果
 	   return $mysgin;
	}	


	/**
	 * 把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串
	 * @param $array 需要拼接的数组
	 * @param return 拼接完成以后的字符串
	*/
	private function create_linkstring($array) {
	    $arg  = "";
	    while (list ($key, $val) = each ($array)) {
	        $arg.=$key."=".$val."&";
	    }
 	   $arg = substr($arg,0,count($arg)-2);		     //去掉最后一个&字符
 	   return $arg;
	}

	/********************************************************************************/

	/**除去数组中的空值和签名参数
	 * @param $parameter 加密参数组
	 * @param return 去掉空值与签名参数后的新加密参数组
	 */
	private function para_filter($parameter) {
 	   $para = array();
 	   while (list ($key, $val) = each ($parameter)) {
 	       if($key == "sign" || $key == "sign_type" || $val == "")continue;
 		       else	$para[$key] = $parameter[$key];
	    }
 	   return $para;
	}

	/********************************************************************************/

	/**对数组排序
	 * @param $array 排序前的数组
	 * @param return 排序后的数组
	 */
	private function arg_sort($array) {
		$array = $this->para_filter($array); 
	    ksort($array);
	    reset($array);
 	   return $array;
	}

	/********************************************************************************/

	/**加密字符串
	 * @param $prestr 需要加密的字符串
	 * @param return 加密结果
	 */
	private function sign($prestr,$sign_type) {
	    $sign='';
	    if($sign_type == 'MD5') {
	        $sign = md5($prestr);
 	   }elseif($sign_type =='DSA') {
 	       //DSA 签名方法待后续开发
 	       //die(L('dsa', 'pay'));
  	  }else {
  	      //die(L('alipay_error','pay'));
 	   }
 	   return $sign;
	}
}

?>