<?php
/**
 * 首信易支付插件
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-5
 */
class cappay{

	public $config = array()  ;

    public function __construct($config=array()) {
		$this->config = $config;
		$this->config['return_url'] =  return_url('cappay');
    }

    public function pay_info(){
		/* 名称 */
        $pay['name']    = '首信易';

		/* 代码 */
        $pay['code']    = basename(__FILE__, '.php');

        /* 是否支持货到付款 */
        $pay['is_cod']  = '0';

        /* 是否支持在线支付 */
        $pay['is_online']  = '1';

        /* 作者 */
        $pay['author']  = '天之骄子';

        /* 网址 */
        $pay['website'] = 'http://www.wufar.cn';


        /* 版本号 */
        $pay['version'] = '1.0.0';

        /* 配置信息 */
        $pay['config'] = array(
            array('name' => 'cappay_account',  'type' => 'text',   'value' => ''),
            array('name' => 'cappay_key',      'type' => 'text',   'value' => ''),
            array('name' => 'cappay_currency', 'type' => 'select', 'value' => 'USD')
        );

		return $pay;
    }

	    /**
     * 提交函数
     */
    public function pay_form(){
        return '';
    }

	/**
     * 提交函数
     */
    public function pay_url(){
        return '';
    }

    /**
     * 生成支付代码
     * @param   array   $order      订单信息
     * @param   array   $payment    支付方式信息
     */
    public function get_code($order){
        $v_rcvname   = trim($this->config['cappay_account']);
        $m_orderid   = $order['order_sn'];
        $v_amount    = $order['order_amount'];
        $v_moneytype = trim($this->config['cappay_currency']);;
        $v_url       = $this->config['return_url'];
        $m_ocomment  = '欢迎使用首信易支付';
        $v_ymd       = date('Ymd',time());

          /*易支付平台*/
        $MD5Key     = $this->config['cappay_key'];     //<--支付密钥--> 注:此处密钥必须与商家后台里的密钥一致
        $v_oid      = "$v_ymd-$v_rcvname-$m_orderid";
        $sourcedata = $v_moneytype.$v_ymd.$v_amount.$v_rcvname.$v_oid.$v_rcvname.$v_url;
        $result     = $this->hmac_md5($MD5Key,$sourcedata);
        $def_url  = '<form method=post action="http://pay.beijing.com.cn/prs/user_payment.checkit" target="_blank">';
        $def_url .= "<input type= 'hidden' name = 'v_mid'     value= '".$v_rcvname."'>";     //商户编号
        $def_url .= "<input type= 'hidden' name = 'v_oid'     value= '".$v_oid."'>";         //订单编号
        $def_url .= "<input type= 'hidden' name = 'v_rcvname' value= '".$v_rcvname."'>";     //收货人姓名
        $def_url .= "<input type= 'hidden' name = 'v_rcvaddr' value= '".$v_rcvname."'>";     //收货人地址
        $def_url .= "<input type= 'hidden' name = 'v_rcvtel'  value= '".$v_rcvname."'>";     //收货人电话
        $def_url .= "<input type= 'hidden' name = 'v_rcvpost'  value= '".$v_rcvname."'>";    //收货人邮编
        $def_url .= "<input type= 'hidden' name = 'v_amount'   value= '".$v_amount."'>";     //订单总金额
        $def_url .= "<input type= 'hidden' name = 'v_ymd'      value= '".$v_ymd."'>";        //订单产生日期
        $def_url .= "<input type= 'hidden' name = 'v_orderstatus' value ='0'>";              //配货状态
        $def_url .= "<input type= 'hidden' name = 'v_ordername'   value ='".$v_rcvname."'>"; //订货人姓名
        $def_url .= "<input type= 'hidden' name = 'v_moneytype'   value ='".$v_moneytype."'>"; //币种,0为人民币,1为美元
        $def_url .= "<input type= 'hidden' name='v_url' value='".$v_url."'>";             //支付动作完成后返回到该url，支付结果以GET方式发送
        $def_url .= "<input type='hidden' name='v_md5info' value=$result>";              //订单数字指纹
        $def_url .= "<input type='submit' value='用易支付支付'>";

        $def_url .= '</form>';

          /*易支付会员通道
        $def_url  = "<form method=post action='http://pay.beijing.com.cn/customer/gb/pay_member.jsp' target='_blank'>";
        $def_url .= "<input type='hidden' name='v_mid' value='".$v_rcvname."'>";                   //商户编号
        $def_url .= "<input type='hidden' name='v_oid' value='".$v_oid."'>";                       //订单编号
        $def_url .= "<input type='hidden' name='v_rcvname' value='".$v_rcvname."'>";               //收货人姓名
        $def_url .= "<input type='hidden' name='v_rcvaddr' value='".$v_rcvname."'>";               //收货人地址
        $def_url .= "<input type='hidden' name='v_rcvtel' value='".$v_rcvname."'>";                //收货人电话
        $def_url .= "<input type='hidden' name='v_rcvpost' value='".$v_rcvname."'>";               //收货人邮编
        $def_url .= "<input type='hidden' name='v_amount' value='".$v_amount."'>";                 //订单总金额
        $def_url .= "<input type='hidden' name='v_ymd' value='".$v_ymd."'>";                       //订单产生日期
        $def_url .= "<input type='hidden' name='v_orderstatus' value='0'>";                        //配货状态
        $def_url .= "<input type='hidden' name='v_ordername' value='".$v_rcvname."'>";             //订货人姓名
        $def_url .= "<input type='hidden' name='v_moneytype' value='".$v_moneytype."'>";   //币种,0为人民币,1为美元
        $def_url .= "<input type='hidden' name='v_url' value='".$v_url."'>";              //支付动作完成后返回到该url，支付结果以GET方式发送
        $def_url .= "<input type='hidden' name='v_md5info' value=$result[0]>";           //订单数字指纹
        $def_url .= "<input type='submit' value='"  . $GLOBALS['_LANG']['cappay_member_button'] .  "'>";

        $def_url .= '</form>';

          //易支付手机通道
        $def_url  = "<form method=post action='http://pay.beijing.com.cn/customer/gb/pay_mobile.jsp' target='_blank'>";
        $def_url .= "<input type='hidden' name='v_mid' value='".$v_rcvname."'>";                   //商户编号
        $def_url .= "<input type='hidden' name='v_oid' value='".$v_oid."'>";                       //订单编号
        $def_url .= "<input type='hidden' name='v_rcvname' value='".$v_rcvname."'>";               //收货人姓名
        $def_url .= "<input type='hidden' name='v_rcvaddr' value='".$v_rcvname."'>";               //收货人地址
        $def_url .= "<input type='hidden' name='v_rcvtel' value='".$v_rcvname."'>";                //收货人电话
        $def_url .= "<input type='hidden' name='v_rcvpost' value='".$v_rcvname."'>";               //收货人邮编
        $def_url .= "<input type='hidden' name='v_amount' value='".$v_amount."'>";                 //订单总金额
        $def_url .= "<input type='hidden' name='v_ymd' value='".$v_ymd."'>";                       //订单产生日期
        $def_url .= "<input type='hidden' name='v_orderstatus' value='0'>";                        //配货状态
        $def_url .= "<input type='hidden' name='v_ordername' value='".$v_rcvname."'>";             //订货人姓名
        $def_url .= "<input type='hidden' name='v_moneytype' value='".$v_moneytype."'>";   //币种,0为人民币,1为美元
        $def_url .= "<input type='hidden' name='v_url' value='".$v_url."'>";              //支付动作完成后返回到该url，支付结果以GET方式发送
        $def_url .= "<input type='hidden' name='v_md5info' value=$result[0]>";           //订单数字指纹
        $def_url .= "<input type='submit' value='"  . $GLOBALS['_LANG']['cappay_mobile_button'] .  "'>";

        $def_url .= '</form>';

          //易支付英文通道
        $def_url  = "<form method=post action='http://pay.beijing.com.cn/prs/e_user_payment.checkit' target='_blank'>";
        $def_url .= "<input type='hidden' name='v_mid' value='".$v_rcvname."'>";                   //商户编号
        $def_url .= "<input type='hidden' name='v_oid' value='".$v_oid."'>";                       //订单编号
        $def_url .= "<input type='hidden' name='v_rcvname' value='".$v_rcvname."'>";               //收货人姓名
        $def_url .= "<input type='hidden' name='v_rcvaddr' value='".$v_rcvname."'>";               //收货人地址
        $def_url .= "<input type='hidden' name='v_rcvtel' value='".$v_rcvname."'>";                //收货人电话
        $def_url .= "<input type='hidden' name='v_rcvpost' value='".$v_rcvname."'>";               //收货人邮编
        $def_url .= "<input type='hidden' name='v_amount' value='".$v_amount."'>";                 //订单总金额
        $def_url .= "<input type='hidden' name='v_ymd' value='".$v_ymd."'>";                       //订单产生日期
        $def_url .= "<input type='hidden' name='v_orderstatus' value='0'>";                        //配货状态
        $def_url .= "<input type='hidden' name='v_ordername' value='".$v_rcvname."'>";             //订货人姓名
        $def_url .= "<input type='hidden' name='v_moneytype' value='".$v_moneytype."'>";   //币种,0为人民币,1为美元
        $def_url .= "<input type='hidden' name='v_url' value='".$v_url."'>";              //支付动作完成后返回到该url，支付结果以GET方式发送
        $def_url .= "<input type='hidden' name='v_md5info' value=$result[0]>";           //订单数字指纹
        $def_url .= "<input type='submit' value='"  . $GLOBALS['_LANG']['cappay_en_button'] .  "'>";

        $def_url .= '</form>';*/

        return $def_url;
    }

    /**
     * 响应操作
     * 状态码说明  （0 交易完成 1 交易失败 3 交易处理中）
     */

    public function respond(){
        $v_tempdate = explode('-', $get['v_oid']);

        //接受返回数据验证开始
        //v_md5info验证
        $md5info_paramet = $get['v_oid'].$get['v_pstatus'].$get['v_pstring'].$get['v_pmode'];
        $md5info_tem     = $this->hmac_md5($this->config['cappay_key'],$md5info_paramet);

        $return_data['order_id'] = $get['v_oid'];
		$return_data['order_total'] = $receive_data['v_amount'];
		//v_md5money验证
        $md5money_paramet = $get['v_amount'].$get['v_moneytype'];
        $md5money_tem     = $this->hmac_md5($this->config['cappay_key'],$md5money_paramet);
        if ($md5info_tem == $get['v_md5info'] && $md5money_tem == $get['v_md5money']){
			if($get['v_pstatus'] == '0'){
				$return_data['order_status'] = '3';
			} elseif ($get['v_pstatus'] == '1'){
				$return_data['order_status'] = '0';
			} else{
				$return_data['order_status'] = '1';
			}
			return $return_data;
         } else {
            return false;
         }

    }
    private function hmac_md5($key, $data){
        if (extension_loaded('mhash')){
            return bin2hex(mhash(MHASH_MD5, $data, $key));
        }

        // RFC 2104 HMAC implementation for php. Hacked by Lance Rushing
        $b = 64;
        if (strlen($key) > $b){
            $key = pack('H*', md5($key));
        }
        $key  = str_pad($key, $b, chr(0x00));
        $ipad = str_pad('', $b, chr(0x36));
        $opad = str_pad('', $b, chr(0x5c));

        $k_ipad = $key ^ $ipad;
        $k_opad = $key ^ $opad;

        return md5($k_opad . pack('H*', md5($k_ipad . $data)));
    }

}

?>