<?php

/**
 * 网银在线
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-5
 */

class chinabank{
	public $config = array()  ;

    public function __construct($config=array()) {
		$this->config = $config;
		$this->config['return_url'] =  return_url('chinabank');
    }

    //配置信息
	public function pay_info(){
		/* 名称 */
        $pay['name']    = '网银在线';

		/* 代码 */
    	$pay['code']    = basename(__FILE__, '.php');

    	/* 描述对应的语言项 */
    	$pay['desc']    = '网银在线';

    	/* 是否支持货到付款 */
    	$pay['is_cod']  = '0';

    	/* 是否支持在线支付 */
    	$pay['is_online']  = '1';

    	/* 支付费用 */
    	$pay['pay_fee'] = '1%';

    	/* 作者 */
        $pay['author']  = '天之骄子';

        /* 网址 */
        $pay['website'] = 'http://www.wufar.cn';

    	/* 版本号 */
    	$pay['version'] = '1.0.0';

    	/* 配置信息 */
    	$pay['config'] = array(
    	    array('name' => 'chinabank_account', 'type' => 'text', 'value' => ''),
    	    array('name' => 'chinabank_key',     'type' => 'text', 'value' => ''),
    	);

		return $pay;
    }

	/**
     * 提交函数
     */
    public function pay_form($order){
        $parameters = $this->getpreparedata($order);
		$button = '<form style="text-align:center;" method=post action="https://pay3.chinabank.com.cn/PayGate" target="_blank">'."\n";
        foreach ($parameters AS $key=>$value){
        	$button  .= "<input type='hidden' name=\"$key\" value=\"$value\" />\n";
        }
		$button.= "<input type=\"submit\" value=\"网银在线支付\">\n";
		$button.= "</form>";
        return $button;	
    }

	/**
     * 提交函数
     */
    public function pay_url($order){
        $parameters = $this->getpreparedata($order);
		$reqPar = "";
		foreach($parameters as $k => $v) {
			$reqPar .= $k . "=" . urlencode($v) . "&";
		}
		//去掉最后一个&
		$reqPar = substr($reqPar, 0, strlen($reqPar)-1);
		$pay_url = 'https://pay3.chinabank.com.cn/PayGate' . "?" . $reqPar;
		return $pay_url;
    }

    /**
     * 生成支付代码
     * @param   array   $order      订单信息
     */
    public function getpreparedata($order){
        $data_vid           = trim($this->config['chinabank_account']);
		$data_orderid       = $order['order_sn'];
        $data_vamount       = $order['order_amount'];
        $data_vmoneytype    = 'CNY';
        $data_vpaykey       = trim($this->config['chinabank_key']);
        $data_vreturnurl    = $this->config['return_url'];

        $MD5KEY =$data_vamount.$data_vmoneytype.$data_orderid.$data_vid.$data_vreturnurl.$data_vpaykey;
        $MD5KEY = strtoupper(md5($MD5KEY));

		$prepare_data['v_mid'] = $data_vid;
		$prepare_data['v_oid'] = $data_orderid;
		$prepare_data['v_amount'] = $data_vamount;
		$prepare_data['v_moneytype'] = $data_vmoneytype;
		$prepare_data['v_url'] = $data_vreturnurl;
		$prepare_data['v_md5info'] = $MD5KEY;
		$prepare_data['remark1'] = $remark1;

        return $prepare_data;
    }

    /**
     * 响应操作
     */
    public function respond(){

        $v_oid          = trim($get['v_oid']);
        $v_pmode        = trim($get['v_pmode']);
        $v_pstatus      = trim($get['v_pstatus']);
        $v_pstring      = trim($get['v_pstring']);
        $v_amount       = trim($get['v_amount']);
        $v_moneytype    = trim($get['v_moneytype']);
        $remark1        = trim($get['remark1' ]);
        $remark2        = trim($get['remark2' ]);
        $v_md5str       = trim($get['v_md5str' ]);

        /**
         * 重新计算md5的值
         */
        $key            = $this->config['chinabank_key'];

        $md5string=strtoupper(md5($v_oid.$v_pstatus.$v_amount.$v_moneytype.$key));

        /* 检查秘钥是否正确 */
        if ($v_md5str==$md5string){
			if ($v_pstatus == '20'){
                $return_data['order_total'] = $v_amount;
                $return_data['order_id'] = $v_oid;
				$return_data['order_status'] = '0';
            }
			return $return_data;
        } else {
            return false;
        }
    }
}

?>