<?php
/**
 * ips支付系统插件
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-5
 */

class ips{
   public $config = array()  ;

    public function __construct($config=array()) {
		$this->config = $config;
		$this->config['return_url'] =  return_url('ips');
    }

    public function pay_info(){
		/* 名称 */
        $pay['name']    = 'ips支付';

        /* 代码 */
        $pay['code']    = basename(__FILE__, '.php');

        /* 是否支持货到付款 */
        $pay['is_cod']  = '0';

        /* 是否支持在线支付 */
        $pay['is_online']  = '1';

        /* 作者 */
        $pay['author']  = '天之骄子';

        /* 网址 */
        $pay['website'] = 'http://www.wufar.cn';

        /* 版本号 */
        $pay['version'] = '1.0.0';

        /* 配置信息 */
        $pay['config']  = array(
            array('name' => 'ips_account',  'type' => 'text',   'value' => ''),
            array('name' => 'ips_key',      'type' => 'text',   'value' => ''),
            array('name' => 'ips_currency', 'type' => 'select', 'value' => '01'),
            array('name' => 'ips_lang',     'type' => 'select', 'value' => 'GB')
        );

		return $pay;
    }

	/**
     * 提交函数
     */
    public function pay_form(){
        return '';
    }

	/**
     * 提交函数
     */
    public function pay_url(){
        return '';
    }

    /**
    * 生成支付代码
    * @param   array   $order  订单信息
    * @param   array   $payment    支付方式信息
    */

    public function get_code($order){
        $billstr    = date('His', time());
        $datestr    = date('Ymd', time());
        $mer_code   = $this->config['ips_account'];
        $billno     = str_pad($order['order_sn'], 10, '0', STR_PAD_LEFT) . $billstr;
        $amount     = sprintf("%0.02f", $order['order_amount']);
        $strcert    = $this->config['ips_key'];
        $strcontent = $billno . $amount . $datestr . 'RMB' . $strcert; // 签名验证串 //
        $signmd5    = MD5($strcontent);

        $def_url  = '<br /><form style="text-align:center;" action="https://pay.ips.com.cn/ipayment.aspx" method="post" target="_blank">';
        $def_url .= "<input type='hidden' name='Mer_code' value='" . $mer_code . "'>\n";
        $def_url .= "<input type='hidden' name='Billno' value='" . $billno . "'>\n";
        $def_url .= "<input type='hidden' name='Gateway_type' value='" . $this->config['ips_currency'] . "'>\n";
        $def_url .= "<input type='hidden' name='Currency_Type'  value='RMB'>\n";
        $def_url .= "<input type='hidden' name='Lang'  value='" . $this->config['ips_lang'] . "'>\n";
        $def_url .= "<input type='hidden' name='Amount'  value='" . $amount . "'>\n";
        $def_url .= "<input type='hidden' name='Date' value='" . $datestr . "'>\n";
        $def_url .= "<input type='hidden' name='DispAmount' value='" . $amount . "'>\n";
        $def_url .= "<input type='hidden' name='OrderEncodeType' value='2'>\n";
        $def_url .= "<input type='hidden' name='RetEncodeType' value='12'>\n";
        $def_url .= "<input type='hidden' name='Merchanturl' value='" . $this->config['return_url'] . "'>\n";
        $def_url .= "<input type='hidden' name='SignMD5' value='" . $signmd5 . "'>\n";
        $def_url .= "<input type='submit' value='ips支付'>";
        $def_url .= "</form><br />";

        return $def_url;
    }

    public function respond($get){
        $billno        = $get['billno'];
        $amount        = $get['amount'];
        $mydate        = $get['date'];
        $succ          = $get['succ'];
        $msg           = $get['msg'];
        $ipsbillno     = $get['ipsbillno'];
        $retEncodeType = $get['retencodetype'];
        $currency_type = $get['Currency_type'];
        $signature     = $get['signature'];
        $order_sn      = intval(substr($billno, 0, 10));

        if ($succ == 'Y'){
            $content = $billno . $amount . $mydate . $succ . $ipsbillno . $currency_type;
            $cert = $this->config['ips_key'];
            $signature_1ocal = md5($content . $cert);

            if ($signature_1ocal == $signature){
				$return_data['order_total'] = $amount;
                $return_data['order_id'] = $order_sn;
				$return_data['order_status'] = '0';
                return $return_data;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}

?>