<?php
/**
 * 快钱插件
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-5
 */


class kuaiqian{
    public $config = array()  ;

    public function __construct($config=array()) {
        $this->config = $config;
		$this->config['return_url'] =  return_url('kuaiqian');
    }

    public function pay_info(){
        /* 名称 */
        $pay['name']    = '快钱';

		/* 代码 */
        $pay['code'] = basename(__FILE__, '.php');

        /* 是否支持货到付款 */
        $pay['is_cod'] = '0';

        /* 是否支持在线支付 */
        $pay['is_online'] = '1';

        /* 作者 */
        $pay['author']  = '天之骄子';

        /* 网址 */
        $pay['website'] = 'http://www.wufar.cn';

        /* 版本号 */
        $pay['version'] = '1.0.0';

        /* 配置信息 */
        $pay['config'] = array(
            array('name' => 'kq_account', 'type' => 'text', 'value' => ''),
            array('name' => 'kq_key', 'type' => 'text', 'value' => ''),
        );

		return $pay;
    }

	/**
     * 提交函数
     */
    public function pay_form(){
        return '';
    }

	/**
     * 提交函数
     */
    public function pay_url(){
        return '';
    }

   /**
     * 生成支付代码
     * @param   array   $order  订单信息
     */
   function get_code($order){
       $merchant_acctid    = trim($this->config['kq_account']);                 //人民币账号 不可空
       $key                = trim($this->config['kq_key']);
       $input_charset      = 1;                                                //字符集 默认1=utf-8
       $page_url           = $this->config['return_url'];
       $bg_url             = '';
       $version            = 'v2.0';
       $language           = 1;
       $sign_type          = 1;                                                //签名类型 不可空 固定值 1:md5
       $payer_name         = '';
       $payer_contact_type = '';
       $payer_contact      = '';
       $order_id           = $order['order_sn'];                        //商户订单号 不可空
       $order_amount       = $order['order_amount'] * 100;             //商户订单金额 不可空
       $order_time         = date("YmdHis" );            //商户订单提交时间 不可空 14位
       $product_name       = '';
       $product_num        = '';
       $product_id         = '';
       $product_desc       = '';
       $ext1               = $order['log_id'];
       $ext2               = '';
       $pay_type           = '00';                                                //支付方式 不可空
       $bank_id            = '';
       $redo_flag          = '0';
       $pid                = '';

        /* 生成加密签名串 请务必按照如下顺序和规则组成加密串！*/
        $signmsgval = '';
        $signmsgval = $this->append_param($signmsgval, "inputCharset", $input_charset);
        $signmsgval = $this->append_param($signmsgval, "pageUrl", $page_url);
        $signmsgval = $this->append_param($signmsgval, "bgUrl", $bg_url);
        $signmsgval = $this->append_param($signmsgval, "version", $version);
        $signmsgval = $this->append_param($signmsgval, "language", $language);
        $signmsgval = $this->append_param($signmsgval, "signType", $sign_type);
        $signmsgval = $this->append_param($signmsgval, "merchantAcctId", $merchant_acctid);
        $signmsgval = $this->append_param($signmsgval, "payerName", $payer_name);
        $signmsgval = $this->append_param($signmsgval, "payerContactType", $payer_contact_type);
        $signmsgval = $this->append_param($signmsgval, "payerContact", $payer_contact);
        $signmsgval = $this->append_param($signmsgval, "orderId", $order_id);
        $signmsgval = $this->append_param($signmsgval, "orderAmount", $order_amount);
        $signmsgval = $this->append_param($signmsgval, "orderTime", $order_time);
        $signmsgval = $this->append_param($signmsgval, "productName", $product_name);
        $signmsgval = $this->append_param($signmsgval, "productNum", $product_num);
        $signmsgval = $this->append_param($signmsgval, "productId", $product_id);
        $signmsgval = $this->append_param($signmsgval, "productDesc", $product_desc);
        $signmsgval = $this->append_param($signmsgval, "ext1", $ext1);
        $signmsgval = $this->append_param($signmsgval, "ext2", $ext2);
        $signmsgval = $this->append_param($signmsgval, "payType", $pay_type);
        $signmsgval = $this->append_param($signmsgval, "bankId", $bank_id);
        $signmsgval = $this->append_param($signmsgval, "redoFlag", $redo_flag);
        $signmsgval = $this->append_param($signmsgval, "pid", $pid);
        $signmsgval = $this->append_param($signmsgval, "key", $key);
        $signmsg    = strtoupper(md5($signmsgval));    //签名字符串 不可空


        $def_url  = '<div style="text-align:center"><form name="kqPay" style="text-align:center;" method="post" action="https://www.99bill.com/gateway/recvMerchantInfoAction.htm" target="_blank">';
        $def_url .= "<input type='hidden' name='inputCharset' value='" . $input_charset . "' />";
        $def_url .= "<input type='hidden' name='bgUrl' value='" . $bg_url . "' />";
        $def_url .= "<input type='hidden' name='pageUrl' value='" . $page_url . "' />";
        $def_url .= "<input type='hidden' name='version' value='" . $version . "' />";
        $def_url .= "<input type='hidden' name='language' value='" . $language . "' />";
        $def_url .= "<input type='hidden' name='signType' value='" . $sign_type . "' />";
        $def_url .= "<input type='hidden' name='signMsg' value='" . $signmsg . "' />";
        $def_url .= "<input type='hidden' name='merchantAcctId' value='" . $merchant_acctid . "' />";
        $def_url .= "<input type='hidden' name='payerName' value='" . $payer_name . "' />";
        $def_url .= "<input type='hidden' name='payerContactType' value='" . $payer_contact_type . "' />";
        $def_url .= "<input type='hidden' name='payerContact' value='" . $payer_contact . "' />";
        $def_url .= "<input type='hidden' name='orderId' value='" . $order_id . "' />";
        $def_url .= "<input type='hidden' name='orderAmount' value='" . $order_amount . "' />";
        $def_url .= "<input type='hidden' name='orderTime' value='" . $order_time . "' />";
        $def_url .= "<input type='hidden' name='productName' value='" . $product_name . "' />";
        $def_url .= "<input type='hidden' name='payType' value='" . $pay_type . "' />";
        $def_url .= "<input type='hidden' name='productNum' value='" . $product_num . "' />";
        $def_url .= "<input type='hidden' name='productId' value='" . $product_id . "' />";
        $def_url .= "<input type='hidden' name='productDesc' value='" . $product_desc . "' />";
        $def_url .= "<input type='hidden' name='ext1' value='" . $ext1 . "' />";
        $def_url .= "<input type='hidden' name='ext2' value='" . $ext2 . "' />";
        $def_url .= "<input type='hidden' name='bankId' value='" . $bank_id . "' />";
        $def_url .= "<input type='hidden' name='redoFlag' value='" . $redo_flag ."' />";
        $def_url .= "<input type='hidden' name='pid' value='" . $pid . "' />";
        $def_url .= "<input type='submit' name='submit' value='用快钱支付' />";
        $def_url .= "</form></div></br>";

        return $def_url;
    }

    /**
     * 响应操作
     */
    public function respond(){
        $merchant_acctid     = $this->config['kq_account'];                 //人民币账号 不可空
        $key                 = $this->config['kq_key'];
        $get_merchant_acctid = trim($get['merchantAcctId']);
        $pay_result          = trim($get['payResult']);
        $version             = trim($get['version']);
        $language            = trim($get['language']);
        $sign_type           = trim($get['signType']);
        $pay_type            = trim($get['payType']);
        $bank_id             = trim($get['bankId']);
        $order_id            = trim($get['orderId']);
        $order_time          = trim($get['orderTime']);
        $order_amount        = trim($get['orderAmount']);
        $deal_id             = trim($get['dealId']);
        $bank_deal_id        = trim($get['bankDealId']);
        $deal_time           = trim($get['dealTime']);
        $pay_amount          = trim($get['payAmount']);
        $fee                 = trim($get['fee']);
        $ext1                = trim($get['ext1']);
        $ext2                = trim($get['ext2']);
        $err_code            = trim($get['errCode']);
        $sign_msg            = trim($get['signMsg']);

        //生成加密串。必须保持如下顺序。
        $merchant_signmsgval = '';
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"merchantAcctId",$merchant_acctid);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"version",$version);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"language",$language);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"signType",$sign_type);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"payType",$pay_type);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"bankId",$bank_id);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"orderId",$order_id);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"orderTime",$order_time);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"orderAmount",$order_amount);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"dealId",$deal_id);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"bankDealId",$bank_deal_id);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"dealTime",$deal_time);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"payAmount",$pay_amount);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"fee",$fee);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"ext1",$ext1);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"ext2",$ext2);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"payResult",$pay_result);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"errCode",$err_code);
        $merchant_signmsgval = $this->append_param($merchant_signmsgval,"key",$key);
        $merchant_signmsg    = md5($merchant_signmsgval);

        //首先对获得的商户号进行比对
        if ($get_merchant_acctid != $merchant_acctid){
            //商户号错误
            return false;
        }

        if (strtoupper($sign_msg) == strtoupper($merchant_signmsg)){
            if ($pay_result == 10 || $pay_result == 00)
            {
                $return_data['order_id'] = $receive_data['order_id'];
			    $return_data['order_total'] = $receive_data['order_amount'];
				$return_data['order_status'] = '0';
                return $return_data;
            }
            else
            {
                //'支付结果失败';
                return false;
            }

        }
        else
        {
            //'密钥校对错误';
            return false;
        }
    }

    /**
    * 将变量值不为空的参数组成字符串
    * @param   string   $strs  参数字符串
    * @param   string   $key   参数键名
    * @param   string   $val   参数键对应值
    */
    public function append_param($strs,$key,$val){
        if($strs != "")
        {
            if($key != '' && $val != '')
            {
                $strs .= '&' . $key . '=' . $val;
            }
        }
        else
        {
            if($val != '')
            {
                $strs = $key . '=' . $val;
            }
        }
            return $strs;
    }

}

?>