<?php
/**
 * 贝宝插件
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-5
 */

class paypal{
	public $config = array()  ;

    public function __construct($config=array()) {
        $this->config = $config;
		$this->config['return_url'] =  return_url('paypal');
    }

    public function pay_info(){
        /* 名称 */
        $pay['name']    = '贝宝';

		/* 代码 */
        $pay['code']    = basename(__FILE__, '.php');

        /* 是否支持货到付款 */
        $pay['is_cod']  = '0';

        /* 是否支持在线支付 */
        $pay['is_online']  = '1';

        /* 作者 */
        $pay['author']  = '天之骄子';

        /* 网址 */
        $pay['website'] = 'http://www.wufar.cn';

        /* 版本号 */
        $pay['version'] = '1.0.0';

        /* 配置信息 */
        $pay['config'] = array(
            array('name' => 'paypal_account', 'type' => 'text', 'value' => ''),
            array('name' => 'paypal_currency', 'type' => 'select', 'value' => 'USD')
        );

		return $pay;
    }

	/**
     * 提交函数
     */
    public function pay_form(){
        return '';
    }

	/**
     * 提交函数
     */
    public function pay_url(){
        return '';
    }


    /**
     * 生成支付代码
     * @param   array   $order  订单信息
     */
    public function get_code($order){
        $data_order_id      = $order['order_sn'];
        $data_amount        = $order['order_amount'];
        $data_return_url    = $this->config['return_url'];
        $data_pay_account   = $this->config['paypal_account'];
        $currency_code      = $this->config['paypal_currency'];
        $data_notify_url    = $this->config['return_url'];
        $cancel_return      = $this->config['return_url']; //取消返回

        $def_url  = '<br /><form style="text-align:center;" action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">' .   // 不能省略
            "<input type='hidden' name='cmd' value='_xclick'>" .                             // 不能省略
            "<input type='hidden' name='business' value='$data_pay_account'>" .                 // 贝宝帐号
            "<input type='hidden' name='item_name' value='$order[order_sn]'>" .                 // payment for
            "<input type='hidden' name='amount' value='$data_amount'>" .                        // 订单金额
            "<input type='hidden' name='currency_code' value='$currency_code'>" .            // 货币
            "<input type='hidden' name='return' value='$data_return_url'>" .                    // 付款后页面
            "<input type='hidden' name='invoice' value='$data_order_id'>" .                      // 订单号
            "<input type='hidden' name='charset' value='utf-8'>" .                              // 字符集
            "<input type='hidden' name='no_shipping' value='1'>" .                              // 不要求客户提供收货地址
            "<input type='hidden' name='no_note' value=''>" .                                  // 付款说明
            "<input type='hidden' name='notify_url' value='$data_notify_url'>" .
            "<input type='hidden' name='rm' value='2'>" .
            "<input type='hidden' name='cancel_return' value='$cancel_return'>" .
            "<input type='submit' value='用贝宝支付'>" .                      // 按钮
            "</form><br />";

        return $def_url;
    }

    /**
     * 响应操作
     */
    function respond(){
        $merchant_id    = $this->config['paypal_account'];               ///获取商户编号

        // read the post from PayPal system and add 'cmd'
        $req = 'cmd=_notify-validate';
        foreach ($_POST as $key => $value)
        {
            $value = urlencode(stripslashes($value));
            $req .= "&$key=$value";
        }

        // post back to PayPal system to validate
        $header = "POST /cgi-bin/webscr HTTP/1.0\r\n";
        $header .= "Content-Type: application/x-www-form-urlencoded\r\n";
        $header .= "Content-Length: " . strlen($req) ."\r\n\r\n";
        $fp = fsockopen ('www.paypal.com', 80, $errno, $errstr, 30);

        // assign posted variables to local variables
        $item_name = $get['item_name'];
        $item_number = $get['item_number'];
        $payment_status = $get['payment_status'];
        $payment_amount = $get['mc_gross'];
        $payment_currency = $get['mc_currency'];
        $txn_id = $get['txn_id'];
        $receiver_email = $get['receiver_email'];
        $payer_email = $get['payer_email'];
        $order_sn = $get['invoice'];
        $memo = !empty($get['memo']) ? $get['memo'] : '';
        $action_note = $txn_id . '（paypal 交易号）' . $memo;

        if (!$fp){
            fclose($fp);

            return false;
        } else {
            fputs($fp, $header . $req);
            while (!feof($fp)){
                $res = fgets($fp, 1024);
                if (strcmp($res, 'VERIFIED') == 0)
                {
                    // check the payment_status is Completed
                    if ($payment_status != 'Completed' && $payment_status != 'Pending')
                    {
                        fclose($fp);

                        return false;
                    }

                    // check that receiver_email is your Primary PayPal email
                    if ($receiver_email != $merchant_id)
                    {
                        fclose($fp);

                        return false;
                    }


                    if ($this->config['paypal_currency'] != $payment_currency)
                    {
                        fclose($fp);

                        return false;
                    }

					$return_data['order_id'] = $order_sn;
			        $return_data['order_total'] = $payment_amount;
				    $return_data['order_status'] = '0';
                    fclose($fp);

                    return $return_data;
                }
                elseif (strcmp($res, 'INVALID') == 0)
                {
                    // log for manual investigation
                    fclose($fp);

                    return false;
                }
            }
        }
    }
}

?>