<?php
/**
 * 财付通支付
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-5
 */
class tenpay{
    public $config = array()  ;

    public function __construct($config=array()) {
        $this->config = $config;
		$this->config['return_url'] =  return_url('tenpay');
		$this->config['gateway_url'] = 'https://gw.tenpay.com/gateway/pay.htm';

    }

    public function pay_info(){
        /* 名称 */
        $pay['name']    = '财付通';

		/* 代码 */
        $pay['code']    = basename(__FILE__, '.php');

		$pay['desc']    = '<b>财付通（www.tenpay.com） - 腾讯旗下在线支付平台，通过国家权威安全认证，支持各大银行网上支付，免支付手续费。</b><br /><a href="http://cloud.ecshop.com/payment_apply.php?mod=tenpay&par=1202822001" target="_blank">立即免费申请：单笔费率1%</a><br /><a href="http://cloud.ecshop.com/payment_apply.php?mod=tenpay&par=1442037873" target="_blank">立即购买包量套餐：折算后单笔费率0.6-1%</a>';

        /* 是否支持货到付款 */
        $pay['is_cod']  = '0';

        /* 是否支持在线支付 */
        $pay['is_online']  = '1';

        /* 作者 */
        $pay['author']  = '天之骄子';

        /* 网址 */
        $pay['website'] = 'http://www.wufar.cn';

        /* 版本号 */
        $pay['version'] = '1.0.0';

        /* 配置信息 */
        $pay['config']  = array(
            array('name' => 'tenpay_account',   'type' => 'text', 'value' => ''),
            array('name' => 'tenpay_key',       'type' => 'text', 'value' => ''),
            array('name' => 'magic_string',     'type' => 'text', 'value' => '')
        );

		return $pay;
    }

    /**
     * 生成支付表单
     * @param   array    $order       订单信息
     */
    public function pay_form($order){
		$this->getpreparedata($order);
		$button  = '<form action="'.$this->config['gateway_url'].'" method="post" target="_blank">';
        foreach ($this->parameters AS $key=>$value){
        	$button  .= "<input type='hidden' name=\"$key\" value=\"$value\" />\n";
        }
		$button.= "<input type=\"submit\" value=\"财付通支付\">";
		$button.= "</form>";
        return $button;	
    }



	/**
	*获取带参数的请求URL
	* @param   array    $order       订单信息
	*/
	public function pay_url($order) {
		$this->getpreparedata($order);
		$reqPar = "";
		ksort($this->parameters);
		reset($this->parameters);
		foreach($this->parameters as $k => $v) {
			$reqPar .= $k . "=" . urlencode($v) . "&";
		}
		//去掉最后一个&
		$reqPar = substr($reqPar, 0, strlen($reqPar)-1);
		
		$pay_url = $this->config['gateway_url'] . "?" . $reqPar;
		
		return $pay_url;
		
	}

	/**
     * 响应操作
     */
    public function respond($get){

		$attach         = $get['attach'];
        $trade_state    = $get['trade_state'];
        $total_fee      = $get['total_fee'];
        $out_trade_no = trim($get['out_trade_no']);
		/* 检查数字签名是否正确 */
        ksort($get);
        reset($get);

        $sign = '';
        foreach ($get AS $key => $val){
            if("" != $val && "sign" != $key && $key != 'code' && $key != 'ispost') {
                $sign  .= "$key=$val&";
            }
        }
        $sign .= "key=".$this->config['tenpay_key'];
    
        if (strtolower(md5($sign)) == strtolower($get['sign']) && $this->Verification($get['notify_id'])){
            if($trade_state==0){
				$return_data['order_id'] = $out_trade_no;
			    $return_data['order_total'] = $total_fee / 100;
				$return_data['order_status'] = '0';
				if($get['ispost'] == '1') echo 'success';
                return $return_data;
            } 
        } else {
            if($get['ispost'] == '1') echo 'fail';
			return false;
        }

    }

	/**
	*设置参数值
	*/
	private function setParameter($parameter, $parameterValue) {
		$this->parameters[$parameter] = $parameterValue;
	}

    /**
     * 生成参数数组
     * @param   array    $order       订单信息
     */
    private function getpreparedata($order){

		/* 获取提交的订单号 */
		$out_trade_no = $order["order_sn"];
		/* 获取提交的商品名称 */
		$product_name = $order["name"];
		/* 获取提交的商品价格 */
		$order_price = $order["order_amount"];
		/* 获取提交的备注信息 */
		$remarkexplain = $order["body"];
		/* 支付方式 */
		$trade_mode=$this->config["trade_mode"];

		/* 银行类型:支持纯网关和财付通 */
		if($order['bank_type']){
			$bank_type = $order['bank_type'];
		} else {
			$bank_type = 'DEFAULT';
		}
        $spbill_create_ip = get_client_ip(); //用户ip

		/* 商品价格（包含运费），以分为单位 */
		$total_fee = $order_price*100;

		/* 商品名称 */
		$desc = "商品：".$product_name.",备注:".$remarkexplain;



		//----------------------------------------
		//设置支付参数 
		//----------------------------------------
		$this->setParameter("partner", $this->config['tenpay_account']);
		$this->setParameter("out_trade_no", $out_trade_no);
		$this->setParameter("total_fee", intval($total_fee));  //总金额
		$this->setParameter("return_url", $this->config['return_url']);
		$this->setParameter("notify_url", $this->config['return_url']);
		$this->setParameter("body", $desc);
		$this->setParameter("bank_type", $bank_type);  	  //银行类型，默认为财付通
		//用户ip
		$this->setParameter("spbill_create_ip", $spbill_create_ip);//客户端IP
		$this->setParameter("fee_type", "1");               //币种
		$this->setParameter("subject",$desc);          //商品名称，（中介交易时必填）

		//系统可选参数
		$this->setParameter("sign_type", "MD5");  	 	  //签名方式，默认为MD5，可选RSA
		$this->setParameter("service_version", "1.0"); 	  //接口版本号
		$this->setParameter("input_charset", "utf-8");   	  //字符集
		$this->setParameter("sign_key_index", "1");    	  //密钥序号

		//业务可选参数
		$this->setParameter("attach", "");             	  //附件数据，原样返回就可以了
		$this->setParameter("product_fee", "");        	  //商品费用
		$this->setParameter("transport_fee", "0");        //物流费用
		$this->setParameter("time_start", date("YmdHis"));  //订单生成时间
		$this->setParameter("time_expire", "");             //订单失效时间
		$this->setParameter("buyer_id", "");                //买方财付通帐号
		$this->setParameter("goods_tag", "");               //商品标记
		$this->setParameter("trade_mode",$this->config['trade_mode']);  //交易模式
		$this->setParameter("transport_desc","");              //物流说明
		$this->setParameter("trans_type","1");              //交易类型
		$this->setParameter("agentid","");                  //平台ID
		$this->setParameter("agent_type","");               //代理模式
		$this->setParameter("seller_id","");                //卖家的商户号
		$this->createSign();
    }


	/**
	*创建md5摘要,规则是:按参数名称a-z排序,遇到空值的参数不参加签名。
	*/
	private function createSign() {
		$signPars = "";
		ksort($this->parameters);
		reset($this->parameters);
		foreach($this->parameters as $k => $v) {
			if("" != $v && "sign" != $k) {
				$signPars .= $k . "=" . $v . "&";
			}
		}
		$signPars .= "key=".$this->config['tenpay_key'];
		$sign = strtolower(md5($signPars));
		$this->setParameter("sign", $sign);
	
	}

    

	private function Verification($notify_id){
        $tenpay_url="https://gw.tenpay.com/gateway/simpleverifynotifyid.xml";
		$send_str['input_charset'] = 'UTF-8';
        $send_str['partner']=$this->config['tenpay_account'];
        $send_str['notify_id']=$notify_id;
	    ksort($send_str);
        $sign_notify = '';
        foreach ($send_str AS $key => $val)
        {
            if("" != $val && "sign" != $key) 
			{
                $sign_notify  .= "$key=$val&";
            }
        }
        
		$sign_notify .= "key=".$this->config['tenpay_key'];
		$send_str['sign']=strtolower(md5($sign_notify));

		//载入HTTP类
        import('HTTP');
        $this->https = new Http();
        $data = $this->https->execute($tenpay_url, 'POST', $send_str, $header, $timeout = '30');
		preg_match_all( "/<retcode>([0-9]+)<\/retcode>/", $data, $retcode);
		if($retcode['1']['0']==0){
           return true;
		} else {
           return false;
		}

	}

}

?>