<?php

/**
 * 银联在线支付
 */


/**
 * 类
 */
class upop{
	public $config = array()  ;

    public function __construct($config=array()) {
        $this->config = $config;
		$this->config['return_url'] =  return_url('upop');
		// 线上环境
		//$this->config['gateway_url'] = 'https://unionpaysecure.com/api/Pay.action';
		//$this->config['query_url'] = 'https://unionpaysecure.com/api/Query.action';
		//测试环境
		$this->config['gateway_url'] = 'http://58.246.226.99/UpopWeb/api/Pay.action';
		$this->config['query_url'] = 'http://58.246.226.99/UpopWeb/api/Query.action';
    }
    
    public function pay_info(){
		/* 名称 */
        $pay['name']    = '银联在线';

        /* 代码 */
        $pay['code']    = basename(__FILE__, '.php');

        /* 是否支持货到付款 */
        $pay['is_cod']  = '0';

        /* 是否支持在线支付 */
        $pay['is_online']  = '1';

        /* 作者 */
        $pay['author']  = '天之骄子';

        /* 网址 */
        $pay['website'] = 'http://www.wufar.cn';

        /* 版本号 */
        $pay['version'] = '1.0.0';

        /* 配置信息 */
        $pay['config'] = array(
            array('name' => 'upop_merAbbr', 'type' => 'text', 'value' => '商户名称'),
            array('name' => 'upop_account', 'type' => 'text', 'value' => ''),
            array('name' => 'upop_security_key', 'type' => 'text', 'value' => ''),
        );

		return $pay;
    }	

	/**
     * 提交函数
     */
    public function pay_form($order){
		$parameters = $this->getpreparedata($order);
        $button = "<form style=\"text-align:center;\" id=\"pay_form\" name=\"pay_form\" action=\"".$this->config['gateway_url']."\" method=\"post\" target=\"_blank\">\n";
        foreach ($parameters as $key => $value){
            $button .= " <input type=\"hidden\" name=\"{$key}\" id=\"{$key}\" value=\"{$value}\" />\n";
        }
		$button .= "<input type='submit' value='银联支付' />\n";
        $button .= "</form>";
        return $button;
    }

	/**
	*获取带参数的请求URL
	* @param   array    $order       订单信息
	*/
	public function pay_url($order) {
		$parameters = $this->getpreparedata($order);
		$reqPar = "";
		ksort($parameters);
		reset($parameters);
		foreach($parameters as $k => $v) {
			$reqPar .= $k . "=" . urlencode($v) . "&";
		}
		//去掉最后一个&
		$reqPar = substr($reqPar, 0, strlen($reqPar)-1);
		
		$pay_url = $this->config['gateway_url'] . "?" . $reqPar;
		
		return $pay_url;
		
	}

	/**
     * 生成支付代码
     * @param   array   $order  订单信息
     * @param   array   $payment    支付方式信息
     */

    private function getpreparedata($order){
        $security_key          = $this->config['upop_security_key'];
        $merId                 = $this->config['upop_account'];
        $orderNumber           = $order['order_sn'];	
        $frontEndUrl           = $this->config['return_url'];
        $backEndUrl            = $this->config['return_url'];
        $merAbbr               = $this->config['upop_merAbbr'];

        $params = array(
                "version"            =>  '1.0.0',                      //接口版本
                "signMethod"         =>  'md5',                        //加密方式
                "charset"            =>  'UTF-8',                     //编码
                "transType"          =>  '01',                         //交易类型
                "origQid"            =>  '',
                "merId"              =>  $merId,                       //收款账号
                "merAbbr"            =>  $merAbbr,                     //商户名称
                "acqCode"            =>  '',
                "merCode"            =>  '',
                "commodityUrl"       =>  '',                           //商品url
                "commodityName"      =>  '',                           //商品名字
                "commodityUnitPrice" =>  '',                           //商品单价
                "commodityQuantity"  =>  '',                           //商品数量
                "commodityDiscount"  =>  '',
                "transferFee"        =>  '',
                "orderNumber"        =>  $orderNumber,                 //订单号，必须唯一
                "orderAmount"        =>  $order['order_amount'] * 100, //交易金额 转化为分
                "orderCurrency"      =>  '156',                        //交易币种，CURRENCY_CNY=>人民币
                "orderTime"          =>  date('YmdHis'),               //交易时间, YYYYmmhhddHHMMSS
                "customerIp"         =>  $_SERVER['REMOTE_ADDR'],      //用户IP
                "customerName"       =>  '',
                "defaultPayType"     =>  '',
                "defaultBankNumber"  =>  '',
                "transTimeout"       =>  '',
                "frontEndUrl"        =>  $frontEndUrl,                 // 前台回调URL
                "backEndUrl"         =>  $backEndUrl,                  // 后台回调URL
                "merReserved"        =>  ''             
        );
        $params['signature']    =$this->sign($params, $security_key,'md5');
        return $params;
    }

    /**
     * 响应操作
     */
    public function respond($get){
		$arr_args = array();
        $arr_reserved = array();

        if (is_array($get)){
            $arr_args       = $get;
            $cupReserved    = isset($arr_args['cupReserved']) ? $arr_args['cupReserved'] : '';
            parse_str(substr($cupReserved, 1, -1), $arr_reserved); //去掉前后的{}
        } else {
            $cupReserved = '';
            $pattern = '/cupReserved=(\{.*?\})/';
            if (preg_match($pattern, $get, $match)) { //先提取cupReserved
                $cupReserved = $match[1];
            }
            //将cupReserved的value清除(因为含有&, parse_str没法正常处理)
            $args_r         = preg_replace($pattern, 'cupReserved=', $get);
            parse_str($args_r, $arr_args);
            $arr_args['cupReserved'] = $cupReserved;
            parse_str(substr($cupReserved, 1, -1), $arr_reserved); //去掉前后的{}
        }
		$arr_ret = array_merge($arr_args, $arr_reserved);
        unset($arr_ret['cupReserved']);

     
        //验证签名
        $signature=$this->sign($arr_args, $this->config['upop_security_key'],'md5');
        if ($signature == $arr_args['signature'] && $this->config['upop_account'] == $arr_ret['merId']) {
			//验证支付信息
			$param['version']    = '1.0.0';
			$param['signMethod']    = 'md5';
			$param['charset']    = 'UTF-8';
			$param['transType']    = '01';
			$param['merId']    = $this->config['upop_account'];
			$param['orderNumber']    = $arr_ret['orderNumber'];
			$param['orderTime']    = substr($arr_ret['orderNumber'], 0, -5);
			$param['merReserved']    = '';
        	$param['signature']    =$this->sign($param, $this->config['upop_security_key'],'md5');

			//载入HTTP类
        	import('HTTP');
        	$this->https = new Http();
        	$verify_data = $this->https->execute($this->config['query_url'], 'POST', $param);
			if (is_array($verify_data)){
            	$ret_args       = $verify_data;
            	$ret_cupReserved    = isset($ret_args['cupReserved']) ? $ret_args['cupReserved'] : '';
            	parse_str(substr($ret_cupReserved, 1, -1), $ret_reserved); //去掉前后的{}
        	} else {
            	$ret_cupReserved = '';
            	$ret_pattern = '/cupReserved=(\{.*?\})/';
            	if (preg_match($ret_pattern, $verify_data, $match)) { //先提取cupReserved
                	$ret_cupReserved = $match[1];
            	}
            	//将cupReserved的value清除(因为含有&, parse_str没法正常处理)
            	$ret_r         = preg_replace($ret_pattern, 'cupReserved=', $verify_data);
            	parse_str($ret_r, $ret_args);
            	$ret_args['cupReserved'] = $ret_cupReserved;
            	parse_str(substr($ret_cupReserved, 1, -1), $ret_reserved); //去掉前后的{}
        	}
			$result = array_merge($ret_args, $ret_reserved);
        	unset($result['cupReserved']);

			$return_data['order_id'] = $arr_ret['orderNumber'];
			$return_data['order_total'] = intval($result['settleAmount']/100);
			if($arr_ret['respCode'] == '00' && $result['respCode'] == '00'){
				$return_data['order_status'] = '0';
                return $return_data;
			}
        } else {
			return false;
		}


            

          

    }


    private function sign($params,$security_key,$sign_method){
        if (strtolower($sign_method) == "md5") {
            ksort($params);
            $sign_str = "";
            $sign_ignore_params=array('bank','signMethod','signature','ispost','code');
            foreach ($params as $key => $val){
                if (in_array($key,$sign_ignore_params)) {
                    continue;
                }
                $sign_str .= sprintf("%s=%s&", $key, $val);
            }
            return md5($sign_str . md5($security_key));
        } else {
            exit("Unknown sign_method set in quickpay_conf");
        }
    }

}
?>