<?php

/**
 * 支付service
 * @author     天之骄子
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-8-11
 * @updateTime 2013-8-11
 */
class PaymentService extends BaseService {

    protected $paymentModel;

    function __construct() {
        parent::__construct();
        $this->paymentModel = D('Payment');
    }

	/**
	*重定向到第三方支付
	*/
	public function doSend($order_id,$pay_code) {
		header("Location:" . $this->get_url($order_id,$pay_code));
		exit;
	}

    /**
     * 获取支付连接
     * @param type $order       订单ID
	 * @param type $pay_code    支付方式
     * @return type             返回查询结果
     */
    public function get_form($order_id,$pay_code) {
		$form_data = $this->get_order($order_id,'pay_form',$pay_code);
		return $form_data;

    }

	/**
     * 获取支付连接
     * @param type $order       订单ID
	 * @param type $pay_code    支付方式
     * @return type             返回查询结果
     */
    public function get_url($order_id,$pay_code) {
		$url_data = $this->get_order($order_id,'pay_url',$pay_code);
		return $url_data;
    }


     /**
	 * 更新订单状态
	 * @param unknown_type $trade_sn 订单ID
	 * @param unknown_type $status 订单状态
	 */
	public function update_trade($trade_sn,$status) {
		$trade_sn = trim($trade_sn);
		$status = trim(intval($status));
		$data = array();
		//返回订单状态
		$status = $this->return_status($status);
		return $status;
	}

	// 日志消息,把支付返回的参数记录下来
	public function  log_result($pay_code,$data) {
	    $files = APP_PATH . C('APP_GROUP_PATH').DS.GROUP_NAME.DS.'ORG'.DS.'log'.DS.$pay_code.'.php';
		if (is_array($data)){
			$str = "";
			foreach($data as $k => $v) {
				$str .= $k . "=" . $v . ",";
			}
		}
		if(!file_exists($files)){
			touch($files);
			$fp = fopen($files,"a");
	    	flock($fp, LOCK_EX) ;
	    	fwrite($fp, '<?php exit(\'\');?>'."\n".'执行日期'."：".strftime("%Y%m%d%H%M%S",time())."\n".getCurrentUrl()."\n".'其他参数：'.$str."\n\n\n");
	    	flock($fp, LOCK_UN);
	    	fclose($fp);
		}else{
			$fp = fopen($files,"a");
	    	flock($fp, LOCK_EX) ;
	    	fwrite($fp, '执行日期'."：".strftime("%Y%m%d%H%M%S",time())."\n".getCurrentUrl()."\n".'其他参数：'.$str."\n\n\n");
	    	flock($fp, LOCK_UN);
	    	fclose($fp);
		}
	}

	/**
     * 获取订单信息
     * @param type $order       订单ID
	 * @param type $pay_code    支付方式
     * @return type             返回查询结果
     */
    private function get_order($order_id,$get_type,$pay_code) {
		//TODO获取订单信息

		//获取支付信息
		$paymentinfo = $this->paymentModel->where(array('pay_code' => $pay_code))->find();
		$paymentinfo['pay_config'] = unserialize($paymentinfo['pay_config']);

		//计算手续费用
		$pay_fee = $this->pay_fee($order_id['price'], $paymentinfo['pay_fee'], $paymentinfo['pay_config']['fee_method']);

		//总额＝订单总额＋手续费
		$order_id['order_amount'] = intval($order_id['price'] + $pay_fee);

		//初始化支付类
		import("@.ORG.".$paymentinfo['pay_code'],'','.php');
		$pay = new $paymentinfo['pay_code']($paymentinfo['pay_config']);
		$pay_data = $pay->$get_type($order_id);

		return $pay_data;
    }


	/**
	 * 通过订单ID抓取用户信息
	 * @param unknown_type $trade_sn
	 */
	private function get_userinfo_by_sn($trade_sn) {
		$trade_sn = trim($trade_sn);

	}

	/**
 	* 返回订单状态
 	*/
	private function return_status($status) {
		$trade_status = array('0'=>'success', '1'=>'fail', '2'=>'timeout', '3'=>'progress', '4'=>'unpay', '5'=>'cancel','6'=>'error');
		return $trade_status[$status];
	}
	/**
	 * 返回订单手续费
	 * @param  $amount 订单价格
	 * @param  $fee 手续费比率
	 * @param  $method 手续费方式
	 */
	private function pay_fee($amount, $fee=0, $method=0) {
	    $pay_fee = 0;
	    if($method == 0) {
	    	$val = floatval($fee) / 100;
 		   	$pay_fee = $val > 0 ? $amount * $val : 0;
	    } elseif($method == 1) {
 	       $pay_fee = $fee;
 	   }
	    return round($pay_fee, 2);
	}
}

?>
