<?php

/**
 * 搜索IndexAction
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-11-22
 * @updateTime 2013-11-22
 */
class IndexAction extends FrontBaseAction {

    protected $config, $searchModel, $searchKeywordModel;

    public function _initialize() {
        parent::_initialize();
        $this->searchKeywordModel = D('SearchKeyword');
        $this->config = BService('Module')->getModuleSetting('Search');
    }

    /**
     * 搜索
     */
    public function index() {
        //TODO:seo
        $get = $this->_get();
        if (isset($get['keyword']) && strlen($get['keyword'])) {
            $keyword = Input::forSearch(trim($get['keyword']));
            $separator = '&&';
            //搜索历史
            $searchHistory = cookie('searchHistory') ? cookie('searchHistory') : NULL;
            $searchHistoryArray = array();
            if ($searchHistory) {
                $searchHistoryArray = explode($separator, $searchHistory);
            }
            array_unshift($searchHistoryArray, urlencode(bpiHtmlspecialcharsDecode($keyword)));
            $assignSearchHistory = array_slice(array_filter(array_unique($searchHistoryArray), 'strlen'), 0, 10);
            cookie('searchHistory', $separator . implode($separator, $assignSearchHistory) . $separator, 604800);
            $this->assign('searchHistory', $assignSearchHistory);
            $this->assign('keyword', $keyword);

            //每页显示条数
            $pageSize = $this->config['page_size'] ? $this->config['page_size'] : 10;
            //缓存时间
            $cacheTime = intval($this->config['cache_time']);

            //是否开启sphinx
            if ($this->config['sphinx_status']) {
                //TODO:
            } else {
                //TODO:暂时不清楚有什么用，而且慢死了
                /* $segmentResult = NULL;
                  //开启分词
                  if ($this->config['segment_status']) {
                  import('@.ORG.Segment.Segment');
                  $segmentClass = new Segment();
                  $segmentResult = $segmentClass->get_keyword($segmentClass->split_result($keyword));  //分词结果
                  } */

                $map = array();
                $map['title|keyword'] = array('like', "%{$keyword}%");
                $modelList = setArrayIndexByKey(D('Model')->getModelByType(C('MODEL_TYPE.APPLICATION')), 'table_name');
                $modelId = 0;
                //搜索出APP应用的是哪个模型
                foreach ($modelList as $_modelItem) {
                    if (!$_modelItem['pid']) {
                        $modelId = $_modelItem['model_id'];
                    }
                }
                if (!$modelId) {
                    $this->error('系统错误');
                }

                $this->searchModel = new AutoRelationModel(D('Model')->getModelTableName($modelId));

                //查询结果缓存
                if ($cacheTime) {
                    $count = $this->searchModel->cache(true, $cacheTime)->where($map)->count();
                } else {
                    $count = $this->searchModel->where($map)->count();
                }
                $page = page($count, $pageSize);
                if ($count) {
                    $resultList = $this->searchModel->relation(true)->where($map)->limit($page->firstRow, $page->listRows)->order('update_time DESC, id DESC')->select();
                } else {
                    $resultList = array();
                }
                $this->assign('page', $page->frontShow());
            }

            //搜索记录处理
            /* if (strlen($keyword) < 17 && strlen($keyword) > 1 && $resultList) {
              $keywordResult = $this->searchKeywordModel->where(array('keyword' => $keyword))->find();
              if ($keywordResult) {
              $this->searchKeywordModel->where(array('keyword' => $keyword))->setInc('search_count');
              } else {
              //关键词转拼音
              import('Pinyin');
              $pinyin = Pinyin::utf8_to_pinyin($keyword);
              if (is_array($pinyin)) {
              $pinyin = implode('', $pinyin);
              }
              $addData = array(
              'keyword' => $keyword,
              'search_count' => 1,
              'data' => $segmentResult,
              'pinyin' => $pinyin,
              );
              $this->searchKeywordModel->add($addData);
              }
              }

              //关联搜索处理
              if ($this->config['reliation_search_status']) {
              $relationMap = array();
              if ($keyword) {
              $relationKeyword = str_replace(' ', '%', $keyword);
              } else {
              $relationKeyword = $keyword;
              }

              $relationMap['_string'] = " MATCH (`data`) AGAINST ('%$relationKeyword%' IN BOOLEAN MODE) ";
              $relationResult = $this->searchKeywordModel->where($relationMap)->select();
              $this->assign('reliationResultList', $relationResult);
              } */

            //格式化数据
            $applicationList = array();
            foreach ($resultList as $_item) {
                $_item = BService('MarketView', 'Index')->formatNormalApplicaition($_item);
                
                $hitInfo = BService('Hit')->getHit(C('ACCESS_TYPE.APPLICATION'), $_item['id'], NULL, C('HIT_FLAG.DOWNLOAD'));
                $_item['hit_count'] = intval($hitInfo[$_item['id']]['total_count']);
                $applicationList[] = $_item;
            }
            $this->assign('applicationList', $applicationList);

            //面包屑导航
            $config = BaseAction::getVar('config');
            $breadCrumbList = array(
                array('name' => $config['site_name'], 'url' => $config['site_url']),
                array('name' => '搜索 &quot;' . $keyword . '&quot; 结果', 'url' => '#'),
            );
            $this->assign('breadCrumbList', $breadCrumbList); //面包屑 
            $this->display();
        } else {
            redirect(SITE_URL);
        }
    }

    /**
     * 搜索首页
     */
    public function index2() {
        //SEO
        $seo = seo();
        $this->assign('seo', $seo);
        if (trim($this->_request('keyword')) && $this->_request('model_id')) {
            $request = $this->_request();
            $keyword = Input::forSearch(trim($request['keyword']));
            $modelId = intval($this->_request('model_id'));
            if (!in_array($modelId, $this->config['model_id_list'])) {
                header('Location: ' . U('Search/Index/index', array('keyword' => $keyword)));
                exit;
            }
            if (IS_POST) {
                header('Location: ' . U('Search/Index/index', array('model_id' => $modelId, 'keyword' => $keyword)));
                exit;
            }

            $searchHistory = cookie('searchHistory') ? cookie('searchHistory') : array();
            array_unshift($searchHistory, $keyword);
            $newSearchHistory = array_slice(array_unique($searchHistory), 0, 10);
            cookie('searchHistory', $newSearchHistory);

            //高级搜索条件
            $get = $this->_get();
            $time = $get['time'];
            //栏目id
            $categoryId = $get['category_id'] ? intval($get['category_id']) : NULL;

            $map = array();

            //每页显示条数
            $pageSize = $this->config['page_size'] ? $this->config['page_size'] : 10;
            //缓存时间
            $cacheTime = intval($this->config['cache_time']);
            //排序
            $order = array(
                'update_time' => 'DESC',
                'id' => 'DESC',
            );

            //按时间搜索
            if ($time) {
                switch ($time) {
                    case 'day':
                        $searchTime = time() - 86400;
                        break;
                    case 'week':
                        $searchTime = time() - 604800;
                        break;
                    case 'month':
                        $searchTime = time() - 2592000;
                        break;
                    case 'year':
                        $searchTime = time() - 86400;
                        break;
                    default:
                        break;
                }
                $map['update_time'] = array('GT', $searchTime);
            } else {
                $searchTime = 0;
            }

            //按模型搜索
            if ($modelId && in_array($modelId, $this->config['model_id_list'])) {
                $map['model_id'] = $modelId;
            }

            //按栏目搜索
            if ($categoryId) {
                $map['category_id'] = $categoryId;
            }


            //是否开启sphinx
            if ($this->config['sphinx_status']) {
                //TODO:
            } else {
                $segmentResult = NULL;

                if ($this->config['segment_status']) {//开启分词
                    import('@.ORG.Segment.Segment');
                    $segmentClass = new Segment();
                    //分词结果
                    $segmentResult = $segmentClass->get_keyword($segmentClass->split_result($keyword));
                }
//                if (!empty($segmentResult)) {
//                    $wordList = explode(' ', $segmentResult);
//                    $map['_string'] = " MATCH (`title`,`keyword`) AGAINST ('$segmentResult' IN BOOLEAN MODE) ";
//                } else {
                //自带模糊搜索
                //TODO:改用searchModel的data
                $map['title|keyword'] = array('like', "%{$keyword}%");
//                }
//                
                //指定模型
                $this->searchModel = new AutoRelationModel(D('Model')->getModelTableName($modelId));
                //查询结果缓存
                if ($cacheTime) {
                    //统计计算
                    $count = $this->searchModel->cache(true, $cacheTime)->where($map)->count();
                } else {
                    $count = $this->searchModel->where($map)->count();
                }
                $page = page($count, $pageSize);
                if ($count) {
                    $resultList = $this->searchModel->relation(true)->cache(true, $cacheTime)->where($map)->limit($page->firstRow, $page->listRows)->order($order)->select();
                } else {
                    $resultList = array();
                }
                $this->assign('page', $page->frontShow());
            }

            //搜索记录处理
            if (strlen($keyword) < 17 && strlen($keyword) > 1 && $resultList) {
                $keywordResult = $this->searchKeywordModel->where(array('keyword' => $keyword))->find();
                if ($keywordResult) {
                    //关键词搜索数+1
                    $this->searchKeywordModel->where(array('keyword' => $keyword))->setInc('search_count');
                } else {
                    //关键词转拼音
                    import('Pinyin');
                    $pinyin = Pinyin::utf8_to_pinyin($keyword);
                    if (is_array($pinyin)) {
                        $pinyin = implode('', $pinyin);
                    }
                    $addData = array(
                        'keyword' => $keyword,
                        'search_count' => 1,
                        'data' => $segmentResult,
                        'pinyin' => $pinyin,
                    );
                    $this->searchKeywordModel->add($addData);
                }
            }
            //关联搜索处理
            if ($this->config['reliation_search_status']) {
                $relationMap = array();
                if ($keyword) {
                    $relationKeyword = str_replace(' ', '%', $keyword);
                } else {
                    $relationKeyword = $keyword;
                }

                $relationMap['_string'] = " MATCH (`data`) AGAINST ('%$relationKeyword%' IN BOOLEAN MODE) ";
                $relationResult = $this->searchKeywordModel->where($relationMap)->select();
                $this->assign('reliationResultList', $relationResult);
            }

            //数据模型
            foreach ($this->config['model_id_list'] as $modelId) {
                $modelFieldList[$modelId] = array(
                    'name' => D('Model')->getModelTableName($modelId),
                    'model_id' => $modelId,
                );
            }
            //搜索结果
            $this->assign('resultList', $resultList);
            $this->assign('modelList', $modelFieldList);
            $this->assign('keyword', $keyword);
            //搜索历史记录
            $this->assign('searchHistory', $searchHistory);
            $this->display('search');
        } else {
            $this->display('index');
        }
    }

}

?>
