<?php

/**
 * 搜索管理Action
 * @author     bant
 * @copyright  (C) 2011-2013 BPICMS
 * @license    http://www.chinabpi.com/license/
 * @version    1.0
 * @createTime 2013-11-22
 * @updateTime 2013-11-22
 */
class SearchManageAction extends AdminBaseAction {

    protected $searchModel;

    public function _initialize() {
        parent::_initialize();
        $this->searchModel = D('Search');
    }

    /**
     * 配置管理
     */
    public function setting() {
        $moduleModel = M('Module');
        if (IS_POST) {
            $setting = $this->_post('setting');
            $data['setting'] = serialize($setting);
            if ($moduleModel->create()) {
                $result = $moduleModel->where(array('module' => 'Search'))->save($data);
                if ($result !== false) {
                    //TODO:更新配置缓存
                    $this->bpiAjaxReturn(true, '更新成功', array('type' => 'eval', 'data' => C('JAVASCRIPT_TYPE.REFRESH')), C('OPERATE_TYPE.OPERATE_UPDATE'));
                } else {
                    $this->bpiAjaxReturn(false, '更新失败', array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
                }
            } else {
                $this->bpiAjaxReturn(false, $moduleModel->getError(), array(), C('OPERATE_TYPE.OPERATE_UPDATE'));
            }
        } else {
            //获取非会员的模型列表
            $modelList = FData('Model');
            foreach ($modelList as $modelId => $_model) {
                if ($_model['type'] == C('MODEL_TYPE.MEMBER')) {
                    unset($modelList[$modelId]);
                }
            }
            $setting = BService('Module')->getModuleSetting('Search');
            $this->assign('modelList', $modelList);
            $this->assign('setting', $setting);
            $this->display();
        }
    }

}

?>
